package org.nuiton.jaxx.application.swing;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.jaxx.runtime.JAXXObject;

/**
 * Contract to place on each ui.
 *
 * Created on 11/23/13.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.8
 */
public interface ApplicationUI<M, H extends AbstractApplicationUIHandler<M, ?>> extends JAXXObject {

    M getModel();

    H getHandler();

    /**
     * Pattern to use for short numeric values in editors with max 1 digits.
     *
     * @since 0.2
     */
    String INT_1_DIGITS_PATTERN = "\\d{0,1}";

    /**
     * Pattern to use for short numeric values in editors with max 2 digits.
     *
     * @since 0.1
     */
    String INT_2_DIGITS_PATTERN = "\\d{0,2}";

    /**
     * Pattern to use for signed numeric values in editors with max 2 digits.
     *
     * @since 2.8
     */
    String SIGNED_INT_2_DIGITS_PATTERN = "-?\\d{0,2}";

    /**
     * Pattern to use for short numeric values in editors with max 3 digits.
     *
     * @since 0.1
     */
    String INT_3_DIGITS_PATTERN = "\\d{0,3}";

    /**
     * Pattern to use for singed numeric values in editors with max 3 digits.
     *
     * @since 2.8
     */
    String SIGNED_INT_3_DIGITS_PATTERN = "-?\\d{0,3}";

    /**
     * Pattern to use for short numeric values in editors with max 4 digits.
     *
     * @since 0.2
     */
    String INT_4_DIGITS_PATTERN = "\\d{0,4}";

    /**
     * Pattern to use for integer numeric values in editors with max 6 digits.
     *
     * @since 0.1
     */
    String INT_6_DIGITS_PATTERN = "\\d{0,6}";

    /**
     * Pattern to use for integer numeric values in editors with max 7 digits.
     *
     * @since 0.1
     */
    String INT_7_DIGITS_PATTERN = "\\d{0,7}";

    /**
     * Pattern to use for integer numeric values in editors with max 10 digits.
     *
     * @since 2.10
     */
    String INT_10_DIGITS_PATTERN = "\\d{0,10}";

    /**
     * Pattern to use for decimal numeric values with 1 decimal digits in
     * editors.
     *
     * @since 0.1
     */
    String DECIMAL1_PATTERN = "\\d{0,6}(\\.\\d{0,1})?";

    /**
     * Pattern to use for decimal numeric values with 2 decimal digits in
     * editors.
     *
     * @since 0.1
     */
    String DECIMAL2_PATTERN = "\\d{0,6}(\\.\\d{0,2})?";

    /**
     * Pattern to use for decimal numeric values with 3 decimal digits in
     * editors.
     *
     * @since 0.1
     */
    String DECIMAL3_PATTERN = "\\d{0,6}(\\.\\d{0,3})?";

    /**
     * Pattern to use for decimal numeric values with 4 decimal digits in
     * editors.
     *
     * @since 2.6
     */
    String DECIMAL4_PATTERN = "\\d{0,6}(\\.\\d{0,4})?";

    /**
     * Pattern to use for decimal numeric values with 2 digits + 3 decimal digits in
     * editors.
     *
     * @since 2.8
     */
    String DECIMAL2_DIGITS_PATTERN = "\\d{0,2}(\\.\\d*)?";
}
