package org.nuiton.jaxx.application.swing.table;

/*
 * #%L
 * JAXX :: Application Swing
 * $Id: AbstractSelectTableAction.java 2779 2014-01-31 10:50:51Z tchemit $
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.AbstractAction;
import javax.swing.JTable;

/**
 * Abstract action to select a cell in a table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.8
 */
public abstract class AbstractSelectTableAction<M extends AbstractApplicationTableModel> extends AbstractAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(AbstractSelectTableAction.class);

    private final M model;

    private final JTable table;

    public AbstractSelectTableAction(M model, JTable table) {
        this.model = model;
        this.table = table;
    }

    protected void doSelectCell(int rowIndex, int columnIndex) {

        if (log.isDebugEnabled()) {
            log.debug("Will select cell at " +
                      getCellCoordinate(rowIndex, columnIndex));
        }
        ApplicationUIUtil.doSelectCell(table, rowIndex, columnIndex);
    }

    protected int getSelectedRow() {
        int result = table.getSelectedRow();
        return result;
    }

    protected int getSelectedColumn() {
        int result = table.getSelectedColumn();
        return result;
    }

    protected int getRowCount() {
        return table.getRowCount();
    }

    protected int getColumnCount() {
        return table.getColumnCount();
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result;
        result = rowIndex > -1 && columnIndex > -1 &&
                 table.isCellEditable(rowIndex, columnIndex);
        return result;
    }

    protected boolean isCreateNewRow() {
        return model.isCreateNewRow();
    }

    protected String getCellCoordinate(int rowIndex, int columnIndex) {
        return " [" + rowIndex + ", " + columnIndex + "]";
    }

    protected void addNewRow() {
        model.addNewRow();
    }
}
