/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: JspFileProcessor.java 1807 2010-11-12 11:48:31Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/i18n/tags/i18n-2.0.1/maven-i18n-plugin/src/main/java/org/nuiton/i18n/plugin/parser/impl/JspFileProcessor.java $
 * %%
 * Copyright (C) 2007 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.i18n.plugin.parser.impl;

import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;
import org.nuiton.processor.filters.DefaultFilter;
import org.nuiton.processor.filters.Filter;

import java.io.File;
import java.io.IOException;

/**
 * To transform jsp files to valid xml files.
 * <p/>
 * Says :
 * <ul>
 * <li>Remove jsp directive</li>
 * <li>Remove jsp comment</li>
 * <li>Remove any tags in attributes (used for example in struts)</li>
 * <li>? Other thing</li>
 * </ul>
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0
 */
public class JspFileProcessor extends Processor {

    public JspFileProcessor() {
        setInputFilter(
                new Filter[]{
                        new JspDirectiveFilter(),
                        new JspCommentFilter(),
                        new JspAttributeWithTagFilter()
                }
        );
    }

    /**
     * @param filein   the source file to process
     * @param fileout  the output file to generate
     * @param encoding encoding used to read and write files
     * @throws IOException if any io problems while processing
     * @since 1.0.4
     */
    public void process(File filein,
                        File fileout,
                        String encoding) throws IOException {
        ProcessorUtil.doProcess(this, filein, fileout, encoding);
    }

    /**
     * To remove in attributes any sub tags inside it (used for example in
     * struts) from jsp files.
     *
     * @author tchemit <chemit@codelutin.com>
     * @since 2.0
     */
    public static class JspAttributeWithTagFilter extends DefaultFilter {

        private String header = "=" + "\"" + "<";

        private String footer = "\"" + "/" + ">" + "\"";

        @Override
        protected String performInFilter(String ch) {
            return "=\"\"";
        }

        @Override
        protected String performOutFilter(String ch) {
            return ch;
        }

        protected String getHeader() {
            return header;
        }

        protected String getFooter() {
            return footer;
        }
    }

    /**
     * To remove jsp comment from files.
     *
     * @author tchemit <chemit@codelutin.com>
     * @since 2.0
     */
    public static class JspCommentFilter extends DefaultFilter {

        private String header = "<" + "%" + "-" + "-";

        private String footer = "-" + "-" + "%" + ">";

        @Override
        protected String performInFilter(String ch) {
            return "";
        }

        @Override
        protected String performOutFilter(String ch) {
            return ch;
        }

        protected String getHeader() {
            return header;
        }

        protected String getFooter() {
            return footer;
        }
    }

    /**
     * To remove jsp directive from files.
     *
     * @author tchemit <chemit@codelutin.com>
     * @since 2.0
     */
    public static class JspDirectiveFilter extends DefaultFilter {

        private String header = "<" + "%";

        private String footer = "%" + ">";

        @Override
        protected String performInFilter(String ch) {
            return "";
        }

        @Override
        protected String performOutFilter(String ch) {
            return ch;
        }

        protected String getHeader() {
            return header;
        }

        protected String getFooter() {
            return footer;
        }
    }
}
