/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.generator;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.generator.GuixGenerator;
import org.nuiton.guix.generator.JavaField;
import org.nuiton.guix.generator.JavaFile;
import org.nuiton.guix.generator.JavaMethod;
import org.nuiton.guix.generator.SwingAbstractClassGenerator;
import org.nuiton.guix.generator.SwingImplementationGenerator;
import org.nuiton.guix.generator.SwingInterfaceGenerator;
import org.nuiton.guix.generator.SwingJavaFileGenerator;
import org.nuiton.guix.generator.SwingMainClassGenerator;
import org.nuiton.guix.tags.TagHandler;

public class SwingGenerator
extends GuixGenerator {
    protected Log log = LogFactory.getLog(SwingGenerator.class);
    Map<SwingJavaFileGenerator, File> generators = new HashMap<SwingJavaFileGenerator, File>();

    public JavaFile generate() {
        block17: {
            try {
                String gmoClassName = this.gmo.getClassDescriptor().getName();
                File outDir = new File(this.destDir, this.gmo.getClassDescriptor().getPackageName().replace('.', File.separatorChar));
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
                File out = new File(outDir, gmoClassName + ".java");
                File outAbstract = new File(outDir, gmoClassName + "Abstract.java");
                File outImpl = new File(outDir, gmoClassName + "Impl.java");
                if (this.lastModification > out.lastModified()) {
                    try {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("Generation of " + this.gmo.getClassDescriptor().getName()));
                        }
                        if (!out.exists()) {
                            try {
                                out.createNewFile();
                                outAbstract.createNewFile();
                                outImpl.createNewFile();
                            }
                            catch (IOException ex) {
                                this.log.error((Object)ex);
                            }
                        }
                        SwingInterfaceGenerator sing = new SwingInterfaceGenerator(this.gmo, this.classes);
                        SwingAbstractClassGenerator sacg = new SwingAbstractClassGenerator(this.gmo, this.classes);
                        sacg.setSwingGenerator(this);
                        SwingImplementationGenerator simg = new SwingImplementationGenerator(this.gmo, this.classes);
                        sing.generate();
                        this.generators.put(sing, out);
                        JavaFile jf = sacg.generate();
                        this.generators.put(sacg, outAbstract);
                        simg.generate();
                        this.generators.put(simg, outImpl);
                        if (this.mainClass) {
                            SwingMainClassGenerator smcg = new SwingMainClassGenerator(this.gmo);
                            File outMain = new File(outDir, this.launcherName + ".java");
                            smcg.generate(outMain);
                        }
                        this.serializer.startTag("", "bean");
                        this.serializer.attribute("", "id", gmoClassName.replace(out.getName().charAt(0), Character.toLowerCase(out.getName().charAt(0)))).attribute("", "class", gmoClassName + "Impl").attribute("", "singleton", "false").endTag("", "bean");
                        this.setBindingsToGenerate(sacg.getBindings2Generate());
                        return jf;
                    }
                    catch (IllegalArgumentException eee) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)eee);
                        }
                        break block17;
                    }
                    catch (IllegalStateException eee) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)eee);
                        }
                        break block17;
                    }
                    catch (IOException eee) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)eee);
                        }
                        break block17;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)(this.gmo.getClassDescriptor().getName() + " has already been generated and is up to date."));
                }
            }
            catch (Exception eee) {
                if (!this.log.isErrorEnabled()) break block17;
                this.log.error((Object)eee);
            }
        }
        return null;
    }

    public void saveFiles() {
        for (SwingJavaFileGenerator gen : this.generators.keySet()) {
            gen.saveFile(this.generators.get((Object)gen));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Class> generateBindings(StringBuffer dbCreation, StringBuffer dbDeletion, TagHandler prevTh, JavaFile jf, Class clazz, String[] binding, int i, List<String> alreadyChecked, String methodToInvoke, Map<GuixGenerator, JavaFile> generatedFiles) {
        String realAttributename;
        ArrayList<Class> result;
        String removeMethod;
        String addMethod;
        Class<PropertyChangeListener> listener;
        String model;
        TagHandler th;
        Class<?> nextClazz;
        JavaFile nextFile;
        String getter;
        block60: {
            String returnType;
            boolean bindingExists;
            block64: {
                JavaField f;
                block61: {
                    String realMethodName;
                    block63: {
                        block62: {
                            if (dbCreation == null) return null;
                            if (dbDeletion == null) return null;
                            if (binding == null) return null;
                            if (jf == null) {
                                if (clazz == null) return null;
                            }
                            if (methodToInvoke == null) return null;
                            if (generatedFiles == null) return null;
                            if (i < 0) {
                                return null;
                            }
                            bindingExists = false;
                            returnType = null;
                            getter = null;
                            nextFile = null;
                            nextClazz = null;
                            th = null;
                            model = null;
                            listener = null;
                            addMethod = null;
                            removeMethod = null;
                            result = new ArrayList<Class>();
                            realMethodName = null;
                            realAttributename = null;
                            if (Character.isUpperCase(binding[i].charAt(binding[i].lastIndexOf(46) + 1))) {
                                try {
                                    Class.forName(binding[i]);
                                    return result;
                                }
                                catch (ClassNotFoundException eee) {
                                    return null;
                                }
                            }
                            if (!binding[i].endsWith(")")) break block61;
                            realMethodName = binding[i].substring(0, binding[i].indexOf(40));
                            if (prevTh != null) {
                                if (binding[i].startsWith("get")) {
                                    realAttributename = prevTh.getAttrToGenerate(Character.toLowerCase(binding[i].charAt(3)) + binding[i].substring(4, binding[i].indexOf("(")));
                                    if (realAttributename != null) {
                                        realMethodName = "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1);
                                    }
                                } else if (binding[i].startsWith("is") && (realAttributename = prevTh.getAttrToGenerate(Character.toLowerCase(binding[i].charAt(2)) + binding[i].substring(3, binding[i].indexOf("(")))) != null) {
                                    realMethodName = "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1);
                                }
                            }
                            if (realAttributename == null) {
                                realAttributename = binding[i].startsWith("get") ? Character.toLowerCase(binding[i].charAt(3)) + binding[i].substring(4, binding[i].indexOf(40)) : (binding[i].startsWith("is") ? Character.toLowerCase(binding[i].charAt(2)) + binding[i].substring(3, binding[i].indexOf(40)) : binding[i].substring(0, binding[i].indexOf(40)));
                            }
                            if (jf == null) break block62;
                            boolean bl = bindingExists = jf.getMethod(realMethodName, null) != null;
                            if (bindingExists) {
                                returnType = jf.getMethod(realMethodName, null).getReturnType();
                                f = jf.getField(realAttributename);
                                if (f != null) {
                                    th = f.getTagHandler();
                                }
                            }
                            break block63;
                        }
                        try {
                            returnType = clazz.getMethod(realMethodName, null).getReturnType().getName();
                            bindingExists = true;
                        }
                        catch (NoSuchMethodException eee) {
                            bindingExists = false;
                        }
                    }
                    getter = realMethodName + binding[i].substring(binding[i].indexOf(40));
                    break block64;
                }
                if (prevTh != null) {
                    realAttributename = prevTh.getAttrToGenerate(binding[i]);
                }
                if (realAttributename == null) {
                    realAttributename = binding[i];
                }
                if (jf != null) {
                    boolean bl = bindingExists = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null || jf.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null;
                    if (bindingExists) {
                        returnType = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null ? jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType() : jf.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType();
                    }
                    getter = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null ? "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()" : "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";
                    f = jf.getField(realAttributename);
                    if (f != null) {
                        th = f.getTagHandler();
                    }
                } else {
                    try {
                        returnType = clazz.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType().getName();
                        getter = "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";
                        bindingExists = true;
                    }
                    catch (NoSuchMethodException eee) {
                        try {
                            returnType = clazz.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType().getName();
                            getter = "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";
                            bindingExists = true;
                        }
                        catch (NoSuchMethodException eee2) {
                            bindingExists = false;
                        }
                    }
                }
            }
            if (!bindingExists) {
                if (!this.log.isErrorEnabled()) return result;
                this.log.error((Object)("unable to bind " + binding[i]));
                return result;
            }
            binding[i] = getter;
            if (prevTh != null) {
                String getterWoBraces = getter.substring(0, getter.indexOf(40));
                if (prevTh.hasEventInfosAboutMethod(getterWoBraces)) {
                    model = prevTh.getEventInfosModelName(getterWoBraces);
                    listener = prevTh.getEventInfosListenerClass(getterWoBraces);
                    addMethod = prevTh.getEventInfosAddListenerMethodName(getterWoBraces);
                    removeMethod = prevTh.getEventInfosRemoveListenerMethodName(getterWoBraces);
                } else {
                    listener = PropertyChangeListener.class;
                    addMethod = "addPropertyChangeListener";
                    removeMethod = "removePropertyChangeListener";
                }
            }
            try {
                nextClazz = Class.forName(returnType);
            }
            catch (ClassNotFoundException eee) {
                for (JavaFile javaFile : generatedFiles.values()) {
                    if (!returnType.equals(javaFile.getPackageName() + "." + javaFile.getClassName())) continue;
                    nextFile = javaFile;
                    break;
                }
                if (nextFile != null) break block60;
                for (JavaFile javaFile : this.propertyChangeListenerDependencies) {
                    if (!returnType.equals(javaFile.getPackageName() + "." + javaFile.getClassName())) continue;
                    nextFile = javaFile;
                    break;
                }
            }
        }
        if (listener == null && clazz != null) {
            try {
                clazz.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                listener = PropertyChangeListener.class;
                addMethod = "addPropertyChangeListener";
                removeMethod = "removePropertyChangeListener";
            }
            catch (NoSuchMethodException eee) {}
        } else if (listener == null && jf != null) {
            for (JavaMethod method : jf.getAllMethods()) {
                if (!method.getName().equals("addPropertyChangeListener") || (method.getArguments().length != 1 || !method.getArguments()[0].getType().equals("java.beans.PropertyChangeListener")) && (method.getArguments().length != 2 || !method.getArguments()[1].getType().equals("java.beans.PropertyChangeListener"))) continue;
                listener = PropertyChangeListener.class;
                addMethod = "addPropertyChangeListener";
                removeMethod = "removePropertyChangeListener";
            }
        }
        boolean ifAdded = false;
        if (listener == null) return result;
        if (alreadyChecked == null || alreadyChecked.isEmpty()) {
            if (nextClazz != null && !nextClazz.isPrimitive()) {
                ifAdded = true;
                dbCreation.append("if(").append(getter).append(" != null").append(") {\n");
                dbDeletion.append("if(").append(getter).append(" != null").append(") {\n");
            }
        } else {
            int j;
            ifAdded = true;
            dbCreation.append("if(");
            dbDeletion.append("if(");
            for (j = 0; j < alreadyChecked.size(); ++j) {
                dbCreation.append(alreadyChecked.get(0));
                dbDeletion.append(alreadyChecked.get(0));
                for (int k = 1; k <= j; ++k) {
                    dbCreation.append(".").append(alreadyChecked.get(k));
                    dbDeletion.append(".").append(alreadyChecked.get(k));
                }
                dbCreation.append(" != null && ");
                dbDeletion.append(" != null && ");
            }
            if (binding.length > alreadyChecked.size() + 1 && nextClazz != null && !nextClazz.isPrimitive()) {
                for (j = 0; j < alreadyChecked.size(); ++j) {
                    dbCreation.append(alreadyChecked.get(j)).append(".");
                    dbDeletion.append(alreadyChecked.get(j)).append(".");
                }
                dbCreation.append(getter).append(" != null");
                dbDeletion.append(getter).append(" != null");
            } else {
                dbCreation.delete(dbCreation.length() - 4, dbCreation.length());
                dbDeletion.delete(dbDeletion.length() - 4, dbDeletion.length());
            }
            dbCreation.append(") {\n");
            dbDeletion.append(") {\n");
        }
        if (alreadyChecked != null) {
            for (int j = 0; j < alreadyChecked.size(); ++j) {
                dbCreation.append(alreadyChecked.get(j)).append(".");
                dbDeletion.append(alreadyChecked.get(j)).append(".");
            }
        }
        if (model != null && !model.equals("")) {
            if (alreadyChecked == null) {
                dbCreation.append(getter).append(".");
                dbDeletion.append(getter).append(".");
            }
            dbCreation.append("get").append(Character.toUpperCase(model.charAt(0))).append(model.substring(1)).append("()").append(".");
            dbDeletion.append("get").append(Character.toUpperCase(model.charAt(0))).append(model.substring(1)).append("()").append(".");
        }
        dbCreation.append(addMethod).append("(");
        dbDeletion.append(removeMethod).append("(");
        if (listener == PropertyChangeListener.class) {
            dbCreation.append("\"").append(realAttributename).append("\", ");
            dbDeletion.append("\"").append(realAttributename).append("\", ");
        }
        dbCreation.append("new ").append(listener.getName()).append("() {\n");
        dbDeletion.append("new ").append(listener.getName()).append("() {\n");
        for (Method m : listener.getMethods()) {
            StringBuffer sb = new StringBuffer();
            for (Annotation a : m.getDeclaredAnnotations()) {
                dbCreation.append(((Object)a).toString()).append("\n");
            }
            sb.append("public ").append(m.getReturnType().getCanonicalName()).append(" ").append(m.getName()).append("(");
            for (int n = 0; n < m.getParameterTypes().length; ++n) {
                sb.append(m.getParameterTypes()[n].getCanonicalName()).append(" arg").append(n).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length()).append(")").append(" {\n").append("onChangeFrom").append(methodToInvoke).append("();\n}\n");
            dbCreation.append(sb);
            dbDeletion.append(sb);
        }
        dbCreation.append("});\n");
        dbDeletion.append("});\n");
        if (ifAdded) {
            dbCreation.append("}\n");
            dbDeletion.append("}\n");
        }
        if (alreadyChecked == null) {
            alreadyChecked = new ArrayList<String>();
        }
        alreadyChecked.add(getter);
        try {
            if (i + 1 < binding.length) {
                result.addAll(this.generateBindings(dbCreation, dbDeletion, th, nextFile, nextClazz, binding, i + 1, alreadyChecked, methodToInvoke, generatedFiles));
            }
            if (listener == null) return result;
            if (result.contains(listener)) return result;
            result.add(listener);
            return result;
        }
        catch (NullPointerException eee) {
            return result;
        }
    }
}

