/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.generator;

import java.awt.Component;
import java.awt.Window;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.nuiton.guix.BindingUtils;
import org.nuiton.guix.SwingEventHandler;
import org.nuiton.guix.generator.JavaArgument;
import org.nuiton.guix.generator.JavaField;
import org.nuiton.guix.generator.JavaFile;
import org.nuiton.guix.generator.JavaFileGenerator;
import org.nuiton.guix.generator.JavaFileParser;
import org.nuiton.guix.generator.JavaMethod;
import org.nuiton.guix.generator.SwingGenerator;
import org.nuiton.guix.generator.SwingJavaFileGenerator;
import org.nuiton.guix.model.AttributeDescriptor;
import org.nuiton.guix.model.GuixModelObject;
import org.nuiton.guix.model.Rule;
import org.nuiton.guix.model.Selector;
import org.nuiton.guix.model.StyleSheet;
import org.nuiton.guix.tags.ScriptHandler;
import org.nuiton.guix.tags.TagHandler;
import org.nuiton.guix.tags.TagManager;
import org.nuiton.guix.tags.swing.CellHandler;
import org.nuiton.guix.tags.swing.MenuBarHandler;
import org.nuiton.guix.tags.swing.RowHandler;
import org.nuiton.guix.tags.swing.SplitPanelHandler;
import org.nuiton.guix.tags.swing.TableHandler;
import org.nuiton.guix.tags.swing.TreeHandler;

public class SwingAbstractClassGenerator
extends SwingJavaFileGenerator {
    private static final String CONSTRAINT_ATTRIBUTE = "constraints";
    private static final String SETTER_PATTERN = "%1$s oldValue = this.%2$s;\n%3$s\nfirePropertyChange(\"%2$s\", oldValue, %4$s);";
    private static final String SWING_DEFAULT_PACKAGE = "javax.swing";
    List<StyleSheet> styleSheets = new ArrayList<StyleSheet>();
    Map<ScriptHandler.ScriptPart, Object> script;
    Map<String, Map<String, String>> bindings2Generate = new HashMap<String, Map<String, String>>();
    SwingGenerator swingGenerator;

    public SwingAbstractClassGenerator(GuixModelObject gmo, Map<String, JavaFile> classes) {
        super(gmo, classes);
        this.jf = new JavaFile(1025, 1, gmo.getClassDescriptor().getPackageName(), gmo.getClassDescriptor().getName() + "Abstract", null, gmo.getJavadoc());
        this.script = ScriptHandler.decomposeScript((String)gmo.getClassDescriptor().getScript());
    }

    public void setSwingGenerator(SwingGenerator swingGenerator) {
        this.swingGenerator = swingGenerator;
    }

    public JavaFile generate() {
        super.addImports();
        for (String s : (List)this.script.get(ScriptHandler.ScriptPart.IMPORTS)) {
            this.jf.addImport(s);
        }
        for (JavaField field : (List)this.script.get(ScriptHandler.ScriptPart.FIELDS)) {
            this.jf.addField(field, false);
        }
        this.jf.addBodyCode((String)this.script.get(ScriptHandler.ScriptPart.BODYCODE));
        try {
            Map<JavaFileGenerator.Method, String> methodBodies = this.browseModelObjects(this.gmo);
            String scriptInitializers = ScriptHandler.postProcessInitializers((String)((String)this.script.get(ScriptHandler.ScriptPart.INITIALIZERS)), (JavaField[])this.jf.getAllFields());
            this.jf.addMethod(new JavaMethod(1, null, this.gmo.getClassDescriptor().getName() + "Abstract", null, null, "super(" + (this.gmo.getConstructor() != null ? this.gmo.getConstructor() : "") + ");" + (!this.jf.isSuperclassIsGuixObject() ? "\ninitialize();" : ""), "Constructor"));
            this.jf.addMethod(new JavaMethod(1, "void", "initialize", null, null, this.getMethodName(JavaFileGenerator.Method.BEFORE_CREATION) + "();\n" + this.getMethodName(JavaFileGenerator.Method.COMPONENTS_CREATION) + "();\n" + (scriptInitializers != null ? scriptInitializers + "\n" : "") + this.getMethodName(JavaFileGenerator.Method.BEFORE_SETTINGS) + "();\n" + this.getMethodName(JavaFileGenerator.Method.COMPONENTS_SETTINGS) + "();\n" + this.getMethodName(JavaFileGenerator.Method.BEFORE_TREE) + "();\n" + this.getMethodName(JavaFileGenerator.Method.COMPONENTS_TREE) + "();\n" + this.getMethodName(JavaFileGenerator.Method.BEFORE_BINDING) + "();\n" + this.getMethodName(JavaFileGenerator.Method.DATABINDING_INIT) + "();\n" + this.getMethodName(JavaFileGenerator.Method.IN_THE_END) + "();", "initialization"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.BEFORE_CREATION), null, null, this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.BEFORE_CREATION) + "();\n" : "", "Method called before the creation of the components"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.BEFORE_TREE), null, null, this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.BEFORE_TREE) + "();\n" : "", "Method called before the creation of the component tree"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.BEFORE_SETTINGS), null, null, this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.BEFORE_SETTINGS) + "();\n" : "", "Method called before the settings of the components"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.BEFORE_BINDING), null, null, this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.BEFORE_BINDING) + "();\n" : "", "Method called before the binding"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.IN_THE_END), null, null, this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.IN_THE_END) + "();\n" : "", "Method called in the end of the initialization"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.COMPONENTS_CREATION), null, null, (this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.COMPONENTS_CREATION) + "();\n" : "") + methodBodies.get(JavaFileGenerator.Method.COMPONENTS_CREATION), "Components creation"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.COMPONENTS_SETTINGS), null, null, (this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.COMPONENTS_SETTINGS) + "();\n" : "") + methodBodies.get(JavaFileGenerator.Method.COMPONENTS_SETTINGS), "Components settings"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.COMPONENTS_TREE), null, null, (this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.COMPONENTS_TREE) + "();\n" : "") + methodBodies.get(JavaFileGenerator.Method.COMPONENTS_TREE), "components layout"));
            this.jf.addMethod(new JavaMethod(1, "void", this.getMethodName(JavaFileGenerator.Method.DATABINDING_INIT), null, null, this.jf.isSuperclassIsGuixObject() ? "super." + this.getMethodName(JavaFileGenerator.Method.DATABINDING_INIT) + "();\n" : "", "initilization of databinding"));
            for (JavaMethod m : (List)this.script.get(ScriptHandler.ScriptPart.METHODS)) {
                ScriptHandler.postProcessMethodBody((JavaMethod)m, (JavaField[])this.jf.getAllFields());
                if ((m.getName().equals(this.getMethodName(JavaFileGenerator.Method.BEFORE_BINDING)) || m.getName().equals(this.getMethodName(JavaFileGenerator.Method.BEFORE_CREATION)) || m.getName().equals(this.getMethodName(JavaFileGenerator.Method.BEFORE_SETTINGS)) || m.getName().equals(this.getMethodName(JavaFileGenerator.Method.BEFORE_TREE)) || m.getName().equals(this.getMethodName(JavaFileGenerator.Method.IN_THE_END))) && m.getReturnType() != null && m.getReturnType().equals("void") && m.getArguments() == null) {
                    int i;
                    boolean methodFound = false;
                    for (i = 0; i < this.jf.getMethods().length && !methodFound; ++i) {
                        methodFound = this.jf.getMethods()[i].getName().equals(m.getName()) && this.jf.getMethods()[i].getReturnType() != null && this.jf.getMethods()[i].getReturnType().equals("void") && this.jf.getMethods()[i].getArguments() == null;
                    }
                    if (methodFound) {
                        this.jf.getMethods()[i - 1].appendBodyCode(m.getBodyCode(), "\n");
                        continue;
                    }
                    this.jf.addMethod(m);
                    continue;
                }
                this.jf.addMethod(m);
            }
            for (JavaMethod method : this.jf.getMethods()) {
                if (!method.getName().startsWith("set") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || method.getArguments() == null) continue;
                method.setBodyCode(String.format(SETTER_PATTERN, method.getArguments()[0].getType(), Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4), method.getBodyCode(), method.getArguments()[0].getName()));
            }
        }
        catch (ClassNotFoundException eee) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)eee);
            }
        }
        catch (ClassCastException eee) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)eee);
            }
        }
        catch (NullPointerException eee) {
            eee.printStackTrace();
        }
        return this.jf;
    }

    /*
     * WARNING - void declaration
     */
    private Map<JavaFileGenerator.Method, String> browseModelObjects(GuixModelObject gmo) throws ClassNotFoundException, ClassCastException {
        StringBuffer componentsTree;
        StringBuffer componentsSettings;
        StringBuffer componentsCreation;
        block138: {
            StringBuffer settingsMethod;
            String capitalizedId;
            boolean createField;
            String constraint;
            Class clazz;
            SwingEventHandler seh;
            block139: {
                block140: {
                    block137: {
                        componentsCreation = new StringBuffer("");
                        componentsSettings = new StringBuffer("");
                        componentsTree = new StringBuffer("");
                        seh = new SwingEventHandler();
                        clazz = null;
                        constraint = null;
                        createField = true;
                        String string = capitalizedId = gmo.getId().length() > 0 ? Character.toUpperCase(gmo.getId().charAt(0)) + gmo.getId().substring(1) : gmo.getId();
                        if ((gmo.getClassDescriptor().getSuperClass() == null || gmo.getClassDescriptor().getSuperClass().getPackageName() != null || !gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("Table")) && (gmo.getClassDescriptor().getPackageName() != null || !gmo.getClassDescriptor().getName().equalsIgnoreCase("Table"))) break block137;
                        ArrayList<List<Boolean>> layout = new ArrayList<List<Boolean>>();
                        StringBuffer settingsMethod2 = new StringBuffer();
                        TableHandler tableHandler = new TableHandler(gmo);
                        clazz = tableHandler.getClassToGenerate();
                        if (gmo.getParent() == null || this.jf.getInheritedField(gmo.getId()) != null && this.jf.getInheritedField(gmo.getId()).getType().equals(clazz.getName())) {
                            createField = false;
                        }
                        if (createField && this.jf.getInheritedField(gmo.getId()) != null) {
                            try {
                                Class<?> inheritedClazz = Class.forName(this.jf.getInheritedField(gmo.getId()).getType());
                                if (!inheritedClazz.isAssignableFrom(clazz)) {
                                    throw new ClassCastException();
                                }
                            }
                            catch (ClassNotFoundException eee) {
                                throw new ClassCastException();
                            }
                        }
                        if (createField) {
                            this.jf.addField(new JavaField(4, clazz.getName(), gmo.getId(), gmo.getJavadoc(), (TagHandler)tableHandler), gmo.isJavaBean());
                            componentsCreation.append(gmo.getId()).append(" = new ").append(clazz.getName()).append("(new java.awt.GridBagLayout());\n");
                            if (this.jf.getInheritedField(gmo.getId()) != null) {
                                componentsCreation.append("super.set").append(capitalizedId).append("(").append(gmo.getId()).append(");\n");
                            }
                        } else {
                            settingsMethod2.append(gmo.getId()).append(".setLayout(new java.awt.GridBagLayout());\n");
                        }
                        if (this.jf.isSuperclassIsGuixObject() && this.jf.getInheritedField(gmo.getId()) != null) {
                            settingsMethod2.insert(0, "super." + gmo.getId() + "Settings();\n");
                        }
                        constraint = this.processAttributes(clazz, gmo, settingsMethod2, seh, (TagHandler)tableHandler);
                        if (gmo.getParent().getParent() == null && this.jf.getInheritedField(gmo.getId()) != null) {
                            componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".set").append(capitalizedId).append("(").append(gmo.getId()).append(");\n");
                        } else if (!this.ignoreTag(gmo)) {
                            if (gmo.getParent().getClassDescriptor().getPackageName() == null && gmo.getParent().getClassDescriptor().getName().equalsIgnoreCase("ScrollPanel") || gmo.getParent().getClassDescriptor().toString().equals("javax.swing.JScrollPane")) {
                                componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".setViewportView(").append(gmo.getId()).append(");\n");
                            } else {
                                componentsTree.append(gmo.getParent().getParent() == null ? "this" : gmo.getParent().getId()).append(".add(").append(gmo.getId());
                                if (constraint != null) {
                                    componentsTree.append(",").append(constraint);
                                }
                                componentsTree.append(");\n");
                            }
                        }
                        for (int r = 0; r < gmo.getChildren().size(); ++r) {
                            GuixModelObject row = (GuixModelObject)gmo.getChildren().get(r);
                            if (!row.getClassDescriptor().getName().equalsIgnoreCase("Row")) {
                                if (!this.log.isErrorEnabled()) continue;
                                this.log.error((Object)"Table children must be Rows !");
                                continue;
                            }
                            RowHandler rowHandler = new RowHandler(row, tableHandler);
                            int n = 0;
                            for (int c = 0; c < row.getChildren().size(); ++c) {
                                GuixModelObject cell = (GuixModelObject)row.getChildren().get(c);
                                if (!cell.getClassDescriptor().getName().equalsIgnoreCase("Cell")) {
                                    if (!this.log.isErrorEnabled()) continue;
                                    this.log.error((Object)"Row children must be Cells !");
                                    continue;
                                }
                                if (cell.getChildren().size() != 1) {
                                    if (!this.log.isErrorEnabled()) continue;
                                    this.log.error((Object)"Cells must contain only one tag !");
                                    continue;
                                }
                                CellHandler cellHandler = new CellHandler(cell, rowHandler);
                                componentsTree.append(TableHandler.createCell(gmo.getId(), cellHandler, layout, n, r));
                                Map<JavaFileGenerator.Method, String> methodBodies = this.browseModelObjects((GuixModelObject)cell.getChildren().get(0));
                                componentsCreation.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_CREATION));
                                componentsSettings.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_SETTINGS));
                                componentsTree.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_TREE));
                            }
                        }
                        componentsSettings.append(gmo.getId()).append("Settings();\n");
                        break block138;
                    }
                    if ((gmo.getClassDescriptor().getSuperClass() == null || gmo.getClassDescriptor().getSuperClass().getPackageName() != null || !gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("Tab")) && (gmo.getClassDescriptor().getPackageName() != null || !gmo.getClassDescriptor().getName().equalsIgnoreCase("Tab"))) break block139;
                    if ((gmo.getParent().getClassDescriptor().getSuperClass() == null || (gmo.getParent().getClassDescriptor().getSuperClass().getPackageName() != null || !gmo.getParent().getClassDescriptor().getSuperClass().getName().equals("TabPanel") && !gmo.getParent().getClassDescriptor().getSuperClass().getName().equals("JTabbedPane")) && !gmo.getParent().getClassDescriptor().getSuperClass().toString().equals("javax.swing.JTabbedPane")) && gmo.getParent() != null && (gmo.getParent().getClassDescriptor().getPackageName() != null || !gmo.getParent().getClassDescriptor().getName().equals("TabPanel") && !gmo.getParent().getClassDescriptor().getName().equals("JTabbedPane")) && !gmo.getParent().getClassDescriptor().toString().equals("javax.swing.JTabbedPane") || gmo.getChildren().size() != 1) break block140;
                    String title = null;
                    for (AttributeDescriptor attribute : gmo.getAttributeDescriptors()) {
                        if (!attribute.getName().equals("title")) continue;
                        title = attribute.getValue();
                        break;
                    }
                    componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".addTab(").append(title != null ? title : "\"" + gmo.getId() + "\"").append(",").append(((GuixModelObject)gmo.getChildren().get(0)).getId()).append(");\n");
                    Map<JavaFileGenerator.Method, String> methodBodies = this.browseModelObjects((GuixModelObject)gmo.getChildren().get(0));
                    componentsCreation.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_CREATION));
                    componentsSettings.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_SETTINGS));
                    componentsTree.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_TREE));
                    break block138;
                }
                if (!this.log.isErrorEnabled()) break block138;
                this.log.error((Object)"Tab tags can only be children of TabPanel or JTabbedPane tags, and can have only one child.");
                break block138;
            }
            if (gmo.getClassDescriptor().getSuperClass() != null && (gmo.getClassDescriptor().getSuperClass().getPackageName() == null && (gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("MenuBar") || gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("JMenuBar")) || gmo.getClassDescriptor().getSuperClass().toString().equals("javax.swing.JMenuBar")) || gmo.getClassDescriptor().getPackageName() == null && (gmo.getClassDescriptor().getName().equalsIgnoreCase("MenuBar") || gmo.getClassDescriptor().getName().equalsIgnoreCase("JMenuBar")) || gmo.getClassDescriptor().toString().equals("javax.swing.JMenuBar")) {
                settingsMethod = new StringBuffer();
                MenuBarHandler menuBarHandler = new MenuBarHandler();
                clazz = menuBarHandler.getClassToGenerate();
                if (gmo.getParent() == null || this.jf.getInheritedField(gmo.getId()) != null && this.jf.getInheritedField(gmo.getId()).getType().equals(clazz.getName())) {
                    createField = false;
                }
                if (createField && this.jf.getInheritedField(gmo.getId()) != null) {
                    try {
                        Class<?> inheritedClazz = Class.forName(this.jf.getInheritedField(gmo.getId()).getType());
                        if (!inheritedClazz.isAssignableFrom(clazz)) {
                            throw new ClassCastException();
                        }
                    }
                    catch (ClassNotFoundException eee) {
                        throw new ClassCastException();
                    }
                }
                if (createField) {
                    this.jf.addField(new JavaField(4, clazz.getName(), gmo.getId(), gmo.getJavadoc(), (TagHandler)menuBarHandler), gmo.isJavaBean());
                    componentsCreation.append(gmo.getId()).append(" = new ").append(clazz.getName()).append("();\n");
                    if (this.jf.getInheritedField(gmo.getId()) != null) {
                        componentsCreation.append("super.set").append(capitalizedId).append("(").append(gmo.getId()).append(");\n");
                    }
                }
                if (this.jf.isSuperclassIsGuixObject() && this.jf.getInheritedField(gmo.getId()) != null) {
                    settingsMethod.insert(0, "super." + gmo.getId() + "Settings();\n");
                }
                constraint = this.processAttributes(clazz, gmo, settingsMethod, seh, (TagHandler)menuBarHandler);
                componentsTree.append(gmo.getParent().getParent() == null ? "this" : gmo.getParent().getId()).append(".setJMenuBar(").append(gmo.getId()).append(");\n");
                for (GuixModelObject child : gmo.getChildren()) {
                    Map<JavaFileGenerator.Method, String> methodBodies = this.browseModelObjects(child);
                    componentsCreation.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_CREATION));
                    componentsSettings.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_SETTINGS));
                    componentsTree.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_TREE));
                }
                componentsSettings.append(gmo.getId()).append("Settings();\n");
            } else if (gmo.getClassDescriptor().getSuperClass() != null && (gmo.getClassDescriptor().getSuperClass().getPackageName() == null && (gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("VerticalSplitPanel") || gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("HorizontalSplitPanel") || gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("JSplitPane")) || gmo.getClassDescriptor().getSuperClass().toString().equals("javax.swing.JSplitPane")) || gmo.getClassDescriptor().getPackageName() == null && (gmo.getClassDescriptor().getName().equalsIgnoreCase("VerticalSplitPanel") || gmo.getClassDescriptor().getName().equalsIgnoreCase("HorizontalSplitPanel") || gmo.getClassDescriptor().getName().equalsIgnoreCase("JSplitPane")) || gmo.getClassDescriptor().toString().equals("javax.swing.JSplitPane")) {
                settingsMethod = new StringBuffer();
                SplitPanelHandler splitPanelHandler = new SplitPanelHandler();
                clazz = splitPanelHandler.getClassToGenerate();
                if (gmo.getParent() == null || this.jf.getInheritedField(gmo.getId()) != null && this.jf.getInheritedField(gmo.getId()).getType().equals(clazz.getName())) {
                    createField = false;
                }
                if (createField && this.jf.getInheritedField(gmo.getId()) != null) {
                    try {
                        Class<?> inheritedClazz = Class.forName(this.jf.getInheritedField(gmo.getId()).getType());
                        if (!inheritedClazz.isAssignableFrom(clazz)) {
                            throw new ClassCastException();
                        }
                    }
                    catch (ClassNotFoundException eee) {
                        throw new ClassCastException();
                    }
                }
                if (createField) {
                    this.jf.addField(new JavaField(4, clazz.getName(), gmo.getId(), gmo.getJavadoc(), (TagHandler)splitPanelHandler), gmo.isJavaBean());
                    componentsCreation.append(gmo.getId()).append(" = new ").append(clazz.getName()).append("(").append(clazz.getName()).append(gmo.getClassDescriptor().getName().equalsIgnoreCase("VerticalSplitPanel") ? ".VERTICAL_SPLIT" : ".HORIZONTAL_SPLIT").append(");\n");
                }
                if (this.jf.isSuperclassIsGuixObject() && this.jf.getInheritedField(gmo.getId()) != null) {
                    settingsMethod.insert(0, "super." + gmo.getId() + "Settings();\n");
                }
                constraint = this.processAttributes(clazz, gmo, settingsMethod, seh, (TagHandler)splitPanelHandler);
                if (gmo.getParent().getParent() == null && this.jf.getInheritedField(gmo.getId()) != null) {
                    componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".set").append(capitalizedId).append("(").append(gmo.getId()).append(");\n");
                } else if (!this.ignoreTag(gmo)) {
                    if (gmo.getParent().getClassDescriptor().getPackageName() == null && gmo.getParent().getClassDescriptor().getName().equalsIgnoreCase("ScrollPanel") || gmo.getParent().getClassDescriptor().toString().equals("javax.swing.JScrollPane")) {
                        componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".setViewportView(").append(gmo.getId()).append(");\n");
                    } else {
                        componentsTree.append(gmo.getParent().getParent() == null ? "this" : gmo.getParent().getId()).append(".add(").append(gmo.getId());
                        if (constraint != null) {
                            componentsTree.append(",").append(constraint);
                        }
                        componentsTree.append(");\n");
                    }
                }
                for (GuixModelObject child : gmo.getChildren()) {
                    Map<JavaFileGenerator.Method, String> methodBodies = this.browseModelObjects(child);
                    componentsCreation.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_CREATION));
                    componentsSettings.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_SETTINGS));
                    componentsTree.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_TREE));
                }
                componentsSettings.append(gmo.getId()).append("Settings();\n");
            } else if (gmo.getClassDescriptor().getSuperClass() != null && (gmo.getClassDescriptor().getSuperClass().getPackageName() == null && (gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("Tree") || gmo.getClassDescriptor().getSuperClass().getName().equalsIgnoreCase("JTree")) || gmo.getClassDescriptor().getSuperClass().toString().equals("javax.swing.JTree")) || gmo.getClassDescriptor().getPackageName() == null && (gmo.getClassDescriptor().getName().equalsIgnoreCase("Tree") || gmo.getClassDescriptor().getName().equalsIgnoreCase("JTree")) || gmo.getClassDescriptor().toString().equals("javax.swing.JTree")) {
                settingsMethod = new StringBuffer();
                TreeHandler treeHandler = new TreeHandler();
                clazz = treeHandler.getClassToGenerate();
                if (gmo.getParent() == null || this.jf.getInheritedField(gmo.getId()) != null && this.jf.getInheritedField(gmo.getId()).getType().equals(clazz.getName())) {
                    createField = false;
                }
                if (createField && this.jf.getInheritedField(gmo.getId()) != null) {
                    try {
                        Class<?> inheritedClazz = Class.forName(this.jf.getInheritedField(gmo.getId()).getType());
                        if (!inheritedClazz.isAssignableFrom(clazz)) {
                            throw new ClassCastException();
                        }
                    }
                    catch (ClassNotFoundException eee) {
                        throw new ClassCastException();
                    }
                }
                for (GuixModelObject child : gmo.getChildren()) {
                    Map<JavaFileGenerator.Method, String> methodBodies = this.browseModelObjects(child);
                    componentsCreation.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_CREATION));
                    componentsSettings.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_SETTINGS));
                    componentsTree.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_TREE));
                }
                if (createField) {
                    this.jf.addField(new JavaField(2, clazz.getName(), gmo.getId(), gmo.getJavadoc(), (TagHandler)treeHandler), gmo.isJavaBean());
                    if (gmo.getChildren().size() == 1) {
                        componentsCreation.append(gmo.getId()).append(" = new ").append(clazz.getName()).append("(").append(((GuixModelObject)gmo.getChildren().get(0)).getId()).append(");\n");
                    } else {
                        componentsCreation.append("java.util.Vector<javax.swing.tree.TreeNode> ").append(gmo.getId()).append("Nodes = new java.util.Vector<javax.swing.tree.TreeNode>();\n");
                        for (GuixModelObject child : gmo.getChildren()) {
                            componentsCreation.append(gmo.getId()).append("Nodes.add(").append(child.getId()).append(");\n");
                        }
                        componentsCreation.append(gmo.getId()).append(" = new ").append(clazz.getName()).append("(").append(gmo.getId()).append("Nodes);\n");
                    }
                }
                if (this.jf.isSuperclassIsGuixObject() && this.jf.getInheritedField(gmo.getId()) != null) {
                    settingsMethod.insert(0, "super." + gmo.getId() + "Settings();\n");
                }
                constraint = this.processAttributes(clazz, gmo, settingsMethod, seh, (TagHandler)treeHandler);
                if (gmo.getParent().getParent() == null && this.jf.getInheritedField(gmo.getId()) != null) {
                    componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".set").append(capitalizedId).append("(").append(gmo.getId()).append(");\n");
                } else if (!this.ignoreTag(gmo)) {
                    if (gmo.getParent().getClassDescriptor().getPackageName() == null && gmo.getParent().getClassDescriptor().getName().equalsIgnoreCase("ScrollPanel") || gmo.getParent().getClassDescriptor().toString().equals("javax.swing.JScrollPane")) {
                        componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".setViewportView(").append(gmo.getId()).append(");\n");
                    } else {
                        componentsTree.append(gmo.getParent().getParent() == null ? "this" : gmo.getParent().getId()).append(".add(").append(gmo.getId());
                        if (constraint != null) {
                            componentsTree.append(",").append(constraint);
                        }
                        componentsTree.append(");\n");
                    }
                }
                componentsSettings.append(gmo.getId()).append("Settings();\n");
            } else {
                StringBuffer settingsMethod3;
                Class<Object> superClazz;
                JavaFile jFile;
                TagHandler superTh;
                TagHandler th;
                block136: {
                    th = null;
                    superTh = null;
                    jFile = null;
                    superClazz = null;
                    settingsMethod3 = new StringBuffer();
                    ArrayList<String> generatedSuperClasses = new ArrayList<String>();
                    if (TagManager.getGuixClassHandler((String)gmo.getClassDescriptor().getName()) != null) {
                        th = TagManager.getGuixClassHandler((String)gmo.getClassDescriptor().getName());
                        if (th != null) {
                            clazz = th.getClassToGenerate();
                        }
                    } else {
                        if (gmo.getClassDescriptor().getPackageName() == null) {
                            gmo.getClassDescriptor().setPackageName(SWING_DEFAULT_PACKAGE);
                        }
                        if (TagManager.getGuixClassHandler((String)gmo.getClassDescriptor().toString()) != null) {
                            th = TagManager.getGuixClassHandler((String)gmo.getClassDescriptor().toString());
                            if (th != null) {
                                clazz = th.getClassToGenerate();
                            }
                        } else if (gmo.getParent() == null && gmo.getClassDescriptor().getSuperClass() != null && TagManager.getGuixClassHandler((String)gmo.getClassDescriptor().getSuperClass().getName()) != null) {
                            th = TagManager.getGuixClassHandler((String)gmo.getClassDescriptor().getSuperClass().getName());
                            if (th != null) {
                                clazz = th.getClassToGenerate();
                            }
                        } else if (gmo.getClassDescriptor() != null && this.classes.get(gmo.getClassDescriptor().toString()) != null) {
                            jFile = (JavaFile)this.classes.get(gmo.getClassDescriptor().toString());
                        } else if (gmo.getParent() == null && gmo.getClassDescriptor().getSuperClass() != null && this.classes.get(gmo.getClassDescriptor().getSuperClass().toString()) != null) {
                            jFile = (JavaFile)this.classes.get(gmo.getClassDescriptor().getSuperClass().toString());
                        } else {
                            try {
                                clazz = Class.forName(gmo.getClassDescriptor().toString());
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                File f = new File(this.swingGenerator.getSrcDir(), gmo.getClassDescriptor().toString().replace('.', File.separatorChar) + ".java");
                                try {
                                    InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
                                    jFile = JavaFileParser.parseJavaFile((String)gmo.getClassDescriptor().toString(), (Reader)isr);
                                    this.swingGenerator.getPropertyChangeListenerDependencies().add(jFile);
                                }
                                catch (FileNotFoundException eeee) {
                                    this.log.error((Object)eeee);
                                    throw new ClassNotFoundException();
                                }
                            }
                        }
                    }
                    if (clazz != null) {
                        superClazz = clazz.getSuperclass();
                    } else {
                        void var16_43;
                        JavaFile javaFile = jFile;
                        while (superClazz == null && var16_43 != null) {
                            try {
                                superClazz = Class.forName(var16_43.getSuperClass());
                                superTh = TagManager.getGuixClassHandler((String)superClazz.getName());
                            }
                            catch (ClassNotFoundException eee) {
                                generatedSuperClasses.add(var16_43.getSuperClass());
                                JavaFile javaFile2 = (JavaFile)this.classes.get(var16_43.getSuperClass().endsWith("Abstract") ? var16_43.getSuperClass().substring(0, var16_43.getSuperClass().length() - 8) : var16_43.getSuperClass());
                            }
                        }
                    }
                    if (gmo.getParent() == null) {
                        createField = false;
                    } else if (this.jf.getInheritedField(gmo.getId()) != null) {
                        if (clazz != null && this.jf.getInheritedField(gmo.getId()).getType().equals(clazz.getName()) || jFile != null && this.jf.getInheritedField(gmo.getId()).getType().equals(jFile.getPackageName() + "." + jFile.getClassName())) {
                            createField = false;
                        } else {
                            Object var16_46 = null;
                            try {
                                Class<Object> clazz2 = Class.forName(this.jf.getInheritedField(gmo.getId()).getType());
                                if (clazz != null) {
                                    if (!clazz2.isAssignableFrom(clazz)) {
                                        throw new ClassCastException();
                                    }
                                    break block136;
                                }
                                if (jFile != null && superClazz != null) {
                                    if (!clazz2.isAssignableFrom(superClazz)) {
                                        throw new ClassCastException();
                                    }
                                    break block136;
                                }
                                throw new ClassCastException();
                            }
                            catch (ClassNotFoundException eee) {
                                if (generatedSuperClasses.contains(this.jf.getInheritedField(gmo.getId()).getType())) break block136;
                                throw new ClassCastException();
                            }
                        }
                    }
                }
                if (createField) {
                    if (th != null && th.getClassToGenerate() != null) {
                        this.jf.addField(new JavaField(4, clazz.getName(), gmo.getId(), gmo.getJavadoc(), th), gmo.isJavaBean());
                    } else {
                        this.jf.addField(new JavaField(4, this.classes != null && this.classes.containsKey(gmo.getClassDescriptor().toString()) ? gmo.getClassDescriptor().toString() + "Abstract" : gmo.getClassDescriptor().toString(), gmo.getId(), gmo.getJavadoc(), superTh), gmo.isJavaBean());
                    }
                }
                if (gmo.getParent() != null) {
                    if (this.jf.isSuperclassIsGuixObject() && this.jf.getInheritedField(gmo.getId()) != null) {
                        settingsMethod3.insert(0, "super." + gmo.getId() + "Settings();\n");
                    }
                    if (createField || gmo.getConstructor() != null) {
                        componentsCreation.append(gmo.getId()).append(" = new ");
                        if (this.classes != null && this.classes.containsKey(gmo.getClassDescriptor().toString())) {
                            componentsCreation.append(gmo.getClassDescriptor().toString() + "Impl");
                        } else if (clazz != null) {
                            componentsCreation.append(clazz.getName());
                        } else {
                            componentsCreation.append(gmo.getClassDescriptor().toString());
                        }
                        componentsCreation.append("(").append(gmo.getConstructor() != null ? gmo.getConstructor() : "").append(");\n");
                        if (this.jf.getInheritedField(gmo.getId()) != null) {
                            componentsCreation.append("super.set").append(capitalizedId).append("(").append(gmo.getId()).append(");\n");
                        }
                    }
                    componentsSettings.append(gmo.getId()).append("Settings();\n");
                    if (gmo.getStyleSheets() != null) {
                        this.styleSheets.addAll(gmo.getStyleSheets());
                    }
                    constraint = clazz != null ? this.processAttributes(clazz, gmo, settingsMethod3, seh, th) : this.processAttributes(jFile, superClazz, gmo, settingsMethod3, seh, superTh);
                    if (jFile != null && (jFile.getField(gmo.getId()) != null || jFile.getInheritedField(gmo.getId()) != null) || gmo.getParent().getParent() == null && this.jf.getInheritedField(gmo.getId()) != null) {
                        componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".set").append(capitalizedId).append("(").append(gmo.getId()).append(");\n");
                    } else if (!this.ignoreTag(gmo)) {
                        if (gmo.getParent().getClassDescriptor().getPackageName() == null && gmo.getParent().getClassDescriptor().getName().equalsIgnoreCase("ScrollPanel") || gmo.getParent().getClassDescriptor().toString().equals("javax.swing.JScrollPane")) {
                            componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".setViewportView(").append(gmo.getId()).append(");\n");
                        } else if (superClazz != null && Component.class.isAssignableFrom(superClazz) && !Window.class.isAssignableFrom(superClazz) || gmo.getParent().getClassDescriptor().getPackageName() == null && gmo.getParent().getClassDescriptor().getName().equalsIgnoreCase("TreeNode")) {
                            componentsTree.append(gmo.getParent().getParent() != null ? gmo.getParent().getId() : "this").append(".add(").append(gmo.getId());
                            if (constraint != null) {
                                componentsTree.append(",").append(constraint);
                            }
                            componentsTree.append(");\n");
                        }
                    }
                } else {
                    if (th != null) {
                        this.jf.setSuperClass(th.getClassToGenerate().getName());
                    } else {
                        this.jf.setSuperClass(this.classes.containsKey(gmo.getClassDescriptor().getSuperClass().toString()) ? gmo.getClassDescriptor().getSuperClass().toString() + "Abstract" : gmo.getClassDescriptor().getSuperClass().toString());
                    }
                    this.jf.addInterface(gmo.getClassDescriptor().getName());
                    if (gmo.getStyleSheets() != null) {
                        this.styleSheets.addAll(gmo.getStyleSheets());
                    }
                    if (clazz != null) {
                        this.jf.setSuperclassIsGuixObject(false);
                        if (JComponent.class.isAssignableFrom(clazz)) {
                            this.jf.addMethod(new JavaMethod(1, "void", "firePropertyChange", new JavaArgument[]{new JavaArgument("String", "propertyName"), new JavaArgument("Object", "oldValue"), new JavaArgument("Object", "newValue")}, null, "super.firePropertyChange(propertyName, oldValue, newValue);", null));
                        }
                        for (Method method : clazz.getMethods()) {
                            if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers())) continue;
                            JavaArgument[] args = new JavaArgument[method.getParameterTypes().length];
                            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                                args[i] = new JavaArgument(method.getParameterTypes()[i].getName(), "arg" + i);
                            }
                            this.jf.addInheritedMethod(new JavaMethod(method.getModifiers(), method.getReturnType().getName(), method.getName(), args, null, "", null));
                        }
                        this.processAttributes(clazz, gmo, settingsMethod3, seh, th);
                    } else if (jFile != null) {
                        this.jf.setSuperclassIsGuixObject(true);
                        for (JavaMethod javaMethod : jFile.getInheritedMethods()) {
                            if (!Modifier.isPublic(javaMethod.getModifiers()) && !Modifier.isProtected(javaMethod.getModifiers())) continue;
                            this.jf.addInheritedMethod(javaMethod);
                        }
                        for (JavaMethod javaMethod : jFile.getMethods()) {
                            if (!Modifier.isPublic(javaMethod.getModifiers()) && !Modifier.isProtected(javaMethod.getModifiers())) continue;
                            this.jf.addInheritedMethod(javaMethod);
                        }
                        for (JavaField javaField : jFile.getInheritedFields()) {
                            if (!Modifier.isPublic(javaField.getModifiers()) && !Modifier.isProtected(javaField.getModifiers())) continue;
                            this.jf.addInheritedField(javaField);
                        }
                        for (JavaField javaField : jFile.getFields()) {
                            if (!Modifier.isPublic(javaField.getModifiers()) && !Modifier.isProtected(javaField.getModifiers())) continue;
                            this.jf.addInheritedField(javaField);
                        }
                        this.processAttributes(jFile, superClazz, gmo, settingsMethod3, seh, superTh != null ? superTh : th);
                    } else {
                        this.log.error((Object)"Allo Houston, on a un probleme !");
                    }
                    componentsSettings.append(gmo.getId()).append("Settings();\n");
                }
                for (GuixModelObject child : gmo.getChildren()) {
                    Map<JavaFileGenerator.Method, String> methodBodies = this.browseModelObjects(child);
                    componentsCreation.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_CREATION));
                    componentsSettings.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_SETTINGS));
                    componentsTree.append(methodBodies.get(JavaFileGenerator.Method.COMPONENTS_TREE));
                }
            }
        }
        HashMap<JavaFileGenerator.Method, String> result = new HashMap<JavaFileGenerator.Method, String>();
        result.put(JavaFileGenerator.Method.COMPONENTS_CREATION, componentsCreation.toString());
        result.put(JavaFileGenerator.Method.COMPONENTS_SETTINGS, componentsSettings.toString());
        result.put(JavaFileGenerator.Method.COMPONENTS_TREE, componentsTree.toString());
        return result;
    }

    private boolean ignoreTag(GuixModelObject gmo) {
        return gmo.getParent() != null && gmo.getParent().getClassDescriptor().getPackageName() == null && (gmo.getParent().getClassDescriptor().getName().equalsIgnoreCase("Cell") || gmo.getParent().getClassDescriptor().getName().equalsIgnoreCase("Tab"));
    }

    private String processAttributes(Class clazz, GuixModelObject gmo, StringBuffer settingsMethod, SwingEventHandler seh, TagHandler th) {
        String constraint = null;
        this.processCSSAttributes(gmo, seh, clazz);
        for (AttributeDescriptor attr : gmo.getAttributeDescriptors()) {
            if (th != null && th.getAttrToGenerate(attr.getName()) != null) {
                attr.setName(th.getAttrToGenerate(attr.getName()));
            }
            boolean addQuote = false;
            boolean addSimpleQuote = false;
            String capitalizedAttribute = attr.getName().length() > 0 ? Character.toUpperCase(attr.getName().charAt(0)) + attr.getName().substring(1) : attr.getName();
            boolean realAttribute = true;
            try {
                int m;
                if (attr.getName().startsWith("on") && Character.isUpperCase(attr.getName().charAt(2))) {
                    String lowerCaseAttribute = attr.getName().length() > 2 ? Character.toLowerCase(attr.getName().charAt(2)) + attr.getName().substring(3) : attr.getName();
                    realAttribute = !seh.addEvent(clazz, lowerCaseAttribute, attr.getValue());
                } else if (attr.getName().equals(CONSTRAINT_ATTRIBUTE)) {
                    constraint = attr.getValue();
                    realAttribute = false;
                }
                if (!realAttribute) continue;
                String binding = BindingUtils.processDataBindings((String)attr.getValue());
                Method[] methods = clazz.getMethods();
                for (m = 0; m < methods.length && !methods[m].getName().equals("set" + capitalizedAttribute); ++m) {
                }
                if (m < methods.length) {
                    if (binding != null) {
                        if (!this.bindings2Generate.containsKey(gmo.getId())) {
                            this.bindings2Generate.put(gmo.getId(), new HashMap());
                        }
                        this.bindings2Generate.get(gmo.getId()).put(attr.getName(), binding);
                        continue;
                    }
                    addQuote = methods[m].getParameterTypes()[0].equals(String.class);
                    boolean bl = addSimpleQuote = methods[m].getParameterTypes()[0].equals(Character.class) || methods[m].getParameterTypes()[0].equals(Character.TYPE);
                    if (settingsMethod == null) continue;
                    settingsMethod.append(gmo.getParent() != null ? gmo.getId() : "this").append(".set").append(capitalizedAttribute).append("(");
                    if (addQuote) {
                        settingsMethod.append("\"").append(attr.getValue()).append("\"").append(");\n");
                        continue;
                    }
                    if (addSimpleQuote) {
                        settingsMethod.append("'").append(attr.getValue()).append("'").append(");\n");
                        continue;
                    }
                    settingsMethod.append(attr.getValue()).append(");\n");
                    continue;
                }
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)(attr.getName() + " cannot be set."));
            }
            catch (IntrospectionException ex) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)ex);
            }
        }
        if (gmo.getId() != null && settingsMethod != null) {
            settingsMethod.append(seh.generate(gmo.getId()));
            this.jf.addMethod(new JavaMethod(4, "void", gmo.getId() + "Settings", null, null, settingsMethod.toString(), gmo.getId() + " settings"));
        }
        return constraint;
    }

    private String processAttributes(JavaFile jFile, Class superClazz, GuixModelObject gmo, StringBuffer settingsMethod, SwingEventHandler seh, TagHandler th) {
        String constraint = null;
        this.processCSSAttributes(gmo, jFile);
        for (AttributeDescriptor attr : gmo.getAttributeDescriptors()) {
            if (th != null && th.getAttrToGenerate(attr.getName()) != null) {
                attr.setName(th.getAttrToGenerate(attr.getName()));
            }
            boolean addQuote = false;
            boolean addSimpleQuote = false;
            String capitalizedAttribute = attr.getName().length() > 0 ? Character.toUpperCase(attr.getName().charAt(0)) + attr.getName().substring(1) : attr.getName();
            boolean realAttribute = true;
            try {
                if (attr.getName().startsWith("on") && Character.isUpperCase(attr.getName().charAt(2))) {
                    String lowerCaseAttribute = attr.getName().length() > 2 ? Character.toLowerCase(attr.getName().charAt(2)) + attr.getName().substring(3) : attr.getName();
                    realAttribute = !seh.addEvent(superClazz, lowerCaseAttribute, attr.getValue());
                } else if (attr.getName().equals(CONSTRAINT_ATTRIBUTE)) {
                    constraint = attr.getValue();
                    realAttribute = false;
                }
                if (!realAttribute) continue;
                JavaMethod method = null;
                for (JavaMethod m : jFile.getMethods()) {
                    if (!m.getName().equals("set" + capitalizedAttribute)) continue;
                    method = m;
                    break;
                }
                if (method == null) {
                    for (JavaMethod m : jFile.getInheritedMethods()) {
                        if (!m.getName().equals("set" + capitalizedAttribute)) continue;
                        method = m;
                        break;
                    }
                }
                if (method != null) {
                    String binding = BindingUtils.processDataBindings((String)attr.getValue());
                    if (binding != null) {
                        if (!this.bindings2Generate.containsKey(gmo.getId())) {
                            this.bindings2Generate.put(gmo.getId(), new HashMap());
                        }
                        this.bindings2Generate.get(gmo.getId()).put(attr.getName(), binding);
                        continue;
                    }
                    addQuote = method.getArguments()[0].getType().equals(String.class.getName());
                    addSimpleQuote = method.getArguments()[0].getType().equals(Character.class.getName()) || method.getArguments()[0].getType().equals(Character.TYPE.getName());
                    settingsMethod.append(gmo.getParent() != null ? gmo.getId() : "this").append(".set").append(capitalizedAttribute).append("(");
                    if (addQuote) {
                        settingsMethod.append("\"").append(attr.getValue()).append("\"").append(");\n");
                        continue;
                    }
                    if (addSimpleQuote) {
                        settingsMethod.append("'").append(attr.getValue()).append("'").append(");\n");
                        continue;
                    }
                    settingsMethod.append(attr.getValue()).append(");\n");
                    continue;
                }
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)(attr.getName() + " cannot be set."));
            }
            catch (IntrospectionException ex) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)ex);
            }
        }
        if (gmo.getId() != null && settingsMethod != null) {
            this.jf.addMethod(new JavaMethod(4, "void", gmo.getId() + "Settings", null, null, settingsMethod.toString(), gmo.getId() + " settings"));
        }
        return constraint;
    }

    private void processCSSAttributes(GuixModelObject gmo, SwingEventHandler seh, Class clazz) {
        HashMap cssIds = new HashMap();
        HashMap cssStyleClasses = new HashMap();
        HashMap cssJavaClasses = new HashMap();
        ArrayList<AttributeDescriptor> ads = new ArrayList<AttributeDescriptor>();
        for (StyleSheet styleSheet : this.styleSheets) {
            for (Selector sel : styleSheet.getSelectors()) {
                boolean realAttribute;
                block20: {
                    if (sel.getId() != null && !sel.getId().equals(gmo.getId()) || sel.getStyleClass() != null && !sel.getStyleClass().equals(gmo.getStyleClass()) || sel.getJavaClassName() != null && !sel.getJavaClassName().equals(gmo.getClassDescriptor().getName())) continue;
                    realAttribute = true;
                    if (sel.getPseudoClass() != null && sel.getPseudoClass().startsWith("on") && Character.isUpperCase(sel.getPseudoClass().charAt(2))) {
                        String lowerCaseAttribute = sel.getPseudoClass().length() > 2 ? Character.toLowerCase(sel.getPseudoClass().charAt(2)) + sel.getPseudoClass().substring(3) : sel.getPseudoClass();
                        StringBuffer eventAction = new StringBuffer();
                        for (Rule rule : sel.getRules()) {
                            for (Map.Entry entry : rule.getProperties().entrySet()) {
                                int m;
                                Method[] methods = clazz.getMethods();
                                String capitalizedAttribute = ((String)entry.getKey()).length() > 0 ? Character.toUpperCase(((String)entry.getKey()).charAt(0)) + ((String)entry.getKey()).substring(1) : (String)entry.getKey();
                                for (m = 0; m < methods.length && !methods[m].getName().equals("set" + capitalizedAttribute); ++m) {
                                }
                                if (m < methods.length) {
                                    boolean addQuote = methods[m].getParameterTypes()[0].equals(String.class);
                                    eventAction.append(gmo.getId()).append(".set").append(capitalizedAttribute).append("(").append(addQuote ? "\"" : "").append((String)entry.getValue()).append(addQuote ? "\"" : "").append(");\n");
                                    continue;
                                }
                                if (!this.log.isErrorEnabled()) continue;
                                this.log.error((Object)((String)entry.getKey() + " cannot be set."));
                            }
                        }
                        try {
                            realAttribute = !seh.addEvent(clazz, lowerCaseAttribute, eventAction.toString());
                        }
                        catch (IntrospectionException ex) {
                            if (!this.log.isErrorEnabled()) break block20;
                            this.log.error((Object)("Error while adding event " + sel.getPseudoClass()));
                        }
                    }
                }
                if (!realAttribute) continue;
                if (sel.getId() != null && sel.getId().equals(gmo.getId())) {
                    for (Rule rule : sel.getRules()) {
                        for (Map.Entry entry : rule.getProperties().entrySet()) {
                            cssIds.put(entry.getKey(), entry.getValue());
                        }
                    }
                    continue;
                }
                if (sel.getStyleClass() != null && sel.getStyleClass().equals(gmo.getStyleClass())) {
                    for (Rule rule : sel.getRules()) {
                        for (Map.Entry entry : rule.getProperties().entrySet()) {
                            cssStyleClasses.put(entry.getKey(), entry.getValue());
                        }
                    }
                    continue;
                }
                if (sel.getJavaClassName() == null || !sel.getJavaClassName().equals(gmo.getClassDescriptor().getName())) continue;
                for (Rule rule : sel.getRules()) {
                    for (Map.Entry entry : rule.getProperties().entrySet()) {
                        cssJavaClasses.put(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        for (Map.Entry entry : cssIds.entrySet()) {
            ads.add(new AttributeDescriptor((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry entry : cssStyleClasses.entrySet()) {
            if (cssIds.containsKey(entry.getKey())) continue;
            ads.add(new AttributeDescriptor((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry entry : cssJavaClasses.entrySet()) {
            if (cssIds.containsKey(entry.getKey()) || cssStyleClasses.containsKey(entry.getKey())) continue;
            ads.add(new AttributeDescriptor((String)entry.getKey(), (String)entry.getValue()));
        }
        gmo.getAttributeDescriptors().addAll(ads);
    }

    private void processCSSAttributes(GuixModelObject gmo, JavaFile jFile) {
        HashMap cssIds = new HashMap();
        HashMap cssStyleClasses = new HashMap();
        HashMap cssJavaClasses = new HashMap();
        ArrayList<AttributeDescriptor> ads = new ArrayList<AttributeDescriptor>();
        for (StyleSheet styleSheet : this.styleSheets) {
            for (Selector sel : styleSheet.getSelectors()) {
                if (sel.getId() != null && !sel.getId().equals(gmo.getId()) || sel.getStyleClass() != null && !sel.getStyleClass().equals(gmo.getStyleClass()) || sel.getJavaClassName() != null && !sel.getJavaClassName().equals(gmo.getClassDescriptor().getName())) continue;
                if (sel.getPseudoClass() != null && sel.getPseudoClass().startsWith("on") && Character.isUpperCase(sel.getPseudoClass().charAt(2))) {
                    StringBuffer eventAction = new StringBuffer();
                    for (Rule rule : sel.getRules()) {
                        for (Map.Entry entry : rule.getProperties().entrySet()) {
                            String capitalizedAttribute = ((String)entry.getKey()).length() > 0 ? Character.toUpperCase(((String)entry.getKey()).charAt(0)) + ((String)entry.getKey()).substring(1) : (String)entry.getKey();
                            JavaMethod method = null;
                            for (JavaMethod m : jFile.getMethods()) {
                                if (!m.getName().equals("set" + capitalizedAttribute)) continue;
                                method = m;
                                break;
                            }
                            if (method != null) {
                                boolean addQuote = method.getArguments()[0].getType().equals(String.class.getName());
                                eventAction.append(gmo.getId()).append(".set").append(capitalizedAttribute).append("(").append(addQuote ? "\"" : "").append((String)entry.getValue()).append(addQuote ? "\"" : "").append(");\n");
                                continue;
                            }
                            if (!this.log.isErrorEnabled()) continue;
                            this.log.error((Object)((String)entry.getKey() + " cannot be set."));
                        }
                    }
                }
                if (sel.getId() != null && sel.getId().equals(gmo.getId())) {
                    for (Rule rule : sel.getRules()) {
                        for (Map.Entry entry : rule.getProperties().entrySet()) {
                            cssIds.put(entry.getKey(), entry.getValue());
                        }
                    }
                    continue;
                }
                if (sel.getStyleClass() != null && sel.getStyleClass().equals(gmo.getStyleClass())) {
                    for (Rule rule : sel.getRules()) {
                        for (Map.Entry entry : rule.getProperties().entrySet()) {
                            cssStyleClasses.put(entry.getKey(), entry.getValue());
                        }
                    }
                    continue;
                }
                if (sel.getJavaClassName() == null || !sel.getJavaClassName().equals(gmo.getClassDescriptor().getName())) continue;
                for (Rule rule : sel.getRules()) {
                    for (Map.Entry entry : rule.getProperties().entrySet()) {
                        cssJavaClasses.put(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        for (Map.Entry entry : cssIds.entrySet()) {
            ads.add(new AttributeDescriptor((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry entry : cssStyleClasses.entrySet()) {
            if (cssIds.containsKey(entry.getKey())) continue;
            ads.add(new AttributeDescriptor((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry entry : cssJavaClasses.entrySet()) {
            if (cssIds.containsKey(entry.getKey()) || cssStyleClasses.containsKey(entry.getKey())) continue;
            ads.add(new AttributeDescriptor((String)entry.getKey(), (String)entry.getValue()));
        }
        gmo.getAttributeDescriptors().addAll(ads);
    }

    public Map<String, Map<String, String>> getBindings2Generate() {
        return this.bindings2Generate;
    }
}

