/**
 * *##% guix-compiler-swing
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.generator;

//~--- non-JDK imports --------------------------------------------------------
import org.nuiton.guix.model.GuixModelObject;

//~--- JDK imports ------------------------------------------------------------

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Generator of the launcher class
 *
 * @author morin
 */
public class SwingMainClassGenerator {

    private JavaFile clazz;
    private GuixModelObject gmo;
    private Log log = LogFactory.getLog(SwingMainClassGenerator.class);

    /**
     * Constructor
     *
     * @param gmo the GuixModelObject that represents the master class of the application
     */
    public SwingMainClassGenerator(GuixModelObject gmo) {
        this.gmo = gmo;
        clazz = new JavaFile(Modifier.PUBLIC,
                JavaFile.CLASS,
                gmo.getClassDescriptor().getPackageName(),
                "Main", null, null);
    }

    /**
     * Generates the code of the file
     *
     * @param out the file to record the content
     */
    public void generate(File out) {
        String gmoClass = gmo.getClassDescriptor().toString();

        clazz.addImport("java.io.File");
//        clazz.addImport("org.springframework.beans.factory.ListableBeanFactory");
//        clazz.addImport("org.springframework.beans.factory.xml.XmlBeanFactory");
//        clazz.addImport("org.springframework.core.io.FileSystemResource");

        StringBuffer mainMethod = new StringBuffer();
        mainMethod.append("javax.swing.SwingUtilities.invokeLater(").append("new Runnable() {\n").append("public void run() {\n")
                .append(gmoClass).append("Impl main = new ").append(gmoClass).append("Impl();\n")
                .append("main.setVisible(true);\n}\n});");

        clazz.addMethod(new JavaMethod(
                Modifier.PUBLIC | Modifier.STATIC,
                "void",
                "main",
                new JavaArgument[]{new JavaArgument("String[]", "args")},
                null,
                mainMethod.toString(),
                null));

        saveFile(out);
    }

    /**
     * Fills and saves the generated file
     * @param out the file to record
     */
    private void saveFile(File out) {
        FileWriter fw = null;
        try {
            if (!out.exists()) {
                out.createNewFile();
            }
            fw = new FileWriter(out);
            fw.write(clazz.toString("\n"));
            fw.close();
        }
        catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error(ex);
            }
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                log.error(ex);
            }
        }
    }
}

