/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.eugene.plugin.Xmi2Model;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Xmi2ObjectModel
extends Xmi2Model {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Conversion of XMI files into ObjectModel");
        super.execute();
    }

    @Override
    public String getExtension() {
        return "objectmodel";
    }

    @Override
    protected String getStyleSheet(File model) {
        String styleSheet = null;
        String version = this.getXmiVersion(model);
        if (version.startsWith("1.")) {
            styleSheet = "xmi1.2ToObjectModel.xsl";
        } else if (version.startsWith("2.")) {
            styleSheet = "xmi2.1ToObjectModel.xsl";
        } else {
            this.getLog().error((CharSequence)("Unsupported xmi version [" + version + "]"));
        }
        return styleSheet;
    }

    protected String getXmiVersion(File xmiFile) {
        String version = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            XmiVersionHandler handler = new XmiVersionHandler();
            parser.parse(xmiFile, (DefaultHandler)handler);
            version = handler.getVersion();
        }
        catch (ParserConfigurationException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        catch (SAXException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Can't parse file as xmi", (Throwable)e);
        }
        return version;
    }

    protected class XmiVersionHandler
    extends DefaultHandler {
        public String version = null;

        public String getVersion() {
            return this.version;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("XMI")) {
                this.version = attributes.getValue("xmi.version");
                Xmi2ObjectModel.this.getLog().debug((CharSequence)("XMI version found : " + this.version));
            }
            if (this.version == null) {
                this.version = attributes.getValue("xmi:version");
                Xmi2ObjectModel.this.getLog().debug((CharSequence)("XMI version found : " + this.version));
            }
        }
    }
}

