/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.nuiton.eugene.models.stereotype.StereotypeDefinitionProvider;
import org.nuiton.eugene.plugin.AbstractEugeneReport;
import org.nuiton.eugene.plugin.renderer.StereotypesReportRenderer;

@Mojo(name="stereotypes-report", requiresProject=true, requiresReports=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class StereotypesReport
extends AbstractEugeneReport<StereotypeDefinitionProvider> {
    @Parameter(property="eugene.providerName", defaultValue="${project.artifactId}", required=true)
    protected String providerName;
    @Component(role=StereotypeDefinitionProvider.class)
    protected Map<String, StereotypeDefinitionProvider> providers;

    @Override
    protected StereotypeDefinitionProvider initData(Locale locale) throws MavenReportException {
        StereotypeDefinitionProvider provider = this.providers.get(this.providerName);
        if (provider == null) {
            String errorMessage = this.i18n.format(this.getOutputName(), locale, "stereotypeProvider.not.found", (Object)this.providerName);
            throw new MavenReportException(errorMessage);
        }
        provider.init();
        return provider;
    }

    protected StereotypesReportRenderer createRenderer(Locale locale, StereotypeDefinitionProvider data) {
        StereotypesReportRenderer renderer = new StereotypesReportRenderer(this.getSink(), this.i18n, locale, this.getOutputName(), this.javaDocDestDir, this.jxrDestDir, data);
        return renderer;
    }

    public String getOutputName() {
        return "stereotypes-report";
    }
}

