/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.nuiton.eugene.writer.AbstractChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;

public abstract class BaseChainedFileWriter
extends AbstractChainedFileWriter {
    private Log log;

    protected BaseChainedFileWriter(String ... propertyNameAndDescriptions) {
        super(propertyNameAndDescriptions);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public final List<URL> getFiles(ChainedFileWriterConfiguration configuration, String inputPath, List<String> includePattern, boolean inClassPath) throws MalformedURLException, IllegalArgumentException {
        if (CollectionUtils.isEmpty(includePattern)) {
            throw new IllegalArgumentException("Must have at least one include pattern");
        }
        ArrayList<URL> result = new ArrayList<URL>();
        if (!inClassPath) {
            DirectoryScanner ds = new DirectoryScanner();
            File inputDirectory = new File(inputPath);
            ds.setBasedir(inputDirectory);
            ds.setIncludes(includePattern.toArray(new String[includePattern.size()]));
            ds.setExcludes(null);
            ds.addDefaultExcludes();
            ds.scan();
            for (String file : ds.getIncludedFiles()) {
                File in = new File(inputDirectory, file);
                result.add(in.toURI().toURL());
            }
            return result;
        }
        ClassLoader loader = configuration.getClassLoader();
        for (String pattern : includePattern) {
            String path = inputPath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if ((path = path + pattern).startsWith("/")) {
                path = path.substring(1);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Try to seek class-path file " + path));
            }
            if (pattern.contains("*")) {
                List urlList = Resource.getURLs((String)path, (URLClassLoader)((URLClassLoader)loader));
                if (CollectionUtils.isEmpty((Collection)urlList)) {
                    this.getLog().warn((CharSequence)("Could not find in class-path files " + path));
                    continue;
                }
                for (URL url : urlList) {
                    if (configuration.isVerbose()) {
                        this.getLog().info((CharSequence)("Detected class-path file " + url));
                    }
                    result.add(url);
                }
                continue;
            }
            URL url = loader.getResource(path);
            if (url == null) {
                this.getLog().warn((CharSequence)("Could not find in class-path the file " + path));
                continue;
            }
            if (configuration.isVerbose()) {
                this.getLog().info((CharSequence)("Detected class-path file " + url));
            }
            result.add(url);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<URL> getResources(URL file) throws IOException {
        String path = file.toString();
        String extension = "." + FileUtil.extension((String)path, (String[])new String[0]);
        String filename = FileUtil.basename((String)path, (String[])new String[]{extension}).concat(".properties");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("path of file : " + path));
            this.getLog().info((CharSequence)("path of resource : " + filename));
        }
        URL propertiesFile = URI.create(filename).toURL();
        if (path.startsWith("file:")) {
            if (!new File(propertiesFile.getFile()).exists()) {
                return null;
            }
            return Arrays.asList(propertiesFile);
        }
        InputStream in = null;
        try {
            in = propertiesFile.openStream();
            List<URL> list = Arrays.asList(propertiesFile);
            return list;
        }
        catch (IOException eee) {
            this.getLog().warn((CharSequence)("Could not find resource " + propertiesFile));
            List<URL> list = null;
            return list;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected void initWriter(ChainedFileWriterConfiguration configuration) {
        super.initWriter(configuration);
        if (!configuration.isVerbose()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        Set set = this.getAuthorizedPropertyDescriptions().entrySet();
        if (set.isEmpty()) {
            buffer.append("Writer [");
            buffer.append(this.getInputProtocol());
            buffer.append("]");
            buffer.append(" does not use any specific properties.");
        } else {
            buffer.append("Writer [");
            buffer.append(this.getInputProtocol());
            buffer.append("]");
            buffer.append(" use ");
            buffer.append(this.properties.size());
            buffer.append(" properties :");
            if (this.getLog().isInfoEnabled()) {
                for (Map.Entry e : set) {
                    String key = (String)e.getKey();
                    Object value = this.properties.get(key);
                    if (value == null) continue;
                    buffer.append("\n");
                    buffer.append("  [");
                    buffer.append(key);
                    buffer.append("] (");
                    buffer.append((String)e.getValue());
                    buffer.append(") : ");
                    buffer.append(value);
                }
            }
        }
        this.getLog().info((CharSequence)buffer.toString());
    }

    protected boolean acceptObjectModelOrStateModel(String modelType) {
        return "objectmodel".equals(modelType = modelType.trim().toLowerCase()) || "statemodel".equals(modelType);
    }

    protected void copyResources(ChainedFileWriterConfiguration configuration, File outputDirectory, File inputDirectory, File file, Map<File, List<File>> resourcesByFile) throws IOException {
        List<File> resources = resourcesByFile.get(file);
        if (CollectionUtils.isEmpty(resources)) {
            if (configuration.isVerbose()) {
                this.getLog().info((CharSequence)("No resources to copy for file " + file));
            }
            return;
        }
        if (configuration.isVerbose()) {
            this.getLog().info((CharSequence)("Copy " + resources.size() + " resource file(s)."));
        }
        boolean overwrite = configuration.isOverwrite();
        for (File in : resources) {
            File out = FileUtil.getRelativeFile((File)inputDirectory, (File)outputDirectory, (File)in);
            this.getLog().info((CharSequence)("Copy file " + in + " to " + out));
            if (overwrite) {
                FileUtils.copyFile((File)in, (File)out);
                continue;
            }
            FileUtils.copyFileIfModified((File)in, (File)out);
        }
    }
}

