/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuiton.eugene.ModelPropertiesUtil;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.ChainedFileWriterToMemoryModel;

public abstract class BaseChainedFileWriterToMemoryModel
extends BaseChainedFileWriter
implements ChainedFileWriterToMemoryModel {
    public static final String PROP_MODEL_READER = "modelReader";
    public static final String PROP_MODEL_PROPERTIES_PROVIDER = "modelPropertiesProvider";
    public static final String PROP_READER = "reader";
    protected Model model;
    protected long lastModifiedSource;
    protected File outputDirectory;

    protected BaseChainedFileWriterToMemoryModel() {
        super(PROP_READER, PROP_READER, PROP_MODEL_READER, "xmlModelReader", PROP_MODEL_PROPERTIES_PROVIDER, PROP_MODEL_PROPERTIES_PROVIDER);
    }

    public Model getModel() {
        return this.model;
    }

    public long getLastModifiedSource() {
        return this.lastModifiedSource;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getOutputProtocol(String modelType) {
        return null;
    }

    public boolean acceptModel(String modelType) {
        return this.acceptObjectModelOrStateModel(modelType);
    }

    protected abstract String getInputType();

    protected ModelReader<?> getModelReader() {
        return (ModelReader)this.getProperty(PROP_MODEL_READER, ModelReader.class);
    }

    protected String getReader() {
        return (String)this.getProperty(PROP_READER, String.class);
    }

    protected ModelPropertiesUtil.ModelPropertiesProvider getModelPropertiesProvider() {
        return (ModelPropertiesUtil.ModelPropertiesProvider)this.getProperty(PROP_MODEL_PROPERTIES_PROVIDER, ModelPropertiesUtil.ModelPropertiesProvider.class);
    }

    @Override
    protected void initWriter(ChainedFileWriterConfiguration configuration) {
        ClassLoader classLoader;
        super.initWriter(configuration);
        ClassLoader loader = classLoader = configuration.getClassLoader();
        if (this.getModelReader() == null) {
            String modelType = configuration.getModelType();
            if (this.getReader() != null) {
                String reader = this.getReader();
                try {
                    ClassLoader fixedClassLoader = loader;
                    ModelReader modelReader = (ModelReader)Class.forName(reader, true, fixedClassLoader).newInstance();
                    String modelTypeFromReader = modelReader.getModelType();
                    if (!modelType.equals(modelTypeFromReader)) {
                        throw new IllegalStateException("Model reader [" + modelTypeFromReader + "] does not match with modelType: " + modelType);
                    }
                    this.properties.put(PROP_MODEL_READER, modelReader);
                }
                catch (IllegalStateException eee) {
                    throw eee;
                }
                catch (Exception eee) {
                    throw new IllegalStateException("could not obtain reader " + reader, eee);
                }
            } else {
                String inputType = this.getInputType();
                ModelReader modelReader = configuration.getModelHelper().getModelReader(modelType, inputType);
                if (modelReader == null) {
                    throw new IllegalStateException("could not find a model reader for modelType: " + modelType + ", and input type: " + inputType + ", availables readers : " + configuration.getModelHelper().getModelReaders().values());
                }
                this.properties.put(PROP_MODEL_READER, modelReader);
            }
        }
        boolean verbose = configuration.isVerbose();
        ModelPropertiesUtil.ModelPropertiesProvider propertiesProvider = this.getModelPropertiesProvider();
        this.getModelReader().setModelPropertiesProvider(propertiesProvider);
        this.getModelReader().setVerbose(verbose);
    }

    public void generate(ChainedFileWriterConfiguration configuration, File outputDir, Map<File, List<File>> filesByRoot, Map<File, List<File>> resourcesByFile) throws IOException {
        HashSet<File> modelFiles = new HashSet<File>();
        for (List<File> files : filesByRoot.values()) {
            modelFiles.addAll(files);
        }
        File[] filesToRead = modelFiles.toArray(new File[modelFiles.size()]);
        if (configuration.isVerbose()) {
            this.getLog().info((CharSequence)("Will read " + filesToRead.length + " model(s)."));
        }
        this.model = this.getModelReader().read(filesToRead);
        this.lastModifiedSource = this.getModelReader().getLastModifiedSource();
        this.outputDirectory = outputDir;
    }
}

