/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.renderer;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.i18n.I18N;
import org.nuiton.eugene.models.stereotype.StereotypeDefinition;
import org.nuiton.eugene.models.stereotype.StereotypeDefinitionProvider;
import org.nuiton.eugene.plugin.renderer.AbstractEugeneReportRenderer;

public class StereotypesReportRenderer
extends AbstractEugeneReportRenderer<StereotypeDefinitionProvider, StereotypeDefinition> {
    public StereotypesReportRenderer(Sink sink, I18N i18n, Locale locale, String bundleName, String javaDocDestDir, String jxrDestDir, StereotypeDefinitionProvider data) {
        super(sink, i18n, locale, bundleName, javaDocDestDir, jxrDestDir, data);
    }

    @Override
    protected Map<String, StereotypeDefinition> getDataDetails() {
        return ((StereotypeDefinitionProvider)this.data).getDefinition();
    }

    @Override
    protected void renderSummaryTable(StereotypeDefinitionProvider provider, Map<String, StereotypeDefinition> details) {
        if (MapUtils.isEmpty(details)) {
            this.sink.text(this.getText("report.noStereotype"));
        } else {
            this.sink.section3();
            this.sink.sectionTitle3();
            this.sink.text(this.getText("report.summary.stereotype"));
            this.sink.sectionTitle3_();
            this.sink.lineBreak();
            this.sink.table();
            this.sink.tableRow();
            this.sinkHeaderCellText(this.getText("report.stereotype.name"));
            this.sinkHeaderCellText(this.getText("report.stereotype.description"));
            this.sink.tableRow_();
            for (Map.Entry<String, StereotypeDefinition> entry : details.entrySet()) {
                String stereotypeName = entry.getKey();
                StereotypeDefinition stereotypeDefinition = entry.getValue();
                this.sink.tableRow();
                this.sinkCellLink(stereotypeName, "./" + this.bundleName + ".html#detail_" + stereotypeName);
                this.sinkCellText(stereotypeDefinition.documentation());
                this.sink.tableRow_();
            }
            this.sink.table_();
            this.sink.section3_();
        }
    }

    @Override
    protected void renderDetail(String key, StereotypeDefinition detail) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.anchor("detail_" + key);
        this.sink.text(this.getText("report.detail.stereotype.title") + "   " + key);
        this.sink.anchor_();
        this.sink.sectionTitle2_();
        this.sink.lineBreak();
        this.sink.table();
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.detail.stereotype.name"));
        this.sinkCellText(key);
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.detail.stereotype.description"));
        this.sinkCellText(detail.documentation());
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText(this.getText("report.detail.stereotype.target"));
        this.sink.tableCell();
        this.renderTargets(detail.target());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.text(this.getText("report.detail.stereotype.usage.title"));
        this.sink.sectionTitle3_();
        this.sink.text("//TODO Example of usage of this stereotype");
        this.sink.section3_();
        this.sink.section2_();
    }

    @Override
    protected String getEugeneDocLink() {
        String url = this.locale.getCountry().equals(Locale.FRENCH.getCountry()) ? "http://doc.nuiton.org/eugene/fr/eugene/stereotypes.html" : "http://doc.nuiton.org/eugene/eugene/stereotypes.html";
        return url;
    }
}

