/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.servicediscovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.dinopolis.util.servicediscovery.ServiceInfo;

public class ServiceDiscovery {
    protected static final String SERVICE_HOME = "META-INF/services/";
    protected Vector class_loaders_ = new Vector();

    public ServiceDiscovery() {
        this(true);
    }

    public ServiceDiscovery(boolean use_system_classloader) {
        if (use_system_classloader) {
            this.addClassLoader(ClassLoader.getSystemClassLoader());
        }
    }

    public void addClassLoader(ClassLoader loader) {
        this.class_loaders_.addElement(loader);
    }

    public ClassLoader getThreadClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo[] findServices(String name) {
        Vector<ServiceInfo> results = new Vector<ServiceInfo>();
        String service_file = SERVICE_HOME + name;
        for (int loader_count = 0; loader_count < this.class_loaders_.size(); ++loader_count) {
            ClassLoader loader = (ClassLoader)this.class_loaders_.elementAt(loader_count);
            Enumeration<URL> enumeration = null;
            try {
                enumeration = loader.getResources(service_file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (enumeration == null) continue;
            while (enumeration.hasMoreElements()) {
                try {
                    URL url = enumeration.nextElement();
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    try {
                        BufferedReader rd;
                        try {
                            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            rd = new BufferedReader(new InputStreamReader(is));
                        }
                        try {
                            String service_class_name;
                            while ((service_class_name = rd.readLine()) != null) {
                                service_class_name.trim();
                                if ("".equals(service_class_name) || service_class_name.startsWith("#")) continue;
                                ServiceInfo sinfo = new ServiceInfo();
                                sinfo.setClassName(service_class_name);
                                sinfo.setLoader(loader);
                                sinfo.setURL(url);
                                results.add(sinfo);
                            }
                        }
                        finally {
                            rd.close();
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ioe) {}
            }
        }
        Object[] result_array = new ServiceInfo[results.size()];
        results.copyInto(result_array);
        return result_array;
    }

    public Object[] getServices(String class_name) {
        try {
            return this.getServices(Class.forName(class_name));
        }
        catch (ClassNotFoundException cnfe) {
            return new Object[0];
        }
    }

    public Object[] getServices(Class clazz) {
        ServiceInfo[] service_infos = this.findServices(clazz.getName());
        Vector results = new Vector();
        for (int count = 0; count < service_infos.length; ++count) {
            try {
                ClassLoader loader = service_infos[count].getLoader();
                Object service = loader.loadClass(service_infos[count].getClassName()).newInstance();
                if (clazz.isInstance(service)) {
                    results.add(service);
                    continue;
                }
                System.err.println("ServiceDiscovery: Service '" + service_infos[count].getClassName() + "' is not an instance of class " + clazz.getName());
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
                continue;
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
                continue;
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
        }
        Object[] result_array = new Object[results.size()];
        results.copyInto(result_array);
        return result_array;
    }
}

