/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.io;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.dinopolis.util.io.FileChangeListener;

public class FileChangeDetection
extends Thread {
    protected static final long DEFAULT_LOOKUP_PERIOD = 5000L;
    protected String filename_;
    protected long lookup_period_;
    protected boolean loop_thread_;
    protected long last_modified_ = -1L;
    protected File observed_file_;
    protected Vector listeners_;

    public FileChangeDetection() {
        this.setLookupPeriod(5000L);
    }

    public FileChangeDetection(String filename) {
        this(filename, 5000L);
    }

    public FileChangeDetection(String filename, long lookup_period) {
        this.setFile(filename);
        this.setLookupPeriod(lookup_period);
    }

    public void setFile(String filename) {
        this.setFile(new File(filename));
    }

    public void setFile(File file) {
        this.observed_file_ = file;
    }

    public void setLookupPeriod(long lookup_period) {
        this.lookup_period_ = lookup_period;
    }

    public void startChangeDetection() {
        this.loop_thread_ = true;
        super.start();
    }

    public void stopChangeDetection() {
        this.loop_thread_ = false;
    }

    public void addFileChangeListener(FileChangeListener listener) {
        if (this.listeners_ == null) {
            this.listeners_ = new Vector();
        }
        if (listener != null) {
            this.listeners_.add(listener);
        }
    }

    public void remoteFileChangeListener(FileChangeListener listener) {
        if (this.listeners_ == null) {
            return;
        }
        this.listeners_.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeDetected() {
        if (this.listeners_ == null) {
            return;
        }
        Vector listeners = new Vector();
        Vector vector = this.listeners_;
        synchronized (vector) {
            listeners.addAll(this.listeners_);
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ((FileChangeListener)iterator.next()).fileChanged(this.observed_file_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.loop_thread_) {
            if (this.observed_file_ != null) {
                long modified = this.observed_file_.lastModified();
                if (modified != this.last_modified_ && this.last_modified_ >= 0L) {
                    this.fireChangeDetected();
                }
                this.last_modified_ = modified;
            }
            FileChangeDetection fileChangeDetection = this;
            synchronized (fileChangeDetection) {
                try {
                    this.wait(this.lookup_period_);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
    }
}

