/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui.property_editor;

import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.JPanel;

public class ArrayEditor
extends PropertyEditorSupport
implements PropertyChangeListener {
    private JPanel editing_component_;
    private Class base_type_;
    private PropertyEditor base_editor_;
    private PropertyEditor[] base_editors_;
    public static final String DELIMITER = ",";
    public static final String ESCAPE = "\\";

    public ArrayEditor(Class base_type, PropertyEditor base_editor) {
        this.base_type_ = base_type;
        this.base_editor_ = base_editor;
        this.base_editors_ = new PropertyEditor[0];
    }

    public String getAsText() {
        Object value = this.getValue();
        int value_length = 0;
        if (value != null) {
            value_length = Array.getLength(value);
        }
        StringBuffer buffer = new StringBuffer();
        for (int count = 0; count < value_length; ++count) {
            if (count > 0) {
                buffer.append(DELIMITER);
            }
            this.base_editor_.setValue(Array.get(value, count));
            buffer.append(ArrayEditor.escape(this.base_editor_.getAsText()));
        }
        return buffer.toString();
    }

    public void setAsText(String value) {
        int delim_start_pos = 0;
        int delim_pos = value.indexOf(DELIMITER, delim_start_pos);
        Vector<String> elements = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        while (delim_pos > 0) {
            int escape_pos;
            for (escape_pos = delim_pos; escape_pos > 0 && ESCAPE.equals(value.substring(escape_pos - ESCAPE.length(), escape_pos)); escape_pos -= ESCAPE.length()) {
            }
            if ((delim_pos - escape_pos / ESCAPE.length()) % 2 == 0) {
                elements.add(value.substring(delim_start_pos, delim_pos));
                delim_start_pos = delim_pos + DELIMITER.length();
            }
            delim_pos = value.indexOf(DELIMITER, delim_pos + DELIMITER.length());
        }
        elements.add(value.substring(delim_start_pos));
        int elements_count = elements.size();
        Object array = Array.newInstance(this.base_type_, elements_count);
        for (int count = 0; count < elements_count; ++count) {
            this.base_editor_.setAsText(ArrayEditor.unescape((String)elements.elementAt(count)));
            Array.set(array, count, this.base_editor_.getValue());
        }
        this.setValue(array);
    }

    public Component getCustomEditor() {
        if (this.editing_component_ == null) {
            this.createEditingComponent();
        }
        return this.editing_component_;
    }

    protected void createEditingComponent() {
        this.editing_component_ = new JPanel();
        this.editing_component_.setLayout(new GridLayout(1, 0));
        this.editing_component_.removeAll();
        for (int count = 0; count < this.base_editors_.length; ++count) {
            this.base_editors_[count].removePropertyChangeListener(this);
        }
        Object value = this.getValue();
        int value_length = 0;
        if (value != null) {
            value_length = Array.getLength(value);
        }
        this.base_editors_ = new PropertyEditor[value_length];
        try {
            for (int count = 0; count < this.base_editors_.length; ++count) {
                this.base_editors_[count] = (PropertyEditor)this.base_editor_.getClass().newInstance();
                this.base_editors_[count].addPropertyChangeListener(this);
                Component comp = this.base_editors_[count].getCustomEditor();
                if (comp != null) {
                    this.editing_component_.add(comp);
                    continue;
                }
                System.err.println("NULL EDITOR !!!!! : " + this.base_editors_[count]);
            }
            this.updateValues();
        }
        catch (InstantiationException exc) {
            exc.printStackTrace();
            this.editing_component_ = null;
        }
        catch (IllegalAccessException exc) {
            exc.printStackTrace();
            this.editing_component_ = null;
        }
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.updateValues();
    }

    protected void updateValues() {
        if (this.editing_component_ == null) {
            return;
        }
        Object value = this.getValue();
        int value_length = 0;
        if (value != null) {
            value_length = Array.getLength(value);
        }
        for (int count = 0; count < Math.min(value_length, this.base_editors_.length); ++count) {
            this.base_editors_[count].removePropertyChangeListener(this);
            this.base_editors_[count].setValue(Array.get(value, count));
            this.base_editors_[count].addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object[] values = new Object[this.base_editors_.length];
        boolean[] null_values = new boolean[this.base_editors_.length];
        for (int count = 0; count < values.length; ++count) {
            values[count] = this.base_editors_[count].getValue();
            null_values[count] = values[count] == null;
        }
        int real_values_length = values.length;
        Object array = Array.newInstance(this.base_type_, real_values_length);
        for (int count = 0; count < real_values_length; ++count) {
            Array.set(array, count, this.base_editors_[count].getValue());
        }
        this.setValue(array);
    }

    public static String escape(String to_escape) {
        to_escape = ArrayEditor.replace(to_escape, DELIMITER, "\\,");
        return to_escape;
    }

    public static String unescape(String to_unescape) {
        to_unescape = ArrayEditor.replace(to_unescape, "\\,", DELIMITER);
        return to_unescape;
    }

    protected static String replace(String str, String old_str, String new_str) {
        int old_index = 0;
        int index = 0;
        StringBuffer result = new StringBuffer(str.length());
        while (index >= 0 && old_index < str.length()) {
            index = str.indexOf(old_str, old_index);
            if (index < 0) continue;
            result.append(str.substring(old_index, index)).append(new_str);
            old_index = index + old_str.length();
        }
        result.append(str.substring(old_index, str.length()));
        return result.toString();
    }

    public static void main(String[] args) {
        String s = "c:\\und\\no,ch\\was\\\\und noch weiter";
        System.out.println("original: " + s);
        String s2 = ArrayEditor.escape(s);
        System.out.println("escaped: " + s2);
        System.out.println("unescaped again: " + ArrayEditor.unescape(s2));
    }
}

