/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.gui;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value_;
    private ThreadVar thread_var_;
    protected String name_ = "";

    protected synchronized Object getValue() {
        return this.value_;
    }

    private synchronized void setValue(Object x) {
        this.value_ = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.thread_var_.get();
        if (t != null) {
            t.interrupt();
        }
        this.thread_var_.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.thread_var_.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.thread_var_.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        this.thread_var_ = new ThreadVar(t);
    }

    public void start() {
        Thread t = this.thread_var_.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

