/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.FileHeaderFilter;
import org.codehaus.mojo.license.header.FileHeaderProcessorConfiguration;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.processor.Processor;
import org.nuiton.processor.filters.Filter;

@Component(role=Processor.class, hint="file-header")
public class FileHeaderProcessor
extends Processor {
    protected FileHeaderProcessorConfiguration configuration;
    protected FileHeaderFilter filter;

    public FileHeaderProcessorConfiguration getConfiguration() {
        return this.configuration;
    }

    public FileHeaderFilter getFilter() {
        return this.filter;
    }

    public boolean isTouched() {
        return this.getFilter() != null && this.getFilter().isTouched();
    }

    public boolean isModified() {
        return this.getFilter() != null && this.getFilter().isModified();
    }

    public boolean isDetectHeader() {
        return this.getFilter() != null && this.getFilter().isDetectHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File filein, File fileout) throws IOException {
        this.checkInit();
        this.reset();
        FileReader input = new FileReader(filein);
        try {
            FileWriter output = new FileWriter(fileout);
            try {
                this.process(input, output);
            }
            finally {
                output.close();
            }
        }
        finally {
            input.close();
        }
    }

    public void populateFilter() {
        FileHeaderTransformer transformer;
        FileHeader fileHeader = this.getConfiguration().getFileHeader();
        boolean change = false;
        if (!fileHeader.equals(this.filter.getFileHeader())) {
            this.filter.setFileHeader(fileHeader);
            change = true;
        }
        if (!(transformer = this.getConfiguration().getTransformer()).equals(this.filter.getTransformer())) {
            this.filter.setTransformer(transformer);
            change = true;
        }
        if (change) {
            this.filter.resetContent();
        }
    }

    public void setConfiguration(FileHeaderProcessorConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setFilter(FileHeaderFilter filter) {
        this.filter = filter;
        this.setInputFilter((Filter)filter);
    }

    public void reset() {
        if (this.filter != null) {
            this.filter.reset();
        }
    }

    protected FileHeader getFileHeader() {
        return this.getConfiguration().getFileHeader();
    }

    protected FileHeaderTransformer getTransformer() {
        return this.getConfiguration().getTransformer();
    }

    protected void checkInit() {
        if (this.getConfiguration() == null) {
            throw new IllegalStateException("no configuration set.");
        }
        if (this.getFileHeader() == null) {
            throw new IllegalStateException("no file header set.");
        }
        if (this.getTransformer() == null) {
            throw new IllegalStateException("no file header transformer set.");
        }
        if (this.getFilter() == null) {
            throw new IllegalStateException("no file header filter set.");
        }
    }
}

