/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.ELContextImpl;
import org.apache.jasper.runtime.PageContextImpl;
import org.apache.jasper.runtime.VariableMapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspContextWrapper
extends PageContext {
    private PageContext invokingJspCtxt;
    private Hashtable pageAttributes;
    private ArrayList nestedVars;
    private ArrayList atBeginVars;
    private ArrayList atEndVars;
    private Map aliases;
    private Hashtable originalNestedVars;
    private ELContext elContext;

    public JspContextWrapper(JspContext jspContext, ArrayList nestedVars, ArrayList atBeginVars, ArrayList atEndVars, Map aliases) {
        this.invokingJspCtxt = (PageContext)jspContext;
        this.nestedVars = nestedVars;
        this.atBeginVars = atBeginVars;
        this.atEndVars = atEndVars;
        this.pageAttributes = new Hashtable(16);
        this.aliases = aliases;
        if (nestedVars != null) {
            this.originalNestedVars = new Hashtable(nestedVars.size());
        }
        this.syncBeginTagFile();
    }

    @Override
    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        return this.pageAttributes.get(name);
    }

    @Override
    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            return this.pageAttributes.get(name);
        }
        return this.invokingJspCtxt.getAttribute(name, scope);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (value != null) {
            this.pageAttributes.put(name, value);
        } else {
            this.removeAttribute(name, 1);
        }
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            if (value != null) {
                this.pageAttributes.put(name, value);
            } else {
                this.removeAttribute(name, 1);
            }
        } else {
            this.invokingJspCtxt.setAttribute(name, value, scope);
        }
    }

    @Override
    public Object findAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        Object o = this.pageAttributes.get(name);
        if (o == null && (o = this.invokingJspCtxt.getAttribute(name, 2)) == null) {
            if (this.getSession() != null) {
                o = this.invokingJspCtxt.getAttribute(name, 3);
            }
            if (o == null) {
                o = this.invokingJspCtxt.getAttribute(name, 4);
            }
        }
        return o;
    }

    @Override
    public void removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        this.pageAttributes.remove(name);
        this.invokingJspCtxt.removeAttribute(name, 2);
        if (this.getSession() != null) {
            this.invokingJspCtxt.removeAttribute(name, 3);
        }
        this.invokingJspCtxt.removeAttribute(name, 4);
    }

    @Override
    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            this.pageAttributes.remove(name);
        } else {
            this.invokingJspCtxt.removeAttribute(name, scope);
        }
    }

    @Override
    public int getAttributesScope(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (this.pageAttributes.get(name) != null) {
            return 1;
        }
        return this.invokingJspCtxt.getAttributesScope(name);
    }

    @Override
    public Enumeration<String> getAttributeNamesInScope(int scope) {
        if (scope == 1) {
            return this.pageAttributes.keys();
        }
        return this.invokingJspCtxt.getAttributeNamesInScope(scope);
    }

    @Override
    public void release() {
        this.invokingJspCtxt.release();
    }

    @Override
    public JspWriter getOut() {
        return this.invokingJspCtxt.getOut();
    }

    @Override
    public HttpSession getSession() {
        return this.invokingJspCtxt.getSession();
    }

    @Override
    public Object getPage() {
        return this.invokingJspCtxt.getPage();
    }

    @Override
    public ServletRequest getRequest() {
        return this.invokingJspCtxt.getRequest();
    }

    @Override
    public ServletResponse getResponse() {
        return this.invokingJspCtxt.getResponse();
    }

    @Override
    public Exception getException() {
        return this.invokingJspCtxt.getException();
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.invokingJspCtxt.getServletConfig();
    }

    @Override
    public ServletContext getServletContext() {
        return this.invokingJspCtxt.getServletContext();
    }

    public static PageContext getRootPageContext(PageContext pc) {
        while (pc instanceof JspContextWrapper) {
            pc = ((JspContextWrapper)pc).invokingJspCtxt;
        }
        return pc;
    }

    @Override
    public ELContext getELContext() {
        if (this.elContext == null) {
            PageContext pc = this.invokingJspCtxt;
            while (pc instanceof JspContextWrapper) {
                pc = ((JspContextWrapper)pc).invokingJspCtxt;
            }
            PageContextImpl pci = (PageContextImpl)pc;
            this.elContext = pci.getJspApplicationContext().createELContext(this.invokingJspCtxt.getELContext().getELResolver());
            this.elContext.putContext(JspContext.class, this);
            ((ELContextImpl)this.elContext).setVariableMapper(new VariableMapperImpl());
        }
        return this.elContext;
    }

    @Override
    public void forward(String relativeUrlPath) throws ServletException, IOException {
        this.invokingJspCtxt.forward(relativeUrlPath);
    }

    @Override
    public void include(String relativeUrlPath) throws ServletException, IOException {
        this.invokingJspCtxt.include(relativeUrlPath);
    }

    @Override
    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        this.invokingJspCtxt.include(relativeUrlPath, flush);
    }

    @Override
    public VariableResolver getVariableResolver() {
        return null;
    }

    @Override
    public BodyContent pushBody() {
        return this.invokingJspCtxt.pushBody();
    }

    @Override
    public JspWriter pushBody(Writer writer) {
        return this.invokingJspCtxt.pushBody(writer);
    }

    @Override
    public JspWriter popBody() {
        return this.invokingJspCtxt.popBody();
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator() {
        return this.invokingJspCtxt.getExpressionEvaluator();
    }

    @Override
    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    @Override
    public void handlePageException(Throwable t) throws IOException, ServletException {
        this.invokingJspCtxt.handlePageException(t);
    }

    public void syncBeginTagFile() {
        this.saveNestedVariables();
    }

    public void syncBeforeInvoke() {
        this.copyTagToPageScope(0);
        this.copyTagToPageScope(1);
    }

    public void syncEndTagFile() {
        this.copyTagToPageScope(1);
        this.copyTagToPageScope(2);
        this.restoreNestedVariables();
    }

    private void copyTagToPageScope(int scope) {
        Iterator iter = null;
        switch (scope) {
            case 0: {
                if (this.nestedVars == null) break;
                iter = this.nestedVars.iterator();
                break;
            }
            case 1: {
                if (this.atBeginVars == null) break;
                iter = this.atBeginVars.iterator();
                break;
            }
            case 2: {
                if (this.atEndVars == null) break;
                iter = this.atEndVars.iterator();
            }
        }
        while (iter != null && iter.hasNext()) {
            String varName = (String)iter.next();
            Object obj = this.getAttribute(varName);
            varName = this.findAlias(varName);
            if (obj != null) {
                this.invokingJspCtxt.setAttribute(varName, obj);
                continue;
            }
            this.invokingJspCtxt.removeAttribute(varName, 1);
        }
    }

    private void saveNestedVariables() {
        if (this.nestedVars != null) {
            for (String varName : this.nestedVars) {
                Object obj = this.invokingJspCtxt.getAttribute(varName = this.findAlias(varName));
                if (obj == null) continue;
                this.originalNestedVars.put(varName, obj);
            }
        }
    }

    private void restoreNestedVariables() {
        if (this.nestedVars != null) {
            for (String varName : this.nestedVars) {
                Object obj = this.originalNestedVars.get(varName = this.findAlias(varName));
                if (obj != null) {
                    this.invokingJspCtxt.setAttribute(varName, obj);
                    continue;
                }
                this.invokingJspCtxt.removeAttribute(varName, 1);
            }
        }
    }

    private String findAlias(String varName) {
        if (this.aliases == null) {
            return varName;
        }
        String alias = (String)this.aliases.get(varName);
        if (alias == null) {
            return varName;
        }
        return alias;
    }
}

