package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class GroupFormsHelper {

    /**
     * GroupFormsHelper :
     * utility class all provided methods are accessible the static way
     */

    private GroupFormsHelper() {// empty
}

    /**
     * getGroup :
     * @param wikitty 
     * @return String 
     */

    public static String getGroup(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_GROUP);
        return value;
}

    /**
     * setGroup :
     * @param wikitty 
     * @param group 
     * @return String 
     */

    public static String setGroup(Wikitty wikitty, String group) {
        String oldValue = getGroup(wikitty);
        wikitty.setField(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_GROUP, group);
        return oldValue;
}

    /**
     * getForm :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getForm(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_FORM, String.class);
        return result;
}

    /**
     * setForm :
     * @param wikitty 
     * @param form 
     */

    public static void setForm(Wikitty wikitty, Set<String> form) {
        wikitty.setField(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_FORM, form);
}

    /**
     * addAllForm :
     * @param wikitty 
     * @param form 
     */

    public static void addAllForm(Wikitty wikitty, Set<String> form) {
        if(form != null){
            for (String id:form){
                addForm(wikitty, id);
            }
        }
}

    /**
     * addForm :
     * @param wikitty 
     * @param element 
     */

    public static void addForm(Wikitty wikitty, String element) {
        wikitty.addToField(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_FORM, element);
}

    /**
     * removeForm :
     * @param wikitty 
     * @param element 
     */

    public static void removeForm(Wikitty wikitty, String element) {
        wikitty.removeFromField(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_FORM, element);
}

    /**
     * clearForm :
     * @param wikitty 
     */

    public static void clearForm(Wikitty wikitty) {
        wikitty.clearField(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_FORM);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_GROUP);
            Object f2 = w2.getFieldAsObject(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_GROUP);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_FORM);
            Object f2 = w2.getFieldAsObject(GroupForms.EXT_GROUPFORMS, GroupForms.FIELD_GROUPFORMS_FORM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(GroupForms.EXT_GROUPFORMS);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : GroupFormsAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //GroupFormsHelper
