/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.votecounting.api.model.ListOfVoter;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;

public class ListVoteCountingResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ListOfVoter voter;
    protected Map<String, ListOfVoter> lists;

    public static ListVoteCountingResult newResult(ListOfVoter voter, Set<ListOfVoter> lists) {
        ListVoteCountingResult result = new ListVoteCountingResult();
        result.setVoter(voter);
        lists.remove(voter);
        result.setLists(lists);
        return result;
    }

    public VoteCountingResult getMainResult() {
        return this.voter.getResult();
    }

    public Set<String> getGroupIds() {
        return Sets.newHashSet(this.lists.keySet());
    }

    public VoteCountingResult getListResult(String listId) {
        ListOfVoter groupOfVoter = this.lists.get(listId);
        return groupOfVoter.getResult();
    }

    public void setVoter(ListOfVoter voter) {
        this.voter = voter;
    }

    public void setLists(Set<ListOfVoter> lists) {
        this.lists = Maps.uniqueIndex(lists, ListOfVoter::getVoterId);
    }
}

