/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.services;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.votecounting.business.Choice;
import org.chorem.pollen.votecounting.business.CondorcetMethod;
import org.chorem.pollen.votecounting.business.Context;
import org.chorem.pollen.votecounting.business.Group;
import org.chorem.pollen.votecounting.business.Method;
import org.chorem.pollen.votecounting.business.NumberMethod;
import org.chorem.pollen.votecounting.business.PercentageMethod;
import org.chorem.pollen.votecounting.business.StandardMethod;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;
import org.chorem.pollen.votecounting.utils.Utils;

public class VoteCountingService {
    private static final Log log = LogFactory.getLog(VoteCountingService.class);

    public VoteCountingResultDTO execute(PollDTO poll) {
        boolean byGroup = poll.getPollType() == PollType.GROUP;
        VoteCountingResultDTO result = this.execute(poll, byGroup);
        return result;
    }

    public VoteCountingResultDTO executeVoteCounting(PollDTO poll) {
        return this.execute(poll, false);
    }

    public VoteCountingResultDTO executeGroupCounting(PollDTO poll) {
        return this.execute(poll, true);
    }

    private VoteCountingResultDTO execute(PollDTO poll, boolean isByGroup) {
        Context context;
        if (log.isInfoEnabled()) {
            log.info((Object)("D\u00e9pouillement (byGroup=" + isByGroup + ") du sondage " + poll.getPollId()));
        }
        if (!(context = this.createContext(poll, isByGroup)).executeCounting()) {
            return null;
        }
        List<ChoiceDTO> resChoices = context.executeStats();
        VoteCountingResultDTO result = new VoteCountingResultDTO();
        result.setNbVotes(Utils.calculateNbVotes(poll.getVotingGroups(), isByGroup));
        result.setTypeVoteCounting(poll.getVoteCounting());
        result.setByGroup(isByGroup);
        result.setIdPoll(poll.getPollId());
        result.setChoices(resChoices);
        return result;
    }

    private Context createContext(PollDTO poll, boolean isByGroup) {
        Method method;
        switch (poll.getVoteCounting()) {
            case 0: {
                method = new StandardMethod();
                break;
            }
            case 1: {
                method = new PercentageMethod();
                break;
            }
            case 2: {
                method = new CondorcetMethod();
                break;
            }
            case 3: {
                method = new NumberMethod();
                break;
            }
            default: {
                method = new StandardMethod();
            }
        }
        Context result = new Context(method, isByGroup);
        for (PollChoiceDTO choice : poll.getChoices()) {
            if (choice.isHidden()) {
                result.addHiddenChoice(choice);
                continue;
            }
            result.addChoice(choice);
        }
        for (VotingGroupDTO votingGroup : poll.getVotingGroups()) {
            result.addGroup(votingGroup.getIdGroup(), votingGroup.getWeight());
            for (VotingPersonDTO person : votingGroup.getVotingPersons()) {
                String currentIdGroup = votingGroup.getIdGroup();
                for (VoteToChoiceDTO vote : person.getChoices()) {
                    Choice choice = result.getChoice(vote.getIdChoice());
                    Group group = choice.getGroup(currentIdGroup);
                    group.addVote(vote.getValue(), person.getWeight(), person.getVotingId());
                }
            }
        }
        return result;
    }
}

