/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.services;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.CommentDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.PollExportDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ImportExportService {
    public static final String POLL = "poll";
    public static final String TITLE1 = "title";
    public static final String TITLE = "title";
    public static final String CHOICE = "choice";
    public static final String ID_CHOICE = "idChoice";
    public static final String VALUE = "value";
    public static final String PERCENTAGE = "percentage";
    public static final String NB_VOTES = "nbVotes";
    public static final String IS_BY_GROUP = "isByGroup";
    public static final String CHOICES = "choices";
    public static final String CHOICE_RESULT = "choiceResult";
    public static final String ID_POLL = "idPoll";
    public static final String VOTE_COUNTING_RESULT = "voteCountingResult";
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";
    public static final String POLL_CHOICE = "pollChoice";
    public static final String VOTING_PERSON = "votingPerson";
    public static final String VOTING_ID = "votingId";
    public static final String WEIGHT = "weight";
    public static final String EMAIL = "email";
    public static final String COMMENT = "comment";
    public static final String VOTING_PERSONS = "votingPersons";
    public static final String ID_GROUP = "idGroup";
    public static final String GROUP = "group";
    public static final String POLL_CHOICES = "pollChoices";
    public static final String VOTE_COUNTING_RESULTS = "voteCountingResults";
    public static final String GROUPS = "groups";
    public static final String COMMENTS = "comments";
    public static final String CREATOR_ID = "creatorId";
    public static final String CREATOR_EMAIL = "creatorEmail";
    public static final String MAX_CHOICE_NB = "maxChoiceNb";
    public static final String POLL_EXPORT = "pollExport";
    public static final String POLL_ID = "pollId";
    public static final String POLL_TYPE = "pollType";
    public static final String CHOICE_TYPE = "choiceType";
    public static final String VOTE_COUNTING = "voteCounting";
    public static final String CLOSED = "closed";
    public static final String CHOICE_ADD_ALLOWED = "choiceAddAllowed";
    public static final String ANONYMOUS_VOTE_ALLOWED = "anonymousVoteAllowed";
    public static final String ANONYMOUS = "anonymous";
    public static final String PUBLIC_RESULTS = "publicResults";
    public static final String CONTINUOUS_RESULTS = "continuousResults";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    private static final Log log = LogFactory.getLog(ImportExportService.class);

    public String exportToXml(PollExportDTO exportPoll) {
        Document document = this.toDOM(exportPoll);
        XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
        String content = sortie.outputString(document);
        if (log.isDebugEnabled()) {
            log.debug((Object)content);
        }
        return content;
    }

    public PollExportDTO importFromXml(File file) throws JDOMException, IOException {
        Document document = new SAXBuilder().build(file);
        Element racine = document.getRootElement();
        PollExportDTO result = this.toDTO(racine);
        return result;
    }

    protected PollExportDTO toDTO(Element racine) {
        Element pollElm = racine.getChild(POLL);
        PollDTO poll = new PollDTO(pollElm.getAttributeValue(POLL_ID));
        poll.setTitle(pollElm.getChild("title").getText());
        poll.setDescription(pollElm.getChild(DESCRIPTION).getText());
        poll.setCreatorId(pollElm.getChild(CREATOR_ID).getText());
        poll.setCreatorEmail(pollElm.getChild(CREATOR_EMAIL).getText());
        poll.setMaxChoiceNb(Integer.parseInt(pollElm.getChild(MAX_CHOICE_NB).getText()));
        poll.setPollType(PollType.valueOf(pollElm.getAttributeValue(POLL_TYPE)));
        poll.setChoiceType(ChoiceType.valueOf(pollElm.getAttributeValue(CHOICE_TYPE)));
        poll.setVoteCounting(Integer.valueOf(pollElm.getAttributeValue(VOTE_COUNTING)));
        poll.setClosed(Boolean.valueOf(pollElm.getAttributeValue(CLOSED)));
        poll.setChoiceAddAllowed(Boolean.valueOf(pollElm.getAttributeValue(CHOICE_ADD_ALLOWED)));
        poll.setAnonymousVoteAllowed(Boolean.valueOf(pollElm.getAttributeValue(ANONYMOUS_VOTE_ALLOWED)));
        poll.setAnonymous(Boolean.valueOf(pollElm.getAttributeValue(ANONYMOUS)));
        poll.setPublicResults(Boolean.valueOf(pollElm.getAttributeValue(PUBLIC_RESULTS)));
        poll.setContinuousResults(Boolean.valueOf(pollElm.getAttributeValue(CONTINUOUS_RESULTS)));
        Element commentsElm = pollElm.getChild(COMMENTS);
        List listComments = commentsElm.getChildren(COMMENT);
        List<CommentDTO> vectorComments = this.toComments(listComments);
        poll.setComments(vectorComments);
        Element groupsElm = pollElm.getChild(GROUPS);
        List listGroups = groupsElm.getChildren(GROUP);
        List<VotingGroupDTO> vectorGroups = this.toVotingGroups(listGroups);
        poll.setVotingGroups(vectorGroups);
        Element pollChoicesElm = pollElm.getChild(POLL_CHOICES);
        List listPollChoices = pollChoicesElm.getChildren(POLL_CHOICE);
        List<PollChoiceDTO> vectorPollChoices = this.toPollChoices(listPollChoices);
        poll.setChoices(vectorPollChoices);
        Element voteCountingResultsElm = racine.getChild(VOTE_COUNTING_RESULTS);
        List listVoteCountingResults = voteCountingResultsElm.getChildren(VOTE_COUNTING_RESULT);
        List<VoteCountingResultDTO> vectorVoteCountingResults = this.toVoteCountingResults(listVoteCountingResults);
        PollExportDTO pollExport = new PollExportDTO();
        pollExport.setPollId(poll.getPollId());
        pollExport.setPoll(poll);
        pollExport.setVoteCountingResults(vectorVoteCountingResults);
        return pollExport;
    }

    protected List<CommentDTO> toComments(List<Element> listComments) {
        ArrayList vectorComments = Lists.newArrayList();
        for (Element commentElm : listComments) {
            CommentDTO comment = new CommentDTO(commentElm.getAttributeValue(VOTING_ID), commentElm.getText());
            vectorComments.add(comment);
        }
        return vectorComments;
    }

    protected List<VotingGroupDTO> toVotingGroups(List<Element> listGroups) {
        ArrayList vectorGroups = Lists.newArrayList();
        for (Element groupElm : listGroups) {
            VotingGroupDTO group = new VotingGroupDTO(groupElm.getAttributeValue(ID_GROUP), Double.parseDouble(groupElm.getAttributeValue(WEIGHT)));
            group.setName(groupElm.getAttributeValue(NAME));
            Element votingPersonsElm = groupElm.getChild(VOTING_PERSONS);
            List listVotingPersons = votingPersonsElm.getChildren(VOTING_PERSON);
            List<VotingPersonDTO> vectorVotingPersons = this.toVotingPersons(listVotingPersons);
            group.setVotingPersons(vectorVotingPersons);
            vectorGroups.add(group);
        }
        return vectorGroups;
    }

    protected List<VotingPersonDTO> toVotingPersons(List<Element> listVotingPersons) {
        ArrayList vectorVotingPersons = Lists.newArrayList();
        for (Element votingPersonElm : listVotingPersons) {
            VotingPersonDTO votingPerson = new VotingPersonDTO(votingPersonElm.getAttributeValue(VOTING_ID), Double.parseDouble(votingPersonElm.getAttributeValue(WEIGHT)));
            votingPerson.setEmail(votingPersonElm.getChild(EMAIL).getValue());
            votingPerson.setComment(votingPersonElm.getChild(COMMENT).getValue());
            Element choicesElm = votingPersonElm.getChild(CHOICES);
            List listVoteToChoices = choicesElm.getChildren(CHOICE);
            List<VoteToChoiceDTO> vectorVoteToChoices = this.toVoteToChoices(listVoteToChoices);
            votingPerson.setChoices(vectorVoteToChoices);
            vectorVotingPersons.add(votingPerson);
        }
        return vectorVotingPersons;
    }

    protected List<VoteToChoiceDTO> toVoteToChoices(List<Element> listVoteToChoices) {
        ArrayList vectorVoteToChoices = Lists.newArrayList();
        for (Element voteToChoiceElm : listVoteToChoices) {
            VoteToChoiceDTO voteToChoice = new VoteToChoiceDTO(voteToChoiceElm.getAttributeValue(ID_CHOICE), Double.parseDouble(voteToChoiceElm.getAttributeValue(VALUE)));
            vectorVoteToChoices.add(voteToChoice);
        }
        return vectorVoteToChoices;
    }

    protected List<PollChoiceDTO> toPollChoices(List<Element> listPollChoices) {
        ArrayList vectorPollChoices = Lists.newArrayList();
        for (Element pollChoiceElm : listPollChoices) {
            PollChoiceDTO pollChoice = new PollChoiceDTO(pollChoiceElm.getAttributeValue(ID_CHOICE));
            String pollChoiceName = pollChoiceElm.getChild(NAME).getValue();
            pollChoice.setName(pollChoiceName);
            pollChoice.setHidden(pollChoiceName != null && pollChoiceName.startsWith("HIDDEN_"));
            pollChoice.setDescription(pollChoiceElm.getChild(DESCRIPTION).getValue());
            vectorPollChoices.add(pollChoice);
        }
        return vectorPollChoices;
    }

    protected List<VoteCountingResultDTO> toVoteCountingResults(List<Element> listVoteCountingResults) {
        ArrayList vectorVoteCountingResults = Lists.newArrayList();
        for (Element voteCountingResultElm : listVoteCountingResults) {
            VoteCountingResultDTO voteCountingResult = new VoteCountingResultDTO();
            voteCountingResult.setIdPoll(voteCountingResultElm.getAttributeValue(ID_POLL));
            voteCountingResult.setNbVotes(Integer.parseInt(voteCountingResultElm.getChild(NB_VOTES).getValue()));
            voteCountingResult.setChoiceResult(voteCountingResultElm.getChild(CHOICE_RESULT).getValue());
            voteCountingResult.setByGroup(Boolean.parseBoolean(voteCountingResultElm.getChild(IS_BY_GROUP).getValue()));
            Element choicesElm = voteCountingResultElm.getChild(CHOICES);
            List listChoices = choicesElm.getChildren(CHOICE);
            List<ChoiceDTO> vectorChoices = this.toChoices(listChoices);
            voteCountingResult.setChoices(vectorChoices);
            vectorVoteCountingResults.add(voteCountingResult);
        }
        return vectorVoteCountingResults;
    }

    protected List<ChoiceDTO> toChoices(List<Element> listChoices) {
        ArrayList vectorChoices = Lists.newArrayList();
        for (Element choiceElm : listChoices) {
            ChoiceDTO choice = new ChoiceDTO(choiceElm.getAttribute(ID_CHOICE).getName(), Double.parseDouble(choiceElm.getAttribute(VALUE).getValue()), Double.parseDouble(choiceElm.getChild(PERCENTAGE).getValue()), Integer.parseInt(choiceElm.getChild(NB_VOTES).getValue()));
            vectorChoices.add(choice);
        }
        return vectorChoices;
    }

    protected Document toDOM(PollExportDTO exportPoll) {
        PollDTO poll = exportPoll.getPoll();
        List<VoteCountingResultDTO> voteCountingResults = exportPoll.getVoteCountingResults();
        Element racine = new Element(POLL_EXPORT);
        Document document = new Document(racine);
        Element pollElm = new Element(POLL);
        pollElm.setAttribute(POLL_ID, poll.getPollId());
        pollElm.setAttribute(POLL_TYPE, poll.getPollType().name());
        pollElm.setAttribute(CHOICE_TYPE, poll.getChoiceType().name());
        pollElm.setAttribute(VOTE_COUNTING, String.valueOf(poll.getVoteCounting()));
        pollElm.setAttribute(CLOSED, poll.isClosed() ? VALUE_TRUE : VALUE_FALSE);
        pollElm.setAttribute(CHOICE_ADD_ALLOWED, poll.isChoiceAddAllowed() ? VALUE_TRUE : VALUE_FALSE);
        pollElm.setAttribute(ANONYMOUS_VOTE_ALLOWED, poll.isAnonymousVoteAllowed() ? VALUE_TRUE : VALUE_FALSE);
        pollElm.setAttribute(ANONYMOUS, poll.isAnonymous() ? VALUE_TRUE : VALUE_FALSE);
        pollElm.setAttribute(PUBLIC_RESULTS, poll.isPublicResults() ? VALUE_TRUE : VALUE_FALSE);
        pollElm.setAttribute(CONTINUOUS_RESULTS, poll.isContinuousResults() ? VALUE_TRUE : VALUE_FALSE);
        Element titleElm = new Element("title");
        titleElm.setText(poll.getTitle());
        pollElm.addContent((Content)titleElm);
        Element descriptionElm = new Element(DESCRIPTION);
        descriptionElm.setText(poll.getDescription());
        pollElm.addContent((Content)descriptionElm);
        Element creatorIdElm = new Element(CREATOR_ID);
        creatorIdElm.setText(poll.getCreatorId());
        pollElm.addContent((Content)creatorIdElm);
        Element creatorEmailElm = new Element(CREATOR_EMAIL);
        creatorEmailElm.setText(poll.getCreatorEmail());
        pollElm.addContent((Content)creatorEmailElm);
        Element maxChoiceNbElm = new Element(MAX_CHOICE_NB);
        maxChoiceNbElm.setText(Integer.toString(poll.getMaxChoiceNb()));
        pollElm.addContent((Content)maxChoiceNbElm);
        Element commentsElm = new Element(COMMENTS);
        for (CommentDTO commentDTO : poll.getComments()) {
            Element commentElm = this.toDOM(commentDTO);
            commentsElm.addContent((Content)commentElm);
        }
        pollElm.addContent((Content)commentsElm);
        Element groupsElm = new Element(GROUPS);
        for (VotingGroupDTO votingGroupDTO : poll.getVotingGroups()) {
            Element groupElm = this.toDOM(votingGroupDTO);
            groupsElm.addContent((Content)groupElm);
        }
        pollElm.addContent((Content)groupsElm);
        Element pollChoicesElm = new Element(POLL_CHOICES);
        for (PollChoiceDTO pollChoiceDTO : poll.getChoices()) {
            Element pollChoiceElm = this.toDOM(pollChoiceDTO);
            pollChoicesElm.addContent((Content)pollChoiceElm);
        }
        pollElm.addContent((Content)pollChoicesElm);
        Element voteCountingResultsElm = new Element(VOTE_COUNTING_RESULTS);
        for (VoteCountingResultDTO voteCountingResult1 : voteCountingResults) {
            Element voteCountingResult = this.toDOM(voteCountingResult1);
            voteCountingResultsElm.addContent((Content)voteCountingResult);
        }
        racine.addContent((Content)pollElm);
        racine.addContent((Content)voteCountingResultsElm);
        return document;
    }

    protected Element toDOM(CommentDTO comment) {
        Element commentElm = new Element(COMMENT);
        commentElm.setAttribute(VOTING_ID, comment.getVotingID());
        commentElm.setText(comment.getText());
        return commentElm;
    }

    protected Element toDOM(VotingGroupDTO group) {
        Element groupElm = new Element(GROUP);
        groupElm.setAttribute(ID_GROUP, group.getIdGroup());
        groupElm.setAttribute(NAME, group.getName());
        groupElm.setAttribute(WEIGHT, Double.toString(group.getWeight()));
        Element votingPersonsElm = new Element(VOTING_PERSONS);
        for (VotingPersonDTO votingPersonDTO : group.getVotingPersons()) {
            Element votingPersonElm = this.toDOM(votingPersonDTO);
            votingPersonsElm.addContent((Content)votingPersonElm);
        }
        groupElm.addContent((Content)votingPersonsElm);
        return groupElm;
    }

    protected Element toDOM(VotingPersonDTO votingPerson) {
        Element votingPersonElm = new Element(VOTING_PERSON);
        votingPersonElm.setAttribute(VOTING_ID, votingPerson.getVotingId());
        votingPersonElm.setAttribute(WEIGHT, Double.toString(votingPerson.getWeight()));
        Element emailElm = new Element(EMAIL);
        emailElm.setText(votingPerson.getEmail());
        votingPersonElm.addContent((Content)emailElm);
        Element commentElm = new Element(COMMENT);
        commentElm.setText(votingPerson.getComment());
        votingPersonElm.addContent((Content)commentElm);
        Element choicesElm = new Element(CHOICES);
        for (VoteToChoiceDTO voteToChoice : votingPerson.getChoices()) {
            Element choiceElm = new Element(CHOICE);
            choiceElm.setAttribute(ID_CHOICE, voteToChoice.getIdChoice());
            choiceElm.setAttribute(VALUE, Double.toString(voteToChoice.getValue()));
            choicesElm.addContent((Content)choiceElm);
        }
        votingPersonElm.addContent((Content)choicesElm);
        return votingPersonElm;
    }

    protected Element toDOM(PollChoiceDTO pollChoice) {
        Element pollChoiceElm = new Element(POLL_CHOICE);
        pollChoiceElm.setAttribute(ID_CHOICE, pollChoice.getIdChoice());
        Element nameElm = new Element(NAME);
        nameElm.setText(pollChoice.getName());
        pollChoiceElm.addContent((Content)nameElm);
        Element descriptionElm = new Element(DESCRIPTION);
        descriptionElm.setText(pollChoice.getDescription());
        pollChoiceElm.addContent((Content)descriptionElm);
        return pollChoiceElm;
    }

    protected Element toDOM(VoteCountingResultDTO voteCountingResults) {
        Element voteCountingResultElm = new Element(VOTE_COUNTING_RESULT);
        voteCountingResultElm.setAttribute(ID_POLL, voteCountingResults.getIdPoll());
        Element nbVotesElm = new Element(NB_VOTES);
        nbVotesElm.setText(Integer.toString(voteCountingResults.getNbVotes()));
        voteCountingResultElm.addContent((Content)nbVotesElm);
        Element choiceResultElm = new Element(CHOICE_RESULT);
        choiceResultElm.setText(voteCountingResults.getChoiceResult());
        voteCountingResultElm.addContent((Content)choiceResultElm);
        Element isByGroupElm = new Element(IS_BY_GROUP);
        isByGroupElm.setText(Boolean.toString(voteCountingResults.isByGroup()));
        voteCountingResultElm.addContent((Content)isByGroupElm);
        Element choicesElm = new Element(CHOICES);
        for (ChoiceDTO choiceDTO : voteCountingResults.getChoices()) {
            Element choiceElm = this.toDOM(choiceDTO);
            choicesElm.addContent((Content)choiceElm);
        }
        voteCountingResultElm.addContent((Content)choicesElm);
        return voteCountingResultElm;
    }

    protected Element toDOM(ChoiceDTO choice) {
        Element choiceElm = new Element(CHOICE);
        choiceElm.setAttribute(ID_CHOICE, choice.getIdChoice());
        choiceElm.setAttribute(VALUE, Double.toString(choice.getValue()));
        Element percentageElm = new Element(PERCENTAGE);
        percentageElm.setText(Double.toString(choice.getPercentage()));
        choiceElm.addContent((Content)percentageElm);
        Element nbVotesElm = new Element(NB_VOTES);
        nbVotesElm.setText(Integer.toString(choice.getNbVotes()));
        choiceElm.addContent((Content)nbVotesElm);
        return choiceElm;
    }
}

