/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.business;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.business.Choice;
import org.chorem.pollen.votecounting.business.Method;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.utils.Utils;

public class Context {
    private static final Log log = LogFactory.getLog(Context.class);
    private boolean groupCounting;
    private List<Choice> choices;
    private List<Choice> hiddenChoices;
    private List<Choice> results;
    private Method method;

    public Context(Method method, boolean groupCounting) {
        this.groupCounting = groupCounting;
        this.choices = new ArrayList<Choice>();
        this.hiddenChoices = new ArrayList<Choice>();
        this.results = new ArrayList<Choice>();
        this.method = method;
    }

    public Choice getChoice(String idChoice) {
        for (Choice choice : this.choices) {
            if (!choice.getIdChoice().equals(idChoice)) continue;
            return choice;
        }
        for (Choice choice : this.hiddenChoices) {
            if (!choice.getIdChoice().equals(idChoice)) continue;
            return choice;
        }
        return null;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public List<Choice> getHiddenChoices() {
        return this.hiddenChoices;
    }

    public List<Choice> getResults() {
        return this.results;
    }

    public void addChoice(PollChoiceDTO choice) {
        this.choices.add(new Choice(choice.getIdChoice(), choice.getName()));
    }

    public void addHiddenChoice(PollChoiceDTO choice) {
        this.hiddenChoices.add(new Choice(choice.getIdChoice(), choice.getName()));
    }

    public void addGroup(String idGroup, double weight) {
        for (Choice choice : this.choices) {
            choice.addGroup(idGroup, weight);
        }
        for (Choice choice : this.hiddenChoices) {
            choice.addGroup(idGroup, weight);
        }
    }

    private boolean isChoiceResult(Choice choice) {
        for (Choice res : this.results) {
            if (!choice.getIdChoice().equals(res.getIdChoice())) continue;
            return true;
        }
        return false;
    }

    public boolean executeCounting() {
        this.method.executeCounting(this.choices, this.groupCounting);
        this.method.executeCounting(this.hiddenChoices, this.groupCounting);
        this.results.clear();
        Choice result = new Choice("");
        for (Choice curr : this.choices) {
            if (curr.value() > result.value()) {
                result = curr;
                this.results.clear();
                continue;
            }
            if (curr.value() != result.value()) continue;
            this.results.add(curr);
        }
        this.results.add(result);
        return true;
    }

    public List<ChoiceDTO> executeStats() {
        ArrayList<ChoiceDTO> resChoices = new ArrayList<ChoiceDTO>();
        try {
            ChoiceDTO choiceDTO;
            for (Choice choice : this.choices) {
                choiceDTO = new ChoiceDTO();
                choiceDTO.setIdChoice(choice.getIdChoice());
                choiceDTO.setName(choice.getName());
                choiceDTO.setValue(choice.getValue());
                choiceDTO.setResult(this.isChoiceResult(choice));
                choiceDTO.setNbVotes(Utils.calculateNbVotes(choice.getGroups(), this.groupCounting));
                this.method.executeStats(this.choices, this.groupCounting, choice, choiceDTO);
                resChoices.add(choiceDTO);
            }
            for (Choice choice : this.hiddenChoices) {
                choiceDTO = new ChoiceDTO();
                choiceDTO.setIdChoice(choice.getIdChoice());
                choiceDTO.setName(choice.getName());
                choiceDTO.setValue(choice.getValue());
                resChoices.add(choiceDTO);
            }
        }
        catch (Exception e) {
            log.error((Object)"L'ex\u00e9cution des statistiques a \u00e9chou\u00e9", (Throwable)e);
            resChoices = new ArrayList();
        }
        return resChoices;
    }
}

