package org.chorem.pollen.votecounting.business;

import java.util.List;

import org.chorem.pollen.votecounting.dto.ChoiceDTO;

/**
 * Méthode de dépouillement pour vote de type number.
 * 
 * @version $Revision: 2838 $ $Date: 2010-01-12 10:23:10 +0100 (mar, 12 jan 2010) $
 * @since 1.2.2
 */
public class NumberMethod implements Method {
    
    @Override
    public void executeCounting(List<Choice> choices, boolean byGroup) {
    
        for (Choice choice : choices) {
            double totalChoice = 0.;
            
            for (Group group : choice.getGroups()) {
                double totalGroup = 0.;
                
                for (Vote vote : group.getVotes()) {
                    double value = vote.getValue();
                    
                    if (value >= 0) {
                        if (byGroup) {
                            totalGroup += vote.getValue() * vote.getWeight() * group.getWeight();
                        } else {
                            totalGroup += vote.getValue() * vote.getWeight();
                        }
                    }
                }
                
                group.setValue(totalGroup);
                totalChoice += totalGroup;
            }
            
            choice.setValue(totalChoice);
        }
    }
    
    @Override
    public void executeStats(List<Choice> choices, boolean groupCounting,
            Choice choice, ChoiceDTO choiceDTO) {

        int nbBlankVotes = 0;
        double average = 0;
        int nbVotes = 0;
        
        for (Group group : choice.getGroups()) {
            for (Vote vote : group.getVotes()) {
                nbVotes = nbVotes + 1;
                if (vote.getValue() < 0) {
                    nbBlankVotes = nbBlankVotes + 1;
                }
            }
        }
    
        if (nbVotes - nbBlankVotes > 0) {
            average = choice.value() / (nbVotes - nbBlankVotes);
        }
        
        choiceDTO.setAverage(average);
        choiceDTO.setNbBlankVotes(nbBlankVotes);
    }
}
