/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.business;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.votecounting.business.Choice;
import org.chorem.pollen.votecounting.business.CondorcetMethod;
import org.chorem.pollen.votecounting.business.Context;
import org.chorem.pollen.votecounting.business.Method;
import org.chorem.pollen.votecounting.business.PercentageMethod;
import org.chorem.pollen.votecounting.business.StandardMethod;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;
import org.chorem.pollen.votecounting.services.ServiceVoteCounting;
import org.chorem.pollen.votecounting.utils.PercentageBehavior;
import org.chorem.pollen.votecounting.utils.Utils;

public class VoteCounting
implements ServiceVoteCounting {
    private String currentIdGroup = "";
    private boolean isByGroup;
    private Context context = null;
    private static final Log log = LogFactory.getLog(VoteCounting.class);

    @Override
    public VoteCountingResultDTO executeVoteCounting(PollDTO poll) {
        this.isByGroup = false;
        return this.execute(poll);
    }

    @Override
    public VoteCountingResultDTO executeGroupCounting(PollDTO poll) {
        this.isByGroup = true;
        return this.execute(poll);
    }

    private VoteCountingResultDTO execute(PollDTO poll) {
        this.createContext(poll.getTypeVoteCounting());
        this.fillContext(poll);
        if (!this.context.execute()) {
            return null;
        }
        ArrayList<ChoiceDTO> resChoices = new ArrayList<ChoiceDTO>();
        List<PercentageBehavior> choices = this.context.getChoices();
        for (Choice choice : this.context.getChoices()) {
            ChoiceDTO resChoice = new ChoiceDTO();
            resChoice.setIdChoice(choice.getIdChoice());
            resChoice.setNbVotes(this.calculateNbVotes(choice.getGroups(), this.isByGroup));
            resChoice.setValue(choice.getValue());
            resChoice.setPercentage(Utils.calculatePercentage(choice, choices));
            resChoice.setResult(this.isChoiceResult(choice));
            if (log.isInfoEnabled()) {
                log.info((Object)(choice + " _ result ? " + resChoice.isResult()));
            }
            resChoices.add(resChoice);
        }
        VoteCountingResultDTO result = new VoteCountingResultDTO();
        result.setNbVotes(this.calculateNbVotes(poll.getVotingGroups(), this.isByGroup));
        result.setTypeVoteCounting(poll.getTypeVoteCounting());
        result.setByGroup(this.isByGroup);
        result.setIdPoll(poll.getIdPoll());
        result.setChoices(resChoices);
        return result;
    }

    private void createContext(VoteCountingType type) {
        Method method = null;
        switch (type) {
            case NORMAL: {
                method = new StandardMethod();
                break;
            }
            case PERCENTAGE: {
                method = new PercentageMethod();
                break;
            }
            case CONDORCET: {
                method = new CondorcetMethod();
                break;
            }
            default: {
                method = new StandardMethod();
            }
        }
        this.context = new Context(method, this.isByGroup);
    }

    private void fillContext(PollDTO poll) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Ajout poll : " + poll.getIdPoll()));
        }
        Iterator<Object> i$ = poll.getChoices().iterator();
        while (i$.hasNext()) {
            PollChoiceDTO pollChoiceDTO;
            PollChoiceDTO choice = pollChoiceDTO = i$.next();
            this.context.addChoice(choice.getIdChoice());
        }
        i$ = poll.getVotingGroups().iterator();
        while (i$.hasNext()) {
            VotingGroupDTO votingGroupDTO;
            VotingGroupDTO group = votingGroupDTO = (VotingGroupDTO)i$.next();
            this.routeGroup(group);
        }
    }

    private void routeGroup(VotingGroupDTO group) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Ajout group : " + group.getIdGroup() + " _ weight=" + group.getWeight()));
        }
        this.context.addGroup(group.getIdGroup(), group.getWeight());
        Iterator<VotingPersonDTO> i$ = group.getVotingPersons().iterator();
        while (i$.hasNext()) {
            VotingPersonDTO o;
            VotingPersonDTO person = o = i$.next();
            this.currentIdGroup = group.getIdGroup();
            this.routePerson(person);
        }
    }

    private void routePerson(VotingPersonDTO person) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Ajout person : " + person.getVotingKey() + " _ weight=" + person.getWeight()));
        }
        Iterator<VoteToChoiceDTO> i$ = person.getChoices().iterator();
        while (i$.hasNext()) {
            VoteToChoiceDTO o;
            VoteToChoiceDTO vote = o = i$.next();
            this.addVoteToContext(vote, person.getWeight(), person.getVotingKey());
        }
    }

    private void addVoteToContext(VoteToChoiceDTO vote, double weight, String votingID) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Ajout vote : " + vote.getValue() + " _ choice=" + vote.getIdChoice()));
        }
        this.context.getChoice(vote.getIdChoice()).getGroup(this.currentIdGroup).addVote(vote.getValue(), weight, votingID);
    }

    private int calculateNbVotes(List list, boolean byGroup) {
        return Utils.mayCalculateSubElements(list, byGroup);
    }

    private boolean isChoiceResult(Choice choice) {
        for (Choice res : this.context.getResults()) {
            if (!choice.getIdChoice().equals(res.getIdChoice())) continue;
            return true;
        }
        return false;
    }
}

