/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.strategy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.Voter;
import org.chorem.pollen.votecounting.strategy.AbstractVoteCountingStrategy;
import org.nuiton.i18n.I18n;

public class CoombsStrategy
extends AbstractVoteCountingStrategy {
    public static final int ID = 6;

    public int getId() {
        return 6;
    }

    public String getI18nName() {
        return I18n.n_((String)"pollen.voteCountingType.coombs", (Object[])new Object[0]);
    }

    public String getI18nHelp() {
        return I18n.n_((String)"pollen.voteCountingType.coombs.help", (Object[])new Object[0]);
    }

    public String getTotalVoteValueNotValidMessage(Locale locale) {
        return null;
    }

    public String getVoteValueNotValidMessage(Locale locale) {
        return I18n.l_((Locale)locale, (String)"pollen.error.vote.invalidCoombsVoteValue", (Object[])new Object[0]);
    }

    public String getDisplayVoteValue(Integer voteValue) {
        return voteValue == null ? "" : String.valueOf(voteValue);
    }

    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    public boolean isChoiceInVote(Integer voteValue) {
        return voteValue != null && voteValue > 0 && voteValue < 100;
    }

    public boolean isVoteValueNull(Integer voteValue) {
        return voteValue == null;
    }

    public boolean isDisplayResultsByChoice() {
        return false;
    }

    public boolean isVoteValueValid(Integer voteValue) {
        return voteValue != null && voteValue > 0;
    }

    public boolean isTotalVoteValueValid(int totalValues) {
        return true;
    }

    public VoteCountingResult votecount(Set<Voter> voters) {
        SortedMap resultByChoice = this.votersToResult(voters);
        double totalWeight = 0.0;
        for (Voter voter : voters) {
            totalWeight += voter.getWeight();
        }
        Map topRankChoices = this.buildVoterSortedChoices(voters);
        HashSet choiceIdsToExclude = Sets.newHashSet();
        HashSet choiceIdsToKeep = Sets.newHashSet(resultByChoice.keySet());
        this.round(topRankChoices, choiceIdsToExclude, choiceIdsToKeep, resultByChoice, totalWeight /= 2.0);
        VoteCountingResult result = this.resultToList(resultByChoice);
        return result;
    }

    public void round(Map<Voter, List<Set<String>>> topRankChoices, Set<String> idsToExclude, Set<String> idsToInclude, SortedMap<String, ChoiceScore> resultByChoice, double totalWeight) {
        double max;
        List<ChoiceScore> results = this.applyScores(topRankChoices, idsToExclude, idsToInclude, resultByChoice);
        if (!results.isEmpty() && (max = results.get(results.size() - 1).getScoreValue().doubleValue()) < totalWeight) {
            this.guessChoiceIdsToRemove(idsToInclude, idsToExclude, topRankChoices);
            idsToInclude.removeAll(idsToExclude);
            this.round(topRankChoices, idsToExclude, idsToInclude, resultByChoice, totalWeight);
        }
    }

    public List<ChoiceScore> applyScores(Map<Voter, List<Set<String>>> topRankChoices, Set<String> idsToExclude, Set<String> idsToInclude, SortedMap<String, ChoiceScore> resultByChoice) {
        ChoiceScore choiceScore;
        if (CollectionUtils.isNotEmpty(idsToExclude)) {
            for (List list : topRankChoices.values()) {
                Iterator itr = list.iterator();
                while (itr.hasNext()) {
                    Set choiceIds = (Set)itr.next();
                    choiceIds.removeAll(idsToExclude);
                    if (!choiceIds.isEmpty()) continue;
                    itr.remove();
                }
            }
        }
        for (String string : idsToInclude) {
            ((ChoiceScore)resultByChoice.get(string)).setScoreValue(null);
        }
        for (Map.Entry entry : topRankChoices.entrySet()) {
            List idsByLevel = (List)entry.getValue();
            if (idsByLevel.isEmpty()) continue;
            Set winnerIds = (Set)idsByLevel.get(0);
            Voter voter = (Voter)entry.getKey();
            double voterWeight = voter.getWeight();
            for (String id : winnerIds) {
                if (!idsToInclude.contains(id)) continue;
                ChoiceScore choiceScore2 = (ChoiceScore)resultByChoice.get(id);
                choiceScore2.addScoreValue(voterWeight);
            }
        }
        ArrayList results = Lists.newArrayList();
        for (String id : idsToInclude) {
            results.add(resultByChoice.get(id));
        }
        Collections.sort(results);
        Iterator iterator = results.iterator();
        while (iterator.hasNext() && ((choiceScore = (ChoiceScore)iterator.next()).getScoreValue() == null || ZERO_D.equals(choiceScore.getScoreValue()))) {
            iterator.remove();
        }
        return results;
    }

    public void guessChoiceIdsToRemove(Set<String> idsToInclude, Set<String> idsToExclude, Map<Voter, List<Set<String>>> results) {
        ChoiceScore choiceScore;
        TreeMap badScores = Maps.newTreeMap();
        for (String string : idsToInclude) {
            badScores.put(string, ChoiceScore.newScore((String)string, null));
        }
        for (Map.Entry entry : results.entrySet()) {
            Voter voter = (Voter)entry.getKey();
            List idsChoices = (List)entry.getValue();
            if (idsChoices.isEmpty()) continue;
            Set lastIds = (Set)idsChoices.get(idsChoices.size() - 1);
            double voterWeight = voter.getWeight();
            for (String lastId : lastIds) {
                ((ChoiceScore)badScores.get(lastId)).addScoreValue(voterWeight);
            }
        }
        ArrayList scores = Lists.newArrayList(badScores.values());
        Collections.sort(scores);
        Collections.reverse(scores);
        double d = ((ChoiceScore)scores.get(0)).getScoreValue().doubleValue();
        idsToExclude.clear();
        Iterator i$ = scores.iterator();
        while (i$.hasNext() && d == (choiceScore = (ChoiceScore)i$.next()).getScoreValue().doubleValue()) {
            idsToExclude.add(choiceScore.getChoiceId());
        }
    }
}

