/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.services;

import org.apache.tapestry5.SymbolConstants;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.upload.services.UploadSymbols;
import org.chorem.pollen.business.services.ServiceAuth;
import org.chorem.pollen.business.services.ServiceChoice;
import org.chorem.pollen.business.services.ServiceComment;
import org.chorem.pollen.business.services.ServiceList;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.business.services.ServiceResults;
import org.chorem.pollen.business.services.ServiceUser;
import org.chorem.pollen.business.services.ServiceVote;
import org.slf4j.Logger;

/**
 * This module is automatically included as part of the Tapestry IoC Registry,
 * it's a good place to configure and extend Tapestry, or to place your own
 * service definitions.
 *
 * @version $Id: AppModule.java 2836 2010-01-11 12:46:59Z schorlet $
 */
public class AppModule {

    private static final String CONFIGURATION_FILE = "pollen.properties";

    public static void bind(ServiceBinder binder) {
        // binder.bind(MyServiceInterface.class, MyServiceImpl.class);

        // Make bind() calls on the binder object to define most IoC services.
        // Use service builder methods (example below) when the implementation
        // is provided inline, or requires more initialization than simply
        // invoking the constructor.

        // Pollen-Business services
        binder.bind(ServiceAuth.class);
        binder.bind(ServiceComment.class);
        binder.bind(ServiceList.class);
        binder.bind(ServiceUser.class);
        binder.bind(ServicePoll.class);
        binder.bind(ServicePollAccount.class);
        binder.bind(ServiceResults.class);
        binder.bind(ServiceVote.class);
        binder.bind(ServiceChoice.class);
    }

    public static void contributeApplicationDefaults(
            MappedConfiguration<String, String> configuration) {
        // Contributions to ApplicationDefaults will override any contributions to
        // FactoryDefaults (with the same key). Here we're restricting the supported
        // locales to just "en" (English). As you add localised message catalogs and other assets,
        // you can extend this list of locales (it's a comma separated series of locale names;
        // the first locale name is the default when there's no reasonable match).

        configuration.add(SymbolConstants.SUPPORTED_LOCALES, "fr,en");

        // The factory default is true but during the early stages of an application
        // overriding to false is a good idea. In addition, this is often overridden
        // on the command line as -Dtapestry.production-mode=false
        // The primary difference is how exceptions are reported.
        configuration.add(SymbolConstants.PRODUCTION_MODE, "true");

        // Restricting file size in upload component
        configuration.add(UploadSymbols.FILESIZE_MAX, "1048576");
        configuration.add(UploadSymbols.REQUESTSIZE_MAX, "10485760");
    }

    /*
     * This is a service definition, the service will be named "TimingFilter".
     * The interface, RequestFilter, is used within the RequestHandler service
     * pipeline, which is built from the RequestHandler service configuration.
     * Tapestry IoC is responsible for passing in an appropriate Logger
     * instance. Requests for static resources are handled at a higher level, so
     * this filter will only be invoked for Tapestry related requests.
     *
     * <p>
     * Service builder methods are useful when the implementation is inline as
     * an inner class (as here) or require some other kind of special
     * initialization. In most cases, use the static bind() method instead.
     *
     * <p>
     * If this method was named "build", then the service id would be taken from
     * the service interface and would be "RequestFilter". Since Tapestry
     * already defines a service named "RequestFilter" we use an explicit
     * service id that we can reference inside the contribution method.
     *
    public RequestFilter buildTimingFilter(final Logger log) {
        return new RequestFilter() {
            public boolean service(Request request, Response response,
                    RequestHandler handler) throws IOException {
                long startTime = System.currentTimeMillis();

                try {
                    // The responsibility of a filter is to invoke the corresponding method
                    // in the handler. When you chain multiple filters together, each filter
                    // received a handler that is a bridge to the next filter.

                    return handler.service(request, response);
                } finally {
                    long elapsed = System.currentTimeMillis() - startTime;

                    log.info(String.format("Request time: %d ms", elapsed));
                }
            }
        };
    }*/

    /**
     * This is the Shutdown service definition. This service is used when the
     * server shutdown. It detects the Tapestry registry shutdown.
     */
    @EagerLoad
    public RegistryShutdownListener buildPollenShutdown(
            @InjectService("RegistryShutdownHub") RegistryShutdownHub hub) {
        RegistryShutdownListener listener = new PollenShutdown();
        hub.addRegistryShutdownListener(listener);
        return listener;
    }

    /**
     * This is the Configuration service definition. It manage the file
     * properties.
     */
    public static Configuration buildConfiguration() {
        return new ConfigurationImpl(CONFIGURATION_FILE);
    }

    /**
     * This is the BackgroundWorker service definition. It build the service
     * giving a Messages object for localization in the service.
     */
    @EagerLoad
    public static BackgroundWorker buildBackgroundWorker(
            ComponentSource componentSource, Configuration configuration,
            ServicePoll servicePoll) {
        Messages messages = componentSource.getPage("LocalMessages")
                .getComponentResources().getMessages();
        return new BackgroundWorkerImpl(messages, configuration, servicePoll);
    }

    /**
     * Make configuration from a Properties file available as symbols.
     */
    public PropertiesFileSymbolProvider buildConfigPropertiesFileSymbolProvider(
            Logger logger) {
        return new PropertiesFileSymbolProvider(logger, CONFIGURATION_FILE);
    }

    /**
     * Contribution SymbolSource service so that we can access our configuration
     * symbols from our services, pages and components.
     */
    public static void contributeSymbolSource(
            OrderedConfiguration<SymbolProvider> configuration,
            @InjectService("ConfigPropertiesFileSymbolProvider") SymbolProvider configPropertiesFileSymbolProvider) {
        configuration.add("ConfigPropertiesFile",
                configPropertiesFileSymbolProvider, "after:SystemProperties",
                "before:ApplicationDefaults");
    }

    /*
     * This is a contribution to the RequestHandler service configuration. This
     * is how we extend Tapestry using the timing filter. A common use for this
     * kind of filter is transaction management or security. The @Local
     * annotation selects the desired service by type, but only from the same
     * module. Without @Local, there would be an error due to the other
     * service(s) that implement RequestFilter (defined in other modules).
     *
    public void contributeRequestHandler(
            OrderedConfiguration<RequestFilter> configuration,
            @Local RequestFilter filter) {
        // Each contribution to an ordered configuration has a name, When necessary, you may
        // set constraints to precisely control the invocation order of the contributed filter
        // within the pipeline.

        //configuration.add("Timing", filter);
    }*/
}
