/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll.form;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ParameterAware;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollDateChoice;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceImpl;
import org.chorem.pollen.business.persistence.ChoiceType;
import org.chorem.pollen.business.persistence.I18nAble;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListImpl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountImpl;
import org.chorem.pollen.business.persistence.PollCommentVisibility;
import org.chorem.pollen.business.persistence.PollType;
import org.chorem.pollen.business.persistence.PollVoteVisibility;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListImpl;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.PreventRuleService;
import org.chorem.pollen.ui.actions.FileUploadAware;
import org.chorem.pollen.ui.actions.PollenActionSupportForEdition;
import org.chorem.pollen.ui.actions.poll.form.AbstractPollForm;
import org.chorem.pollen.ui.converters.DateConverter;
import org.chorem.pollen.votecounting.VoteCounting;
import org.chorem.pollen.votecounting.VoteCountingFactory;
import org.nuiton.util.StringUtil;

public abstract class AbstractPollForm
extends PollenActionSupportForEdition
implements Preparable,
ParameterAware,
FileUploadAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractPollForm.class);
    public static final String IMAGECHOICES_THUMB_PREFIX = "imagechoicesThumb_";
    private static final Pattern TEXT_CHOICE_NAME_PATTERN = Pattern.compile("textChoice_(\\d+)\\.name");
    private static final Pattern DATE_CHOICE_NAME_PATTERN = Pattern.compile("dateChoice_(\\d+)\\.name");
    private static final Pattern IMAGE_CHOICE_DESCRIPTION_PATTERN = Pattern.compile("imageChoice_(\\d+)\\.description");
    protected Poll poll;
    private Map<String, String> pollTypes;
    private Map<String, String> voteCountingTypes;
    private Map<String, String> voteCountingTypesHelp;
    private Map<String, String> choiceTypes;
    private Map<String, String> pollVoteVisibilities;
    private List<Choice> textChoices;
    private List<Choice> imageChoices;
    private List<Choice> dateChoices;
    private List<VotingList> restrictedVotingList;
    private List<VotingList> groupVotingList;
    private boolean notification;
    private boolean reminder;
    private boolean limitChoice;
    private Integer maxChoices;
    private Integer reminderHourCountdown;
    private transient Function<PersonToList, PersonToList> persontoListCreator;
    private transient Function<VotingList, VotingList> votingListCreator;
    private transient Function<Choice, Choice> textChoiceCreator;
    private transient Function<Choice, Choice> dateChoiceCreator;
    private transient Function<Choice, Choice> imageChoiceCreator;
    protected boolean informationsError;
    private boolean optionsError;
    private Map<Integer, Choice> choices;
    private Map<Integer, Integer> choicesOrder;
    private Map<Integer, VotingList> votingLists;
    private PollUri pollUri;

    public abstract boolean isClone();

    protected abstract Poll savePoll(Poll var1) throws PollNotFoundException;

    public abstract boolean isEdit();

    public void prepare() throws Exception {
        UserAccount userAccount;
        this.prepareFormPage();
        if (this.isGetMethod()) {
            return;
        }
        String pollUid = this.getNonEmptyParameterValue("poll.pollId");
        String userId = this.getNonEmptyParameterValue("userId");
        if (StringUtils.isBlank((CharSequence)userId) && (userAccount = this.getPollenUserAccount()) != null) {
            userId = userAccount.getTopiaId();
        }
        userAccount = null;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            userAccount = (UserAccount)this.getPollService().getEntityById(UserAccount.class, userId);
        }
        this.poll = this.getPollService().getPollEditable(pollUid, userAccount, false);
        if (!this.isVoteStarted()) {
            String choiceTypeParam = this.getNonEmptyParameterValue("poll.choiceType");
            ChoiceType pollChoiceType = ChoiceType.valueOf((String)choiceTypeParam);
            this.poll.setChoiceType(pollChoiceType);
            this.choicesOrder = Maps.newTreeMap();
            switch (1.$SwitchMap$org$chorem$pollen$business$persistence$ChoiceType[pollChoiceType.ordinal()]) {
                case 1: {
                    this.choices = this.buildTextChoices();
                    break;
                }
                case 2: {
                    this.choices = this.buildDateChoices();
                    break;
                }
                case 3: {
                    this.choices = this.buildImageChoices();
                }
            }
            String pollTypeParam = this.getNonEmptyParameterValue("poll.pollType");
            PollType pollType = PollType.valueOf((String)pollTypeParam);
            switch (1.$SwitchMap$org$chorem$pollen$business$persistence$PollType[pollType.ordinal()]) {
                case 1: {
                    this.votingLists = Maps.newTreeMap();
                    break;
                }
                case 2: {
                    this.votingLists = this.buildVotingLists(pollType);
                    break;
                }
                case 3: {
                    this.votingLists = this.buildVotingLists(pollType);
                }
            }
        }
    }

    public String input() throws Exception {
        UserAccount userAccount = this.getPollenUserAccount();
        String pollUid = this.pollUri == null ? null : this.pollUri.getPollId();
        PollService service = this.getPollService();
        this.poll = service.getPollEditable(pollUid, userAccount, this.isClone());
        if (this.poll.isClosed()) {
            this.addFlashWarning(this._("pollen.warning.poll.is.closed.so.read.only", new Object[0]));
        }
        List pollChoices = this.poll.getChoice();
        if (this.isClone() && ChoiceType.IMAGE == this.poll.getChoiceType()) {
            File tmpDir = this.getConfiguration().getTemporaryDirectory();
            for (Choice choice : pollChoices) {
                String choiceName = choice.getName();
                File imageChoiceFile = service.getPollChoiceImageFile(pollUid, choiceName);
                File newImageChoiceFile = File.createTempFile(choiceName, null, tmpDir);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Copy image from " + imageChoiceFile + " to " + newImageChoiceFile));
                }
                FileUtils.copyFile((File)imageChoiceFile, (File)newImageChoiceFile);
                ((PollImageChoice)choice).setLocation(newImageChoiceFile.getAbsolutePath());
            }
        }
        List pollVotingLists = this.poll.getVotingList();
        this.loadChoicesAndvotingLists(this.poll, (Collection)pollChoices, (Collection)pollVotingLists, !this.isVoteStarted());
        this.setLimitChoice(this.poll.getMaxChoiceNb() > 0);
        if (this.isLimitChoice()) {
            this.setMaxChoices(Integer.valueOf(this.poll.getMaxChoiceNb()));
        } else {
            this.setMaxChoices(Integer.valueOf(1));
        }
        PreventRule reminder = this.poll.getPreventRuleByScope("rappel");
        if (reminder != null) {
            this.setReminder(true);
            this.setReminderHourCountdown(Integer.valueOf(reminder.getSensibility()));
        } else {
            this.setReminder(false);
            this.setReminderHourCountdown(Integer.valueOf(2));
        }
        PreventRule notification = this.poll.getPreventRuleByScope("vote");
        if (notification != null) {
            this.setNotification(true);
        }
        if (this.isVoteStarted()) {
            this.addFlashMessage(this._("pollen.information.poll.form.voteStarted", new Object[0]));
        }
        return "input";
    }

    public String inputAfterValidationError() throws Exception {
        Collection<Object> pollVotingLists;
        Collection<Object> pollChoices = this.isVoteStarted() ? this.poll.getChoice() : this.choices.values();
        Collection<Object> collection = pollVotingLists = this.isVoteStarted() ? this.poll.getVotingList() : this.votingLists.values();
        if (ChoiceType.IMAGE == this.poll.getChoiceType()) {
            File tmpDir = this.getConfiguration().getTemporaryDirectory();
            for (Choice choice : pollChoices) {
                PollImageChoice imageChoice = (PollImageChoice)choice;
                String choiceId = choice.getTopiaId();
                String location = imageChoice.getLocation();
                boolean needCopy = false;
                if (!this.isImageUploadEmpty(imageChoice)) {
                    if (StringUtils.isBlank((CharSequence)choiceId)) {
                        needCopy = true;
                    } else {
                        Choice oldChoice = this.poll.getChoiceByTopiaId(choiceId);
                        needCopy = ObjectUtils.notEqual((Object)oldChoice.getName(), (Object)imageChoice.getName());
                    }
                }
                if (!needCopy) continue;
                File uploadedImage = new File(location);
                File copyImage = File.createTempFile(uploadedImage.getName(), null, tmpDir);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Copy image from " + uploadedImage + " to " + copyImage));
                }
                FileUtils.copyFile((File)uploadedImage, (File)copyImage);
                imageChoice.setLocation(copyImage.getAbsolutePath());
                this.getPollService().generateThumbIfNeeded(copyImage);
            }
        }
        this.loadChoicesAndvotingLists(this.poll, pollChoices, (Collection)pollVotingLists, true);
        return "input";
    }

    @InputConfig(methodName="inputAfterValidationError")
    public String execute() throws Exception {
        PreventRule rule;
        if (this.isGetMethod()) {
            return this.input();
        }
        if (!this.isVoteStarted()) {
            this.poll.clearChoice();
            this.poll.clearVotingList();
            for (Integer index : this.choices.keySet()) {
                Choice choice = (Choice)this.choices.get(index);
                this.poll.addChoice(choice);
            }
            if (!this.poll.isPollFree()) {
                for (Integer index : this.votingLists.keySet()) {
                    VotingList votingList = (VotingList)this.votingLists.get(index);
                    this.poll.addVotingList(votingList);
                }
            }
        }
        if (this.isLimitChoice()) {
            this.poll.setMaxChoiceNb(this.getMaxChoices().intValue());
        } else {
            this.poll.setMaxChoiceNb(0);
        }
        if (this.poll.isAnonymous()) {
            this.poll.setAnonymousVoteAllowed(false);
        }
        this.poll.clearPreventRule();
        PreventRuleService preventRuleService = this.getPreventRuleService();
        if (this.isNotification()) {
            rule = preventRuleService.createAddVotePreventRule();
            this.poll.addPreventRule(rule);
        }
        if (this.isReminder()) {
            rule = preventRuleService.createRemindPreventRule(this.getReminderHourCountdown().intValue());
            this.poll.addPreventRule(rule);
        }
        this.poll = this.savePoll(this.poll);
        this.pollUri = PollUri.newPollUri((String)this.poll.getAdminId());
        this.getPollenSession().clearDynamicData();
        return "success";
    }

    public void validate() {
        if (this.isGetMethod()) {
            return;
        }
        this.validateInformations();
        this.validateOptions();
    }

    public void addFile(int index, File file) {
        this.getParameters().put("imageChoice_" + index + ".newLocation", new String[]{file.getAbsolutePath()});
    }

    public void addFileContentType(int index, String contentType) {
        this.getParameters().put("imageChoice_" + index + ".newContentType", new String[]{contentType});
    }

    public void addFileName(int index, String fileName) {
        this.getParameters().put("imageChoice_" + index + ".newName", new String[]{fileName});
    }

    public boolean isInformationsError() {
        return this.informationsError;
    }

    public boolean isOptionsError() {
        return this.optionsError;
    }

    public int getSelectedTab() {
        int result = this.isInformationsError() ? 0 : (this.isOptionsError() ? 1 : 0);
        return result;
    }

    public PollUri getPollUri() {
        return this.pollUri;
    }

    public void setPollUri(PollUri pollUri) {
        this.pollUri = pollUri;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public Map<String, String> getPollTypes() {
        return this.pollTypes;
    }

    public Map<String, String> getVoteCountingTypes() {
        return this.voteCountingTypes;
    }

    public Map<String, String> getChoiceTypes() {
        return this.choiceTypes;
    }

    public Map<String, String> getPollVoteVisibilities() {
        return this.pollVoteVisibilities;
    }

    public List<Choice> getTextChoices() {
        return this.textChoices;
    }

    public List<Choice> getImageChoices() {
        return this.imageChoices;
    }

    public List<Choice> getDateChoices() {
        return this.dateChoices;
    }

    public List<VotingList> getRestrictedVotingList() {
        return this.restrictedVotingList;
    }

    public List<VotingList> getGroupVotingList() {
        return this.groupVotingList;
    }

    public boolean isNotification() {
        return this.notification;
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
    }

    public Integer getMaxChoices() {
        return this.maxChoices;
    }

    public void setMaxChoices(Integer maxChoices) {
        this.maxChoices = maxChoices;
    }

    public boolean isReminder() {
        return this.reminder;
    }

    public void setReminder(boolean reminder) {
        this.reminder = reminder;
    }

    public boolean isLimitChoice() {
        return this.limitChoice;
    }

    public void setLimitChoice(boolean limitChoice) {
        this.limitChoice = limitChoice;
    }

    public Integer getReminderHourCountdown() {
        return this.reminderHourCountdown;
    }

    public void setReminderHourCountdown(Integer reminderHourCountdown) {
        this.reminderHourCountdown = reminderHourCountdown;
    }

    public boolean isPollCommentVisible() {
        PollCommentVisibility pollCommentVisibility = this.poll.getPollCommentVisibility();
        return pollCommentVisibility == PollCommentVisibility.EVERYBODY;
    }

    public void setPollCommentVisible(boolean newValue) {
        if (newValue) {
            this.poll.setPollCommentVisibility(PollCommentVisibility.EVERYBODY);
        } else {
            this.poll.setPollCommentVisibility(PollCommentVisibility.NOBODY);
        }
    }

    public String getActionLabel() {
        return this.isEdit() ? this._("pollen.action.editPoll", new Object[0]) : this._("pollen.action.createPoll", new Object[0]);
    }

    public String getPageTitle() {
        return this.isEdit() ? this.getPoll().getTitle() : this._("pollen.title.createPoll", new Object[0]);
    }

    public boolean isVoteStarted() {
        return this.isEdit() && this.poll.sizeVote() > 0;
    }

    public boolean isCreatorUserAccountDefined() {
        PollAccount creator = this.poll.getCreator();
        return creator.getUserAccount() != null;
    }

    public String getImageChoiceName(Choice choice) {
        String name = choice.getName();
        try {
            String result = URLEncoder.encode(IMAGECHOICES_THUMB_PREFIX + name, Charsets.UTF_8.name());
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new PollenTechnicalException("Could not encode name " + name, (Throwable)e);
        }
    }

    public String getVoteCountingHelp(String type) {
        return (String)this.voteCountingTypesHelp.get(type);
    }

    public void prepareFormPage() throws Exception {
        this.getPollenSession().removeDynamicDataWithPrefix(IMAGECHOICES_THUMB_PREFIX);
        this.pollTypes = this.decorateToName((Enum[])PollType.values());
        this.choiceTypes = this.decorateToName((Enum[])ChoiceType.values());
        this.pollVoteVisibilities = this.decorateToName((Enum[])PollVoteVisibility.values());
        this.voteCountingTypes = Maps.newTreeMap();
        this.voteCountingTypesHelp = Maps.newTreeMap();
        VoteCountingFactory voteCountingFactory = this.getVoteCountingFactory();
        for (VoteCounting strategy : voteCountingFactory) {
            String strategyName = strategy.getName(this.getLocale());
            String strategyHelp = strategy.getHelp(this.getLocale());
            this.voteCountingTypes.put(strategy.getId() + "", strategyName);
            this.voteCountingTypesHelp.put(strategy.getId() + "", strategyHelp);
        }
        this.textChoices = Lists.newArrayList();
        this.imageChoices = Lists.newArrayList();
        this.dateChoices = Lists.newArrayList();
        this.restrictedVotingList = Lists.newArrayList();
        this.groupVotingList = Lists.newArrayList();
    }

    public Function<PersonToList, PersonToList> getPersontoListCreator() {
        if (this.persontoListCreator == null) {
            this.persontoListCreator = PollenServiceFunctions.newPersonToListCreator();
        }
        return this.persontoListCreator;
    }

    public Function<VotingList, VotingList> getVotingListCreator() {
        if (this.votingListCreator == null) {
            this.votingListCreator = PollenServiceFunctions.newVotingListCreator((Function)this.getPersontoListCreator());
        }
        return this.votingListCreator;
    }

    public Function<Choice, Choice> getTextChoiceCreator() {
        if (this.textChoiceCreator == null) {
            this.textChoiceCreator = PollenServiceFunctions.newTextChoiceCreator();
        }
        return this.textChoiceCreator;
    }

    public Function<Choice, Choice> getDateChoiceCreator() {
        if (this.dateChoiceCreator == null) {
            this.dateChoiceCreator = PollenServiceFunctions.newDateChoiceCreator();
        }
        return this.dateChoiceCreator;
    }

    public Function<Choice, Choice> getImageChoiceCreator() {
        if (this.imageChoiceCreator == null) {
            this.imageChoiceCreator = PollenServiceFunctions.newImageChoiceCreator();
        }
        return this.imageChoiceCreator;
    }

    private <E extends Enum<E>> Map<String, String> decorateToName(E ... values) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (E value : values) {
            result.put(((Enum)value).name(), this.getText(((I18nAble)value).getI18nKey()));
        }
        return result;
    }

    protected void validateInformations() {
        if (StringUtils.isBlank((CharSequence)this.poll.getTitle())) {
            this.addInformationsError("poll.title", this._("pollen.error.poll.required.title", new Object[0]));
        }
        if (!this.isVoteStarted()) {
            if (MapUtils.isEmpty((Map)this.choices)) {
                this.addInformationsError("poll.choices", this._("pollen.error.poll.required.one.choice", new Object[0]));
            } else {
                switch (1.$SwitchMap$org$chorem$pollen$business$persistence$ChoiceType[this.poll.getChoiceType().ordinal()]) {
                    case 1: {
                        this.validateTextChoices();
                        break;
                    }
                    case 2: {
                        this.validateDateChoices();
                        break;
                    }
                    case 3: {
                        this.validateImageChoices();
                    }
                }
            }
        }
    }

    protected void validateTextChoices() {
        String choicePrefix = this.getChoiceFieldPrefix(ChoiceType.TEXT);
        HashSet choiceNames = Sets.newHashSet();
        for (Map.Entry entry : this.choices.entrySet()) {
            Integer choiceIndex = (Integer)entry.getKey();
            Choice choice = (Choice)entry.getValue();
            String choiceErrorField = choicePrefix + choiceIndex + ".name";
            String choiceName = choice.getName();
            if (StringUtils.isBlank((CharSequence)choiceName)) {
                this.addInformationsError(choiceErrorField, this._("pollen.error.poll.choice.name.required", new Object[0]));
                continue;
            }
            if (choiceNames.contains(choiceName)) {
                this.addInformationsError(choiceErrorField, this._("pollen.error.poll.choice.already.used.name", new Object[0]));
                continue;
            }
            choiceNames.add(choiceName);
        }
    }

    protected void validateDateChoices() {
        String choicePrefix = this.getChoiceFieldPrefix(ChoiceType.DATE);
        HashSet choiceNames = Sets.newHashSet();
        for (Map.Entry entry : this.choices.entrySet()) {
            Integer choiceIndex = (Integer)entry.getKey();
            PollDateChoice choice = (PollDateChoice)entry.getValue();
            String choiceErrorField = choicePrefix + choiceIndex + ".name";
            if (StringUtils.isBlank((CharSequence)choice.getName())) {
                this.addInformationsError(choiceErrorField, this._("pollen.error.poll.dateChoice.required", new Object[0]));
                continue;
            }
            if (choice.getDate() == null) {
                this.addInformationsError(choiceErrorField, this._("pollen.error.poll.dateChoice.badDateFormat", new Object[0]));
                continue;
            }
            String choiceValue = choice.getDate().toString();
            if (choiceNames.contains(choiceValue)) {
                this.addInformationsError(choiceErrorField, this._("pollen.error.poll.dateChoice.already.used", new Object[0]));
                continue;
            }
            choiceNames.add(choiceValue);
        }
    }

    protected void validateImageChoices() {
        String choicePrefix = this.getChoiceFieldPrefix(ChoiceType.IMAGE);
        HashSet choiceNames = Sets.newHashSet();
        for (Map.Entry entry : this.choices.entrySet()) {
            Integer choiceIndex = (Integer)entry.getKey();
            Choice choice = (Choice)entry.getValue();
            String choiceErrorField = choicePrefix + choiceIndex + ".name";
            String choiceName = choice.getName();
            if (StringUtils.isBlank((CharSequence)choiceName)) {
                this.addInformationsError(choiceErrorField, this._("pollen.error.poll.imageChoice.upload.required", new Object[0]));
                continue;
            }
            if (choiceNames.contains(choiceName)) {
                this.addInformationsError(choiceErrorField, this._("pollen.error.poll.imageChoice.already.used", new Object[0]));
                continue;
            }
            choiceNames.add(choiceName);
            String contentTypeField = choicePrefix + choiceIndex + ".newContentType";
            String contentTypes = this.getNonEmptyParameterValue(contentTypeField);
            if (contentTypes == null || contentTypes.startsWith("image/")) continue;
            this.addInformationsError(choiceErrorField, this._("pollen.error.poll.imageChoice.upload.badContentType", new Object[0]));
            PollImageChoice imageChoice = (PollImageChoice)choice;
            File imageFile = new File(imageChoice.getLocation());
            File imageThumbFile = this.getPollService().getImageThumbFile(imageFile);
            FileUtils.deleteQuietly((File)imageThumbFile);
            FileUtils.deleteQuietly((File)imageFile);
            String choiceId = imageChoice.getTopiaId();
            if (StringUtils.isBlank((CharSequence)choiceId)) {
                imageChoice.setLocation(null);
                imageChoice.setName(null);
                continue;
            }
            PollImageChoice pollChoice = (PollImageChoice)this.poll.getChoiceByTopiaId(choiceId);
            imageChoice.setName(pollChoice.getName());
            imageChoice.setLocation(pollChoice.getLocation());
        }
    }

    protected void validateOptions() {
        String creatorEmail;
        if (!this.isVoteStarted() && !this.poll.isPollFree()) {
            HashSet groups = Sets.newHashSet();
            HashSet voters = Sets.newHashSet();
            HashSet emails = Sets.newHashSet();
            for (Map.Entry entry : this.votingLists.entrySet()) {
                this.validateVotingList(((Integer)entry.getKey()).intValue(), (VotingList)entry.getValue(), (Set)groups, (Set)voters, (Set)emails);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(creatorEmail = this.poll.getCreator().getEmail())) && !StringUtil.isEmail((String)creatorEmail)) {
            this.addOptionsError("poll.creator.email", this._("pollen.error.email.invalid", new Object[0]));
        }
        Date currentTime = this.serviceContext.getCurrentTime();
        if (this.validateEndDate(this.poll.getBeginChoiceDate(), this.poll.getEndChoiceDate())) {
            this.addOptionsError("poll.endChoiceDate", this._("pollen.error.poll.endChoiceDate.before.beginChoiceDate", new Object[0]));
        }
        if (this.validateEndDate(currentTime, this.poll.getEndChoiceDate())) {
            this.addOptionsError("poll.endChoiceDate", this._("pollen.error.poll.endChoiceDate.before.now", new Object[0]));
        }
        if (this.validateEndDate(this.poll.getBeginDate(), this.poll.getEndDate())) {
            this.addOptionsError("poll.endDate", this._("pollen.error.poll.endDate.before.beginDate", new Object[0]));
        }
        if (this.validateEndDate(currentTime, this.poll.getEndDate())) {
            this.addOptionsError("poll.endDate", this._("pollen.error.poll.endDate.before.now", new Object[0]));
        }
        if (this.validateEndDate(this.poll.getEndChoiceDate(), this.poll.getEndDate())) {
            this.addOptionsError("poll.endChoiceDate", this._("pollen.error.poll.endChoiceDate.after.endDate", new Object[0]));
        }
        if (this.isLimitChoice()) {
            if (this.getMaxChoices() == null) {
                this.addOptionsError("maxChoices", this._("pollen.error.poll.maxChoice.required", new Object[0]));
            } else if (this.getMaxChoices() < 1) {
                this.addOptionsError("maxChoices", this._("pollen.error.poll.maxChoice.greater.than.0", new Object[0]));
            }
        }
        if (this.isReminder()) {
            if (this.getReminderHourCountdown() == null) {
                this.addOptionsError("reminderHourCountdown", this._("pollen.error.poll.reminderHourCountdown.required", new Object[0]));
            } else if (this.getReminderHourCountdown() < 1) {
                this.addOptionsError("reminderHourCountdown", this._("pollen.error.poll.reminderHourCountdown.greater.than.0", new Object[0]));
            }
        }
    }

    protected void validateVotingList(int votingListNumber, VotingList votingList, Set<String> groups, Set<String> voters, Set<String> emails) {
        List personToLists;
        PollType votingListType = this.poll.getPollType();
        String fieldNamePrefix = "votingList" + votingListType + "_" + votingListNumber;
        if (this.poll.isPollGroup()) {
            String votingListName = votingList.getName();
            if (StringUtils.isEmpty((CharSequence)votingListName)) {
                this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.required.votingList.name", new Object[0]));
            } else {
                boolean add = groups.add(votingListName);
                if (!add) {
                    this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.votingList.name.doublon", new Object[0]));
                }
            }
            if (votingList.getWeight() == 0.0) {
                this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.votingList.weight.not.valid", new Object[0]));
            }
        }
        if (CollectionUtils.isEmpty((Collection)(personToLists = votingList.getPollAccountPersonToList()))) {
            this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.required.one.personToList", new Object[0]));
        } else {
            for (int i = 0; i < personToLists.size(); ++i) {
                this.validatePersonList(i, fieldNamePrefix, (PersonToList)personToLists.get(i), voters, emails);
            }
        }
    }

    protected void validatePersonList(int personToListNumber, String votingListFieldNamePrefix, PersonToList personToList, Set<String> voters, Set<String> emails) {
        String fieldNamePrefix = votingListFieldNamePrefix + "PersonToList_" + personToListNumber;
        PollAccount pollAccount = personToList.getPollAccount();
        String votingId = pollAccount.getVotingId();
        if (StringUtils.isEmpty((CharSequence)votingId)) {
            this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.personToList.votingId.required", new Object[0]));
        } else {
            boolean add = voters.add(votingId);
            if (!add) {
                this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.personToList.votingId.doublon", new Object[0]));
            }
        }
        String email = pollAccount.getEmail();
        if (StringUtils.isEmpty((CharSequence)email)) {
            this.addOptionsError(fieldNamePrefix, this._("pollen.error.email.required", new Object[0]));
        } else {
            boolean validEmail = StringUtil.isEmail((String)email);
            if (!validEmail) {
                this.addOptionsError(fieldNamePrefix, this._("pollen.error.email.invalid", new Object[0]));
            } else {
                boolean add = emails.add(email);
                if (!add) {
                    this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.personToList.email.doublon", new Object[0]));
                }
            }
        }
        if (personToList.getWeight() == 0.0) {
            this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.personToList.weight.not.valid", new Object[0]));
        }
    }

    protected boolean validateEndDate(Date begin, Date end) {
        return begin != null && end != null && end.before(begin);
    }

    public Object getDateChoiceValue(PollDateChoice choice) {
        Date date = choice.getDate();
        Object result = date == null ? choice.getName() : date;
        return result;
    }

    public void addFieldError(String fieldName, String errorMessage) {
        super.addFieldError(fieldName, errorMessage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("VALIDATION [" + fieldName + "] : " + errorMessage));
        }
    }

    protected void addInformationsError(String fieldName, String errorMessage) {
        this.addFieldError(fieldName, errorMessage);
        this.informationsError = true;
    }

    protected void addOptionsError(String fieldName, String errorMessage) {
        this.addFieldError(fieldName, errorMessage);
        this.optionsError = true;
    }

    protected void loadChoicesAndvotingLists(Poll poll, Collection<Choice> pollChoices, Collection<VotingList> pollVotinLists, boolean fillLists) throws IOException {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)poll.getChoiceType());
        Preconditions.checkNotNull((Object)poll.getPollType());
        if (CollectionUtils.isNotEmpty(pollChoices)) {
            switch (1.$SwitchMap$org$chorem$pollen$business$persistence$ChoiceType[poll.getChoiceType().ordinal()]) {
                case 1: {
                    this.getTextChoices().addAll(pollChoices);
                    break;
                }
                case 2: {
                    this.getDateChoices().addAll(pollChoices);
                    break;
                }
                case 3: {
                    this.getImageChoices().addAll(pollChoices);
                    PollService service = this.getPollService();
                    for (Choice choice : pollChoices) {
                        PollImageChoice imageChoice = (PollImageChoice)choice;
                        String choiceId = imageChoice.getTopiaId();
                        File imageChoiceFile = null;
                        if (StringUtils.isBlank((CharSequence)choiceId)) {
                            if (!this.isImageUploadEmpty(imageChoice)) {
                                imageChoiceFile = new File(imageChoice.getLocation());
                            }
                        } else {
                            Choice oldChoice = poll.getChoiceByTopiaId(choiceId);
                            imageChoiceFile = ObjectUtils.equals((Object)imageChoice.getName(), (Object)oldChoice.getName()) ? service.getPollChoiceImageFile(poll.getPollId(), choice.getName()) : new File(imageChoice.getLocation());
                        }
                        if (imageChoiceFile == null) continue;
                        File thumbFile = service.getImageThumbFile(imageChoiceFile);
                        String key = this.getImageChoiceName(choice);
                        this.getPollenSession().putDynamicData(key, (Serializable)thumbFile);
                    }
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(pollVotinLists)) {
            switch (1.$SwitchMap$org$chorem$pollen$business$persistence$PollType[poll.getPollType().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.getRestrictedVotingList().addAll(pollVotinLists);
                    break;
                }
                case 3: {
                    this.getGroupVotingList().addAll(pollVotinLists);
                }
            }
        }
        if (fillLists) {
            int defaultMaxChoices = 5;
            int defaultMaxVoting = 5;
            this.fillLists(defaultMaxChoices, defaultMaxVoting);
        }
    }

    protected void fillLists(int defaultMaxChoices, int defaultMaxVoting) {
        PollenServiceFunctions.fillChoiceList((List)this.textChoices, (int)defaultMaxChoices, (Function)this.getTextChoiceCreator());
        PollenServiceFunctions.fillChoiceList((List)this.dateChoices, (int)defaultMaxChoices, (Function)this.getDateChoiceCreator());
        PollenServiceFunctions.fillChoiceList((List)this.imageChoices, (int)defaultMaxChoices, (Function)this.getImageChoiceCreator());
        if (CollectionUtils.isEmpty((Collection)this.restrictedVotingList)) {
            this.restrictedVotingList.add(this.getVotingListCreator().apply(null));
        }
        for (VotingList votingList : this.restrictedVotingList) {
            PollenServiceFunctions.fillVotingList((VotingList)votingList, (Function)this.getPersontoListCreator(), (int)defaultMaxVoting);
        }
        if (CollectionUtils.isEmpty((Collection)this.groupVotingList)) {
            this.groupVotingList.add(this.getVotingListCreator().apply(null));
        }
        for (VotingList votingList : this.groupVotingList) {
            PollenServiceFunctions.fillVotingList((VotingList)votingList, (Function)this.getPersontoListCreator(), (int)defaultMaxVoting);
        }
    }

    protected boolean isTextChoiceEmpty(Choice textChoice) {
        boolean result = StringUtils.isBlank((CharSequence)textChoice.getName()) && StringUtils.isBlank((CharSequence)textChoice.getDescription());
        return result;
    }

    protected boolean isDateChoiceEmpty(PollDateChoice dateChoice) {
        boolean result = StringUtils.isBlank((CharSequence)dateChoice.getName()) && StringUtils.isBlank((CharSequence)dateChoice.getDescription());
        return result;
    }

    protected boolean isImageChoiceEmpty(PollImageChoice imageChoice) {
        boolean result = StringUtils.isBlank((CharSequence)imageChoice.getLocation()) && StringUtils.isBlank((CharSequence)imageChoice.getDescription());
        return result;
    }

    protected boolean isImageUploadEmpty(PollImageChoice imageChoice) {
        boolean result = StringUtils.isBlank((CharSequence)imageChoice.getLocation());
        return result;
    }

    protected boolean isPersonToListEmpty(PersonToList personToList) {
        PollAccount pollAccount = personToList.getPollAccount();
        boolean result = StringUtils.isBlank((CharSequence)pollAccount.getVotingId()) && StringUtils.isBlank((CharSequence)pollAccount.getEmail());
        return result;
    }

    protected Map<Integer, Choice> buildTextChoices() {
        Map<Integer, Choice> result = Maps.newTreeMap();
        String fieldPrefix = this.getChoiceFieldPrefix(ChoiceType.TEXT);
        int maxNumber = 0;
        for (String paramName : this.getParameters().keySet()) {
            String choicePrefix;
            Choice choice;
            Matcher matcher = TEXT_CHOICE_NAME_PATTERN.matcher(paramName);
            if (!matcher.matches()) continue;
            String paramValue = this.getNonEmptyParameterValue(paramName);
            Integer choiceNumber = Integer.valueOf(matcher.group(1));
            if (choiceNumber > maxNumber) {
                maxNumber = choiceNumber;
            }
            if (this.isTextChoiceEmpty(choice = this.createChoice((Choice)new ChoiceImpl(), choicePrefix = fieldPrefix + choiceNumber, paramValue))) continue;
            result.put(choiceNumber, choice);
            int order = this.getIntegerValue(choicePrefix + ".order");
            this.choicesOrder.put(order, choiceNumber);
        }
        result = this.reindexChoiceMap((Map)result, maxNumber);
        int size = result.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("nbTextChoices (from request) = " + size));
        }
        this.logChoice(result);
        return result;
    }

    protected Map<Integer, Choice> buildDateChoices() {
        Map<Integer, Choice> result = Maps.newTreeMap();
        String fieldPrefix = this.getChoiceFieldPrefix(ChoiceType.DATE);
        int maxNumber = 0;
        for (String paramName : this.getParameters().keySet()) {
            Matcher matcher = DATE_CHOICE_NAME_PATTERN.matcher(paramName);
            if (!matcher.matches()) continue;
            String paramValue = this.getNonEmptyParameterValue(paramName);
            Integer choiceNumber = Integer.valueOf(matcher.group(1));
            if (choiceNumber > maxNumber) {
                maxNumber = choiceNumber;
            }
            String choicePrefix = fieldPrefix + choiceNumber;
            PollDateChoice choice = (PollDateChoice)this.createChoice((Choice)new PollDateChoice(), choicePrefix, paramValue);
            if (StringUtils.isNotBlank((CharSequence)paramValue)) {
                Date date = DateConverter.convertFromString((String)paramValue);
                choice.setDate(date);
            }
            if (this.isDateChoiceEmpty(choice)) continue;
            result.put(choiceNumber, (Choice)choice);
            int order = this.getIntegerValue(choicePrefix + ".order");
            this.choicesOrder.put(order, choiceNumber);
        }
        result = this.reindexChoiceMap((Map)result, maxNumber);
        int size = result.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("nbDateChoices (from request)  = " + size));
        }
        this.logChoice(result);
        return result;
    }

    protected Map<Integer, Choice> buildImageChoices() {
        Map<Integer, Choice> result = Maps.newTreeMap();
        String fieldPrefix = this.getChoiceFieldPrefix(ChoiceType.IMAGE);
        int maxNumber = 0;
        TreeMap parametersToSwitch = Maps.newTreeMap();
        for (String string : this.getParameters().keySet()) {
            String paramValue;
            Matcher matcher = IMAGE_CHOICE_DESCRIPTION_PATTERN.matcher(string);
            if (!matcher.matches()) continue;
            Integer choiceNumber = Integer.valueOf(matcher.group(1));
            if (choiceNumber > maxNumber) {
                maxNumber = choiceNumber;
            }
            String choicePrefix = fieldPrefix + choiceNumber;
            PollImageChoice choice = (PollImageChoice)this.createChoice((Choice)new PollImageChoice(), choicePrefix, null);
            String location = this.getNonEmptyParameterValue(choicePrefix + ".newLocation");
            if (StringUtils.isNotBlank((CharSequence)location)) {
                choice.setLocation(location);
                paramValue = this.getNonEmptyParameterValue(choicePrefix + ".newName");
                choice.setName(paramValue);
                parametersToSwitch.put(choicePrefix + ".newLocation", choicePrefix + ".location");
                parametersToSwitch.put(choicePrefix + ".newName", choicePrefix + ".name");
            } else {
                location = this.getNonEmptyParameterValue(choicePrefix + ".location");
                choice.setLocation(location);
                paramValue = this.getNonEmptyParameterValue(choicePrefix + ".name");
                choice.setName(paramValue);
            }
            if (this.isImageChoiceEmpty(choice)) continue;
            result.put(choiceNumber, (Choice)choice);
            int order = this.getIntegerValue(choicePrefix + ".order");
            this.choicesOrder.put(order, choiceNumber);
        }
        for (Map.Entry entry : parametersToSwitch.entrySet()) {
            String paramNameSource = (String)entry.getKey();
            String paramNameTarget = (String)entry.getValue();
            String[] valueToSwitch = (String[])this.getParameters().remove(paramNameSource);
            this.getParameters().put(paramNameTarget, valueToSwitch);
        }
        result = this.reindexChoiceMap((Map)result, maxNumber);
        int size = result.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("nbImageChoices  (from request) = " + size));
        }
        this.logChoice(result);
        return result;
    }

    protected Map<Integer, VotingList> buildVotingLists(PollType pollType) {
        Map<Integer, VotingList> result = Maps.newTreeMap();
        int maxNumber = 0;
        String votingListPrefix = "votingList" + pollType.name();
        Set votingListParameterNames = Sets.filter(this.getParameters().keySet(), (Predicate)new StringStartWithPredicate(votingListPrefix));
        Pattern votingListPattern = Pattern.compile("(" + votingListPrefix + ")_(\\d+)\\.name");
        for (String paramName : votingListParameterNames) {
            Matcher matcher = votingListPattern.matcher(paramName);
            if (!matcher.matches()) continue;
            int votingListNumber = Integer.valueOf(matcher.group(2));
            this.buildVotingList(paramName, votingListPrefix + "_" + votingListNumber, votingListNumber, result);
            maxNumber = Math.max(maxNumber, votingListNumber);
        }
        result = this.reindexMap((Map)result, maxNumber);
        int size = result.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("nbVotingList [" + pollType + "] (from request) = " + size));
        }
        for (Map.Entry entry : result.entrySet()) {
            VotingList votingList = (VotingList)entry.getValue();
            if (votingList.isPollAccountPersonToListEmpty()) continue;
            List personToList = votingList.getPollAccountPersonToList();
            TreeMap personToListMap = Maps.newTreeMap();
            int index = 0;
            for (PersonToList toList : personToList) {
                personToListMap.put(index++, toList);
            }
        }
        return result;
    }

    private double getDoubleValue(String parameterName) {
        double result;
        block3: {
            String parameterValue = this.getNonEmptyParameterValue(parameterName);
            result = 0.0;
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                try {
                    result = Double.valueOf(parameterValue);
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Bad double conversion from param [" + parameterName + "] : " + parameterValue));
                }
            }
        }
        return result;
    }

    private int getIntegerValue(String parameterName) {
        int result;
        block3: {
            String parameterValue = this.getNonEmptyParameterValue(parameterName);
            result = 0;
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                try {
                    result = Integer.valueOf(parameterValue);
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Bad double conversion from param [" + parameterName + "] : " + parameterValue));
                }
            }
        }
        return result;
    }

    private int buildVotingList(String votingListParameterName, String votingListPrefix, int votingListNumber, Map<Integer, VotingList> result) {
        String paramValue = this.getNonEmptyParameterValue(votingListParameterName);
        VotingListImpl votingList = new VotingListImpl();
        votingList.setName(paramValue);
        double weight = this.getDoubleValue(votingListPrefix + ".weight");
        votingList.setWeight(weight);
        String topiaId = this.getNonEmptyParameterValue(votingListPrefix + ".topiaId");
        votingList.setTopiaId(topiaId);
        result.put(votingListNumber, (VotingList)votingList);
        String personToListPrefix = votingListPrefix + "PersonToList_";
        Set votingListParameterNames = Sets.filter(this.getParameters().keySet(), (Predicate)new StringStartWithPredicate(personToListPrefix));
        Pattern personToListNamePattern = Pattern.compile(personToListPrefix + "(\\d+)\\.votingId");
        Map personToLists = Maps.newTreeMap();
        int maxPersonToListNumber = 0;
        for (String personToListNameParameter : votingListParameterNames) {
            Matcher matcher = personToListNamePattern.matcher(personToListNameParameter);
            if (!matcher.matches()) continue;
            int personToListNumber = this.buildPersonToList(personToListPrefix, personToListNameParameter, matcher, votingListNumber, personToLists);
            maxPersonToListNumber = Math.max(maxPersonToListNumber, personToListNumber);
        }
        personToLists = this.reindexMap(personToLists, maxPersonToListNumber);
        for (PersonToList personToList : personToLists.values()) {
            votingList.addPollAccountPersonToList(personToList);
        }
        return votingListNumber;
    }

    private int buildPersonToList(String personToListPrefix, String paramName, Matcher personToListMatcher, int votingListNumber, Map<Integer, PersonToList> result) {
        int personToListNumber = Integer.valueOf(personToListMatcher.group(1));
        PersonToListImpl personToList = new PersonToListImpl();
        PollAccountImpl account = new PollAccountImpl();
        personToList.setPollAccount((PollAccount)account);
        account.setVotingId(this.getNonEmptyParameterValue(paramName));
        String prefix = personToListPrefix + personToListNumber;
        double weight = this.getDoubleValue(prefix + ".weight");
        personToList.setWeight(weight);
        String topiaId = this.getNonEmptyParameterValue(prefix + ".topiaId");
        personToList.setTopiaId(topiaId);
        String email = this.getNonEmptyParameterValue(prefix + ".email");
        account.setEmail(email);
        String accountId = this.getNonEmptyParameterValue(prefix + ".accountId");
        account.setAccountId(accountId);
        if (!this.isPersonToListEmpty((PersonToList)personToList)) {
            result.put(personToListNumber, (PersonToList)personToList);
        }
        return personToListNumber;
    }

    private <C extends Choice> C createChoice(C choice, String prefix, String name) {
        String description = this.getNonEmptyParameterValue(prefix + ".description");
        String topiaId = this.getNonEmptyParameterValue(prefix + ".topiaId");
        choice.setName(name);
        choice.setDescription(description);
        choice.setTopiaId(topiaId);
        return choice;
    }

    private void logChoice(Map<Integer, Choice> result) {
        for (Map.Entry<Integer, Choice> e : result.entrySet()) {
            Integer choiceId = e.getKey();
            Choice choice = e.getValue();
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Choice [" + choiceId + "] = " + choice.getName() + " -- " + choice.getDescription()));
        }
    }

    protected <T> Map<Integer, T> reindexMap(Map<Integer, T> result, int maxNumber) {
        TreeMap result2;
        if (maxNumber != result.size() - 1) {
            ArrayList numbers = Lists.newArrayList(result.keySet());
            Collections.sort(numbers);
            result2 = Maps.newTreeMap();
            int i = 0;
            for (Integer number : numbers) {
                Object choice = result.get(number);
                result2.put(i++, choice);
            }
        } else {
            result2 = result;
        }
        return result2;
    }

    protected <T> Map<Integer, T> reindexChoiceMap(Map<Integer, T> result, int maxNumber) {
        TreeMap result2 = Maps.newTreeMap();
        for (Integer choiceOrder : this.choicesOrder.keySet()) {
            Integer choiceNumber = (Integer)this.choicesOrder.get(choiceOrder);
            T choice = result.get(choiceNumber);
            if (choice == null) continue;
            result2.put(choiceOrder, choice);
        }
        return result2;
    }

    protected String getNonEmptyParameterValue(String paramName) {
        String paramValue;
        String[] paramValues = (String[])this.getParameters().get(paramName);
        String result = null;
        if (paramValues != null && paramValues.length == 1 && StringUtils.isNotEmpty((CharSequence)(paramValue = paramValues[0]))) {
            result = paramValue;
        }
        return result;
    }

    private String getChoiceFieldPrefix(ChoiceType choiceType) {
        String result = null;
        switch (1.$SwitchMap$org$chorem$pollen$business$persistence$ChoiceType[choiceType.ordinal()]) {
            case 1: {
                result = "textChoice_";
                break;
            }
            case 2: {
                result = "dateChoice_";
                break;
            }
            case 3: {
                result = "imageChoice_";
            }
        }
        return result;
    }
}

