<%--
  #%L
  Pollen :: UI (struts2)
  $Id: summary.jsp 3740 2012-11-09 09:33:24Z kmorin $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/poll/summary.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html" pageEncoding="utf-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/summary.css'/>"/>

<script type="text/javascript">

  function confirmDeletePoll(id) {
    $('.ui-dialog-title').html("<s:text name="pollen.title.delete.poll"/>");
    var dialog = $("#confirmDialog");
    dialog.html('');
    var url = "<s:url action='confirmDeletePoll/' namespace='/poll'/>";
    url += id + '?' + $.param(
      {
        redirectUrl:'<s:url namespace="/poll" action="summary/%{pollUri}"/>'
      });
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }

  function confirmClosePoll(id) {
    $('.ui-dialog-title').html("<s:text name="pollen.title.close.poll"/>");
    var dialog = $("#confirmDialog");
    dialog.html('');
    var url = "<s:url action='confirmClosePoll/' namespace='/poll'/>";
    url += id + '?' + $.param(
      {
        redirectUrl:'<s:url namespace="/poll" action="summary/%{pollUri}"/>'
      });
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }


  $(document).ready(function() {

    $('.url').click(function () {
      var el = $(this)[0];
      if (/textarea/i.test(el.tagName) || (/input/i.test(el.tagName) && /text/i.test(el.type))) {
        el.select();
      } else if (!!window.getSelection) { // FF, Safari, Chrome, Opera
        var sel = window.getSelection();
        var range = document.createRange();
        range.selectNodeContents(el);
        sel.removeAllRanges();
        sel.addRange(range);
      } else if (!!document.selection) { // IE
        document.selection.empty();
        var range = document.body.createTextRange();
        range.moveToElementText(el);
        range.select();
      }
    });

  });

</script>

<h1 class="titleCreation"><s:property value="poll.title"/></h1>

<h3>
    <s:if test="%{poll.creator.votingId != ''}">
      <s:text name="pollen.common.by"/>
      <s:property value="poll.creator.votingId"/>
    </s:if>
</h3>
<p>
    <s:property value="poll.description" escapeHtml="false"/>
</p>

<div class="ui-widget-content ui-corner-all">
  <s:label key="pollen.common.pollId" value=""/>
  <span class="fright url" id='pollId'>
    <s:property value="%{poll.pollId}"/>
  </span>
  <br/>
</div>

<%--Vote--%>
<s:if test="canVote">
  <div class="ui-widget-content-green ui-corner-all">
    <img src="<s:url value='/img/vote.png'/>" class="imgAction"
         alt="<s:text name='pollen.action.voteAction.help'/>"
         title="<s:text name='pollen.action.voteAction.help'/>"/>
    <s:a href="%{voteUrl}">
      <strong><s:text name="pollen.label.pollVotePage"/></strong>
    </s:a>
    <span class="fright url" id='voteUrl'>
      <s:property value="%{voteUrl}"/>
    </span>
  </div>
</s:if>
<s:elseif test="canShowVote">
  <div class="ui-widget-content-green ui-corner-all">
    <img src="<s:url value='/img/vote.png'/>" class="imgAction"
         alt="<s:text name='pollen.action.showVoteAction.help'/>"
         title="<s:text name='pollen.action.showVoteAction.help'/>"/>
    <s:a href="%{showVoteUrl}">
      <strong><s:text name="pollen.label.pollShowVotePage"/></strong>
    </s:a>
    <span class="fright url" id='showVoteUrl'>
      <s:property value="%{showVoteUrl}"/>
    </span>
  </div>
</s:elseif>

<%--Show Results--%>
<s:if test="canShowResult">
  <div class="ui-widget-content-green ui-corner-all">
    <img src="<s:url value='/img/count.png'/>" class="imgAction"
         alt="<s:text name='pollen.action.pollResult.help'/>"
         title="<s:text name='pollen.action.pollResult.help'/>"/>
    <s:a href="%{resultUrl}">
      <strong><s:text name='pollen.label.pollResultPage'/></strong>
    </s:a>
    <span class="fright url" id='voteUrl'>
      <s:property value="%{resultUrl}"/>
    </span>
  </div>
</s:if>

<%--Moderate--%>
<div class="ui-widget-content-yellow ui-corner-all">
  <img src="<s:url value='/img/moderate.png'/>" class="imgAction"
       alt="<s:text name='pollen.action.pollModerateVote.help'/>"
       title="<s:text name='pollen.action.pollModerateVote.help'/>"/>
  <s:a href="%{moderateUrl}">
    <strong><s:text name='pollen.label.pollModerateVotePage'/></strong>
  </s:a>
  <span class="fright url" id='voteUrl'>
      <s:property value="%{moderateUrl}"/>
    </span>
</div>

<%--Edit--%>
<div class="ui-widget-content-yellow ui-corner-all">
  <img src="<s:url value='/img/edit.png'/>" class="imgAction"
       alt="<s:text name='pollen.action.editPoll.help'/>"
       title="<s:text name='pollen.action.editPoll.help'/>"/>
  <s:a href="%{editUrl}">
    <strong><s:text name='pollen.label.pollEditPage'/></strong>
  </s:a>
  <span class="fright url" id='voteUrl'>
      <s:property value="%{editUrl}"/>
    </span>
</div>

<%--Export--%>
<%--div class="ui-widget-content-blue ui-corner-all">
  <img src="<s:url value='/img/export.png'/>" class="imgAction"
       alt="<s:text name='pollen.action.exportPoll.help'/>"
       title="<s:text name='pollen.action.exportPoll.help'/>"/>
  <s:a href="%{exportUrl}">
    <strong><s:text name='pollen.label.pollExportPage'/></strong>
  </s:a>
</div--%>

<%--Clone--%>
<div class="ui-widget-content-blue  ui-corner-all">
  <img src="<s:url value='/img/copy.png'/>" class="imgAction"
       alt="<s:text name='pollen.action.clonePoll.help'/>"
       title="<s:text name='pollen.action.clonePoll.help'/>"/>
  <s:a href="%{cloneUrl}">
    <strong> <s:text name='pollen.label.pollClonePage'/></strong>
  </s:a>
</div>

<%--Close--%>
<s:if test="canClose">
  <div class="ui-widget-content-red ui-corner-all">
    <img src="<s:url value='/img/close.png'/>" class="imgAction"
         alt="<s:text name='pollen.action.closePoll.help'/>"
         title="<s:text name='pollen.action.closePoll.help'/>"/>
    <s:a href="#" onclick="return confirmClosePoll('%{pollUri}')">
      <strong><s:text name='pollen.label.pollClosePage'/></strong>
    </s:a>

  </div>
</s:if>

<%--Delete --%>
<div class="ui-widget-content-red ui-corner-all">
  <img src="<s:url value='/img/delete.png'/>" class="imgAction"
       alt="<s:text name='pollen.action.deletePoll.help'/>"
       title="<s:text name='pollen.action.deletePoll.help'/>"/>
  <s:a href="#" onclick="return confirmDeletePoll('%{pollUri}')">
    <s:text name='pollen.label.pollDeletePage'/>
  </s:a>
</div>

<sj:dialog id="confirmDialog" autoOpen="false" modal="true" width="500"/>
