/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: Confirm.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/Confirm.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * Action for confirmation
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class Confirm extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String favoriteListId;

    protected String pollAccountId;

    protected PersonList favoriteList;

    protected PollAccount pollAccount;

    protected String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setPollAccountId(String pollAccountId) {
        this.pollAccountId = pollAccountId;
    }

    public void setFavoriteListId(String favoriteListId) {
        this.favoriteListId = favoriteListId;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public PersonList getFavoriteList() {
        return favoriteList;
    }

    public PollAccount getPollAccount() {
        return pollAccount;
    }

    @Override
    public String execute() throws Exception {

        if (StringUtils.isNotEmpty(favoriteListId)) {

            // load favorite list
            favoriteList = getFavoriteService().getEntityById(PersonList.class,
                                                              favoriteListId);
        }

        if (StringUtils.isNotEmpty(pollAccountId)) {

            // load poll account
            pollAccount = getFavoriteService().getEntityById(PollAccount.class,
                                                             pollAccountId);
        }
        return SUCCESS;
    }
}
