/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: GetFavoriteLists.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetFavoriteLists.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Maps;
import org.chorem.pollen.business.persistence.PersonList;

import java.util.List;
import java.util.Map;

/**
 * Get pagined list of favorite lists of the connected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetFavoriteLists extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] favoriteLists;

    public Map<String, Object>[] getFavoriteLists() {
        return favoriteLists;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        List<PersonList> allFavoriteLists = getFavoriteService().getFavoriteLists(
                getPollenUserAccount(),
                pager);

        favoriteLists = new Map[allFavoriteLists.size()];
        int index = 0;
        for (PersonList favoriteList : allFavoriteLists) {
            Map<String, Object> map = Maps.newHashMap();
            map.put(PersonList.PROPERTY_NAME, favoriteList.getName());
            map.put("id", favoriteList.getTopiaId());
            map.put("nbAccounts", favoriteList.sizePollAccount());
            favoriteLists[index++] = map;
        }

        return SUCCESS;
    }
}
