/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.FavoriteList;
import org.chorem.pollen.persistence.entity.FavoriteListMember;
import org.chorem.pollen.services.service.FavoriteListImport;
import org.chorem.pollen.services.service.FavoriteListImportException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavoriteListImportFromLdap
extends PollenServiceSupport
implements FavoriteListImport {
    private static final Logger log = LoggerFactory.getLogger(FavoriteListImportFromLdap.class);
    protected String ldap;

    public void setLdap(String ldap) {
        this.ldap = ldap;
    }

    @Override
    public void doImport(FavoriteList favoriteList, List<FavoriteListMember> existingFavoriteListMembers) throws FavoriteListImportException {
        this.checkIsConnected();
        this.checkNotNull(favoriteList);
        this.checkNotNull(existingFavoriteListMembers);
        this.checkNotNull(this.ldap);
        Locale locale = this.serviceContext.getLocale();
        HashSet usedName = Sets.newHashSet();
        HashSet usedEmail = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(existingFavoriteListMembers)) {
            for (FavoriteListMember member : existingFavoriteListMembers) {
                usedName.add(member.getName());
                usedEmail.add(member.getEmail());
            }
        }
        LinkedList errors = Lists.newLinkedList();
        LinkedList membersToAdd = Lists.newLinkedList();
        Properties env = new Properties();
        Pattern loginLdapPattern = Pattern.compile("ldaps?://(([^:]+):([^@]+)@)?.*");
        Matcher matcher = loginLdapPattern.matcher(this.ldap);
        if (matcher.find() && matcher.group(1) != null) {
            env.put("java.naming.security.authentication", "simple");
            if (matcher.group(2) != null) {
                String login = URLDecoder.decode(matcher.group(2), StandardCharsets.UTF_8);
                env.put("java.naming.security.principal", "cn=" + login);
            }
            if (matcher.group(3) != null) {
                String password = URLDecoder.decode(matcher.group(3), StandardCharsets.UTF_8);
                env.put("java.naming.security.credentials", password);
            }
            this.ldap = this.ldap.replace(matcher.group(1), "");
        }
        if (CollectionUtils.isEmpty((Collection)errors)) {
            try {
                InitialDirContext ictx = new InitialDirContext(env);
                SearchControls control = new SearchControls();
                control.setSearchScope(2);
                NamingEnumeration<SearchResult> e = ictx.search(this.ldap, null, control);
                while (e.hasMore()) {
                    String email;
                    SearchResult r = e.next();
                    Attribute attrName = r.getAttributes().get("cn");
                    Attribute attrEmail = r.getAttributes().get("mail");
                    if (attrName == null || attrEmail == null) continue;
                    boolean error = false;
                    String memberName = attrName.get().toString().trim();
                    if (!usedName.add(memberName)) {
                        error = true;
                        errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.ldap.already.used.name", (Object[])new Object[]{memberName}));
                    }
                    if (!usedEmail.add(email = this.getCleanMail(attrEmail.get().toString()))) {
                        error = true;
                        errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.ldap.already.used.email", (Object[])new Object[]{email}));
                    }
                    if (!StringUtil.isEmail((String)email)) {
                        error = true;
                        errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.ldap.invalid.email", (Object[])new Object[]{email}));
                    }
                    if (error) continue;
                    FavoriteListMember member = new FavoriteListMember();
                    member.setName(memberName);
                    member.setEmail(email);
                    member.setWeight(1.0);
                    member.setFavoriteList(favoriteList);
                    membersToAdd.add(member);
                }
            }
            catch (NamingException ex) {
                errors.add(I18n.l((Locale)locale, (String)"pollen.error.favoriteList.import.ldap.server", (Object[])new Object[]{ex.getMessage()}));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)errors)) {
            throw new FavoriteListImportException(errors);
        }
        for (FavoriteListMember member : membersToAdd) {
            this.getFavoriteListMemberDao().create((PollenEntity)member);
            if (!log.isDebugEnabled()) continue;
            log.debug(String.format("imported member %s / %s", member.getName(), member.getEmail()));
        }
        this.commit();
    }
}

