/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PollDAOAbstract<E extends Poll> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Poll.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.Poll;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<VotingList> list = getContext()
                                                    .getDAO(VotingList.class)
                                                    .findAllByProperties(VotingList.PROPERTY_POLL, entity);
                                            for (VotingList item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPoll())) {
                                                    item.setPoll(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(String pollId) throws TopiaException {
        return findByProperties(Poll.PROPERTY_POLL_ID, pollId);
    }

    public boolean existByNaturalId(String pollId) throws TopiaException {
        return existByProperties(Poll.PROPERTY_POLL_ID, pollId);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param pollId 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String pollId) throws TopiaException {
        return create(Poll.PROPERTY_POLL_ID, pollId);
    }

    public E createByNaturalId(String pollId) throws TopiaException {
        return create(Poll.PROPERTY_POLL_ID, pollId);
    }

    public E createByNotNull(String pollId) throws TopiaException {
        return create(Poll.PROPERTY_POLL_ID, pollId);
    }

    public E findByPollId(String v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_POLL_ID, v);
        return result;
    }

    public List<E> findAllByPollId(String v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_POLL_ID, v);
        return result;
    }

    public E findByTitle(String v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_TITLE, v);
        return result;
    }

    public List<E> findAllByTitle(String v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_TITLE, v);
        return result;
    }

    public E findByDescription(String v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_DESCRIPTION, v);
        return result;
    }

    public List<E> findAllByDescription(String v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_DESCRIPTION, v);
        return result;
    }

    public E findByBeginChoiceDate(Date v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_BEGIN_CHOICE_DATE, v);
        return result;
    }

    public List<E> findAllByBeginChoiceDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_BEGIN_CHOICE_DATE, v);
        return result;
    }

    public E findByBeginDate(Date v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_BEGIN_DATE, v);
        return result;
    }

    public List<E> findAllByBeginDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_BEGIN_DATE, v);
        return result;
    }

    public E findByEndDate(Date v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_END_DATE, v);
        return result;
    }

    public List<E> findAllByEndDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_END_DATE, v);
        return result;
    }

    public E findByMaxChoiceNb(int v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_MAX_CHOICE_NB, v);
        return result;
    }

    public List<E> findAllByMaxChoiceNb(int v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_MAX_CHOICE_NB, v);
        return result;
    }

    public E findByClosed(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CLOSED, v);
        return result;
    }

    public List<E> findAllByClosed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CLOSED, v);
        return result;
    }

    public E findByChoiceAddAllowed(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CHOICE_ADD_ALLOWED, v);
        return result;
    }

    public List<E> findAllByChoiceAddAllowed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CHOICE_ADD_ALLOWED, v);
        return result;
    }

    public E findByAnonymousVoteAllowed(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_ANONYMOUS_VOTE_ALLOWED, v);
        return result;
    }

    public List<E> findAllByAnonymousVoteAllowed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_ANONYMOUS_VOTE_ALLOWED, v);
        return result;
    }

    public E findByAnonymous(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_ANONYMOUS, v);
        return result;
    }

    public List<E> findAllByAnonymous(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_ANONYMOUS, v);
        return result;
    }

    public E findByPublicResults(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_PUBLIC_RESULTS, v);
        return result;
    }

    public List<E> findAllByPublicResults(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_PUBLIC_RESULTS, v);
        return result;
    }

    public E findByContinuousResults(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CONTINUOUS_RESULTS, v);
        return result;
    }

    public List<E> findAllByContinuousResults(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CONTINUOUS_RESULTS, v);
        return result;
    }

    public E findByEndChoiceDate(Date v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_END_CHOICE_DATE, v);
        return result;
    }

    public List<E> findAllByEndChoiceDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_END_CHOICE_DATE, v);
        return result;
    }

    public E findByResultUptodate(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_RESULT_UPTODATE, v);
        return result;
    }

    public List<E> findAllByResultUptodate(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_RESULT_UPTODATE, v);
        return result;
    }

    public E findContainsVote(Vote v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_VOTE, v);
        return result;
    }

    public List<E> findAllContainsVote(Vote v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_VOTE, v);
        return result;
    }

    public E findContainsChoice(Choice v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_CHOICE, v);
        return result;
    }

    public List<E> findAllContainsChoice(Choice v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_CHOICE, v);
        return result;
    }

    public E findContainsResult(Result v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_RESULT, v);
        return result;
    }

    public List<E> findAllContainsResult(Result v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_RESULT, v);
        return result;
    }

    public E findByCreator(PollAccount v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CREATOR, v);
        return result;
    }

    public List<E> findAllByCreator(PollAccount v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CREATOR, v);
        return result;
    }

    public E findContainsComment(Comment v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllContainsComment(Comment v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_COMMENT, v);
        return result;
    }

    public E findContainsPreventRule(PreventRule v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_PREVENT_RULE, v);
        return result;
    }

    public List<E> findAllContainsPreventRule(PreventRule v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_PREVENT_RULE, v);
        return result;
    }

    public E findContainsVotingList(VotingList v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_VOTING_LIST, v);
        return result;
    }

    public List<E> findAllContainsVotingList(VotingList v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_VOTING_LIST, v);
        return result;
    }

    public E findByPollType(PollType v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_POLL_TYPE, v);
        return result;
    }

    public List<E> findAllByPollType(PollType v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_POLL_TYPE, v);
        return result;
    }

    public E findByChoiceType(ChoiceType v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CHOICE_TYPE, v);
        return result;
    }

    public List<E> findAllByChoiceType(ChoiceType v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CHOICE_TYPE, v);
        return result;
    }

    public E findByVoteCountingType(VoteCountingType v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_VOTE_COUNTING_TYPE, v);
        return result;
    }

    public List<E> findAllByVoteCountingType(VoteCountingType v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_VOTE_COUNTING_TYPE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == VotingList.class) {
            VotingListDAO dao = (VotingListDAO)
                getContext().getDAO(VotingList.class);
            tmp = dao.findAllByPoll(entity);
            result.addAll(tmp);
        }

        if (type == PollAccount.class) {
            PollAccountDAO dao = (PollAccountDAO)
                getContext().getDAO(PollAccount.class);
            tmp = dao.findAllContainsPollsCreated(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(VotingList.class, entity);
        if (!list.isEmpty()) {
            result.put(VotingList.class, list);
        }

        list = findUsages(PollAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(PollAccount.class, list);
        }

        return result;
    }

} //PollDAOAbstract<E extends Poll>
