/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.entities.migration;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.entities.migration.PollenMigrationCallback;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaSQLQuery;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;

public class PollenMigrationCallbackV1_3
extends TopiaMigrationCallbackByClass.MigrationCallBackForVersion {
    public static final String UPDATE_PRIMITIVE_TO_DEFAULT_VALUE = "UPDATE %1$s SET %2$s = %3$s where %2$s IS NULL;";
    public static final String ADD_PRIMITIVE_NOT_NULL_CONSTRAINST = "ALTER TABLE %s ALTER COLUMN %s SET NOT NULL;";
    public static final String ADD_PRIMITIVE_DEFAULT_VALUE = "ALTER TABLE %s ALTER COLUMN %s SET DEFAULT %s;";
    public static final Function<Pair<String, String>, String> PAIR_TO_VALUE = new Function<Pair<String, String>, String>(){

        public String apply(Pair<String, String> input) {
            return (String)input.getValue();
        }
    };

    public PollenMigrationCallbackV1_3(TopiaMigrationCallbackByClass callBack) {
        super(PollenMigrationCallback.V_1_3, callBack);
    }

    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {
        this.migrateChoiceTypes(tx, queries);
        this.migratePollTypes(tx, queries);
        this.migrateVoteCountingTypes(tx, queries);
        this.migrateToPrimitiveTypes(queries);
        this.addForeignKeyIndexes(queries);
        this.addCommentAuthorColumn(queries);
    }

    private void addCommentAuthorColumn(List<String> queries) {
        queries.add("ALTER TABLE comment ADD COLUMN author VARCHAR(255);");
        queries.add("UPDATE comment AS c SET author = (SELECT p.votingId FROM pollAccount p WHERE c.pollAccount = p.topiaId);");
        queries.add("ALTER TABLE comment ALTER COLUMN author TYPE VARCHAR(255);");
        queries.add("UPDATE comment  SET author = 'anonymous'  WHERE author IS NULL;");
        queries.add("ALTER TABLE comment ALTER COLUMN author SET NOT NULL;");
    }

    private void addForeignKeyIndexes(List<String> queries) {
        queries.add("CREATE INDEX idx_PollAccount_pollsCreated ON poll(creator);");
        queries.add("CREATE INDEX idx_PollAccount_comment ON comment(pollAccount);");
        queries.add("CREATE INDEX idx_PollAccount_vote ON vote(pollAccount);");
        queries.add("CREATE INDEX idx_Poll_vote ON vote(poll);");
        queries.add("CREATE INDEX idx_Poll_choice ON choice(poll);");
        queries.add("CREATE INDEX idx_Poll_result ON result(poll);");
        queries.add("CREATE INDEX idx_Poll_comment ON comment(poll);");
        queries.add("CREATE INDEX idx_Poll_preventRule ON preventRule(poll);");
        queries.add("CREATE INDEX idx_Poll_votingList ON votingList(poll);");
        queries.add("CREATE INDEX idx_UserAccount_favoriteList ON personList(owner);");
        queries.add("CREATE INDEX idx_UserAccount_pollAccount ON pollAccount(userAccount);");
        queries.add("CREATE INDEX idx_PersonList_pollAccount ON pollAccount(personList);");
    }

    private void migrateToPrimitiveTypes(List<String> queries) throws TopiaException {
        this.migrateBoolean(queries, "useraccount", "administrator");
        this.migrateBoolean(queries, "choice", "validate");
        this.migrateBoolean(queries, "personToList", "hasVoted");
        this.migrateBoolean(queries, "poll", "closed");
        this.migrateBoolean(queries, "poll", "choiceAddAllowed");
        this.migrateBoolean(queries, "poll", "anonymousVoteAllowed");
        this.migrateBoolean(queries, "poll", "anonymous");
        this.migrateBoolean(queries, "poll", "publicResults");
        this.migrateBoolean(queries, "poll", "continuousResults");
        this.migrateBoolean(queries, "preventRule", "repeated");
        this.migrateBoolean(queries, "preventRule", "active");
        this.migrateBoolean(queries, "preventRule", "oneTime");
        this.migrateBoolean(queries, "result", "byGroup");
        this.migrateBoolean(queries, "vote", "anonymous");
        this.migrateNumber(queries, "poll", "maxChoiceNb");
        this.migrateNumber(queries, "preventRule", "sensibility");
        this.migrateNumber(queries, "PersonToList", "weight");
        this.migrateNumber(queries, "VotingList", "weight");
        this.migrateNumber(queries, "Vote", "weight");
    }

    private void migrateBoolean(List<String> queries, String tableName, String field) {
        Boolean defaultValue = false;
        queries.add(String.format(UPDATE_PRIMITIVE_TO_DEFAULT_VALUE, tableName, field, defaultValue));
        queries.add(String.format(ADD_PRIMITIVE_NOT_NULL_CONSTRAINST, tableName, field));
        queries.add(String.format(ADD_PRIMITIVE_DEFAULT_VALUE, tableName, field, defaultValue));
    }

    private void migrateNumber(List<String> queries, String tableName, String field) {
        Integer defaultValue = 0;
        queries.add(String.format(UPDATE_PRIMITIVE_TO_DEFAULT_VALUE, tableName, field, defaultValue));
        queries.add(String.format(ADD_PRIMITIVE_NOT_NULL_CONSTRAINST, tableName, field));
        queries.add(String.format(ADD_PRIMITIVE_DEFAULT_VALUE, tableName, field, defaultValue));
    }

    private void migrateChoiceTypes(TopiaContextImplementor tx, List<String> queries) throws TopiaException {
        Map mapping = this.getMapping(tx, "choicetype", (Enum[])ChoiceType.values());
        this.replaceColumn(tx, "poll", "fk3497bf5b0b3601", "choicetype", "choicetype", mapping, queries);
        queries.add("DROP TABLE choicetype;");
    }

    private void migratePollTypes(TopiaContextImplementor tx, List<String> queries) throws TopiaException {
        Map mapping = this.getMapping(tx, "polltype", (Enum[])PollType.values());
        this.replaceColumn(tx, "poll", "fk3497bf978bfd", "polltype", "polltype", mapping, queries);
        queries.add("DROP TABLE polltype;");
    }

    private void migrateVoteCountingTypes(TopiaContextImplementor tx, List<String> queries) throws TopiaException {
        Map mapping = this.getMapping(tx, "votecounting", (Enum[])VoteCountingType.values());
        this.replaceColumn(tx, "poll", "fk3497bf7d358045", "votecounting", "votecountingtype", mapping, queries);
        this.replaceColumn(tx, "result", "fkc84dc81d7d358045", "votecounting", "votecountingtype", mapping, queries);
        queries.add("DROP TABLE votecounting;");
    }

    private <E extends Enum<E>> Map<String, Integer> getMapping(TopiaContextImplementor tx, String tableName, E ... enums) throws TopiaException {
        List entitiesFromDb = new TopiaIdSQLQueryToPair("select topiaId, name from " + tableName).findMultipleResult(tx);
        ImmutableMap entityByTopiaIdAndName = Maps.uniqueIndex((Iterable)entitiesFromDb, PAIR_TO_VALUE);
        HashMap result = Maps.newHashMap();
        for (E choiceType : enums) {
            String name = ((Enum)choiceType).name();
            Pair choiceTypePair = (Pair)entityByTopiaIdAndName.get(name);
            if (choiceTypePair == null) {
                throw new PollenTechnicalException("Could not find in db to migrate choicetype with name " + name);
            }
            String id = (String)choiceTypePair.getKey();
            result.put(id, ((Enum)choiceType).ordinal());
        }
        return result;
    }

    private void replaceColumn(TopiaContextImplementor tx, String tableName, String fk, String oldColumn, String newColum, Map<String, Integer> mapping, List<String> queries) throws TopiaException {
        List rowsToReplace = new TopiaIdSQLQueryToPair("select topiaId, " + oldColumn + " from " + tableName).findMultipleResult(tx);
        queries.add("ALTER TABLE " + tableName + " DROP CONSTRAINT " + fk + ";");
        queries.add("ALTER TABLE " + tableName + " DROP COLUMN " + oldColumn + ";");
        queries.add("ALTER TABLE " + tableName + " ADD COLUMN " + newColum + " INT NOT NULL DEFAULT 0;");
        queries.add("ALTER TABLE " + tableName + " ALTER COLUMN " + newColum + " DROP NOT NULL;");
        String updateRequest = "update " + tableName + " set " + newColum + " = %s where topiaid = '%s';";
        for (Pair pollByChoice : rowsToReplace) {
            String tableRowId = (String)pollByChoice.getKey();
            String typeId = (String)pollByChoice.getValue();
            Integer ordinalValue = mapping.get(typeId);
            if (ordinalValue == null) {
                ordinalValue = 0;
            }
            String query = String.format(updateRequest, ordinalValue, tableRowId);
            queries.add(query);
        }
    }

    private static class TopiaIdSQLQueryToPair
    extends TopiaSQLQuery<Pair<String, String>> {
        protected final String request;

        private TopiaIdSQLQueryToPair(String request) {
            this.request = request;
        }

        protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
            PreparedStatement prepareStatement = connection.prepareStatement(this.request);
            return prepareStatement;
        }

        protected Pair<String, String> prepareResult(ResultSet set) throws SQLException {
            Pair result = Pair.of((Object)set.getString(1), (Object)set.getString(2));
            return result;
        }
    }
}

