/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAO;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class UserAccountDAOAbstract<E extends UserAccount>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return UserAccount.class;
    }

    public PollenDAOHelper.PollenEntityEnum getTopiaEntityEnum() {
        return PollenDAOHelper.PollenEntityEnum.UserAccount;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getDAO(PersonList.class).findAllByProperties("owner", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getOwner())) continue;
            item.setOwner(null);
        }
        list = this.getContext().getDAO(PollAccount.class).findAllByProperties("userAccount", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getUserAccount())) continue;
            item.setUserAccount(null);
        }
        super.delete(entity);
    }

    public E findByLogin(String v) throws TopiaException {
        UserAccount result = (UserAccount)this.findByProperty("login", v);
        return (E)result;
    }

    public List<E> findAllByLogin(String v) throws TopiaException {
        List result = this.findAllByProperty("login", v);
        return result;
    }

    public E findByPassword(String v) throws TopiaException {
        UserAccount result = (UserAccount)this.findByProperty("password", v);
        return (E)result;
    }

    public List<E> findAllByPassword(String v) throws TopiaException {
        List result = this.findAllByProperty("password", v);
        return result;
    }

    public E findByFirstName(String v) throws TopiaException {
        UserAccount result = (UserAccount)this.findByProperty("firstName", v);
        return (E)result;
    }

    public List<E> findAllByFirstName(String v) throws TopiaException {
        List result = this.findAllByProperty("firstName", v);
        return result;
    }

    public E findByLastName(String v) throws TopiaException {
        UserAccount result = (UserAccount)this.findByProperty("lastName", v);
        return (E)result;
    }

    public List<E> findAllByLastName(String v) throws TopiaException {
        List result = this.findAllByProperty("lastName", v);
        return result;
    }

    public E findByAdministrator(boolean v) throws TopiaException {
        UserAccount result = (UserAccount)this.findByProperty("administrator", v);
        return (E)result;
    }

    public List<E> findAllByAdministrator(boolean v) throws TopiaException {
        List result = this.findAllByProperty("administrator", v);
        return result;
    }

    public E findByLanguage(String v) throws TopiaException {
        UserAccount result = (UserAccount)this.findByProperty("language", v);
        return (E)result;
    }

    public List<E> findAllByLanguage(String v) throws TopiaException {
        List result = this.findAllByProperty("language", v);
        return result;
    }

    public E findByEmail(String v) throws TopiaException {
        UserAccount result = (UserAccount)this.findByProperty("email", v);
        return (E)result;
    }

    public List<E> findAllByEmail(String v) throws TopiaException {
        List result = this.findAllByProperty("email", v);
        return result;
    }

    public E findContainsFavoriteList(PersonList v) throws TopiaException {
        UserAccount result = (UserAccount)this.findContains("favoriteList", v);
        return (E)result;
    }

    public List<E> findAllContainsFavoriteList(PersonList v) throws TopiaException {
        List result = this.findAllContains("favoriteList", v);
        return result;
    }

    public E findContainsPollAccount(PollAccount v) throws TopiaException {
        UserAccount result = (UserAccount)this.findContains("pollAccount", v);
        return (E)result;
    }

    public List<E> findAllContainsPollAccount(PollAccount v) throws TopiaException {
        List result = this.findAllContains("pollAccount", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List tmp;
        TopiaDAOImpl dao;
        ArrayList result = new ArrayList();
        if (type == PollAccount.class) {
            dao = (PollAccountDAO)this.getContext().getDAO(PollAccount.class);
            tmp = dao.findAllByUserAccount((UserAccount)entity);
            result.addAll(tmp);
        }
        if (type == PersonList.class) {
            dao = (PersonListDAO)this.getContext().getDAO(PersonList.class);
            tmp = dao.findAllByOwner((UserAccount)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        List<Object> list = this.findUsages(PollAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(PollAccount.class, list);
        }
        if (!(list = this.findUsages(PersonList.class, entity)).isEmpty()) {
            result.put(PersonList.class, list);
        }
        return result;
    }
}

