package org.chorem.pollen.business.persistence;

import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public interface Vote extends TopiaEntity {

    String PROPERTY_WEIGHT = "weight";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_ANONYMOUS = "anonymous";

    String PROPERTY_CHOICE_VOTE_TO_CHOICE = "choiceVoteToChoice";

    String PROPERTY_POLL = "poll";

    String PROPERTY_POLL_ACCOUNT = "pollAccount";

    String PROPERTY_VOTING_LIST = "votingList";

    void setWeight(double weight);

    double getWeight();

    void setComment(String comment);

    String getComment();

    void setAnonymous(boolean anonymous);

    boolean isAnonymous();

    void addChoiceVoteToChoice(VoteToChoice choiceVoteToChoice);

    void addAllChoiceVoteToChoice(List<VoteToChoice> choiceVoteToChoice);

    void setChoiceVoteToChoice(List<VoteToChoice> choiceVoteToChoice);

    void removeChoiceVoteToChoice(VoteToChoice choiceVoteToChoice);

    void clearChoiceVoteToChoice();

    List<VoteToChoice> getChoiceVoteToChoice();

    VoteToChoice getChoiceVoteToChoiceByTopiaId(String topiaId);

    VoteToChoice getChoiceVoteToChoice(Choice choice);

    int sizeChoiceVoteToChoice();

    boolean isChoiceVoteToChoiceEmpty();

    void setPoll(Poll poll);

    Poll getPoll();

    void setPollAccount(PollAccount pollAccount);

    PollAccount getPollAccount();

    void setVotingList(VotingList votingList);

    VotingList getVotingList();

} //Vote
