/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataPollAccountConverter;
import org.chorem.pollen.business.converters.DataVoteConverter;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.VoteDTO;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.services.ServiceVote;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;

public class ServiceVoteImpl
implements ServiceVote {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private VoteDAO voteDAO = null;
    private DataVoteConverter converter = new DataVoteConverter();
    private static final Log log = LogFactory.getLog(ServiceVoteImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createVote(VoteDTO voteDTO, PollAccountDTO pollAccountDTO) {
        TopiaContext transaction = null;
        String topiaId = null;
        try {
            transaction = this.rootContext.beginTransaction();
            if (pollAccountDTO != null) {
                pollAccountDTO.setHasVoted(true);
                PollAccountDAO pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
                PollAccount pollAccountEntity = (PollAccount)pollAccountDAO.findByTopiaId(pollAccountDTO.getId());
                if (pollAccountEntity == null) {
                    log.debug((Object)"Nouveau compte associ\u00e9 au vote");
                    pollAccountEntity = (PollAccount)pollAccountDAO.create(new Object[0]);
                } else {
                    log.debug((Object)("Compte associ\u00e9 au vote : " + pollAccountEntity.getTopiaId()));
                }
                DataPollAccountConverter pollAccountConverter = new DataPollAccountConverter();
                pollAccountConverter.setTransaction(transaction);
                pollAccountConverter.populatePollAccountEntity(pollAccountDTO, pollAccountEntity);
                pollAccountDAO.update(pollAccountEntity);
                voteDTO.setPollAccountId(pollAccountEntity.getTopiaId());
                voteDTO.setVotingListId(pollAccountDTO.getVotingListId());
                voteDTO.setWeight(pollAccountDTO.getWeight());
                log.debug((Object)("Poids du vote : " + voteDTO.getWeight()));
            } else {
                voteDTO.setPollAccountId(null);
            }
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            Vote voteEntity = (Vote)this.voteDAO.create(new Object[0]);
            this.converter.setTransaction(transaction);
            this.converter.populateVoteEntity(voteDTO, voteEntity);
            transaction.commitTransaction();
            this.converter.populateChoiceVote(voteDTO, voteEntity);
            topiaId = voteEntity.getTopiaId();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            String string = topiaId;
            return string;
        }
        catch (Exception eee) {
            ContextUtil.doCatch(eee, transaction, "Problem when creating vote with pollAccount");
            String string = null;
            return string;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateVote(VoteDTO voteDTO) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            Vote voteEntity = (Vote)this.voteDAO.findByTopiaId(voteDTO.getId());
            this.converter.setTransaction(transaction);
            this.converter.populateVoteEntity(voteDTO, voteEntity);
            voteEntity.update();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + voteDTO.getId()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteVote(String voteId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            Vote voteEntity = (Vote)this.voteDAO.findByTopiaId(voteId);
            voteEntity.delete();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + voteId));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VoteDTO> getVotesByPoll(PollDTO poll, int startIndex, int endIndex) {
        List<VoteDTO> results;
        TopiaContext transaction;
        block7: {
            transaction = null;
            results = new ArrayList<VoteDTO>();
            if (!poll.isAnonymous()) break block7;
            ArrayList<VoteDTO> arrayList = results;
            ContextUtil.doFinally(transaction);
            return arrayList;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load votes for poll with uid = " + poll.getPollId()));
                log.debug((Object)("LIMIT : startIndex = " + startIndex + " _ " + "endIndex = " + endIndex));
            }
            transaction = this.rootContext.beginTransaction();
            List votes = transaction.find("FROM " + Vote.class.getName() + " WHERE poll.pollId = :pollUId" + " ORDER BY topiaCreateDate", startIndex, endIndex, new Object[]{"pollUId", poll.getPollId()});
            if (log.isDebugEnabled()) {
                log.debug((Object)("Nb votes found : " + votes.size()));
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createVoteDTOs(votes);
        }
        catch (Exception eee) {
            try {
                ContextUtil.doCatch(eee, transaction, "Unable to load votes from poll with uid = " + poll.getPollId());
            }
            catch (Throwable throwable) {
                ContextUtil.doFinally(transaction);
                throw throwable;
            }
            ContextUtil.doFinally(transaction);
        }
        ContextUtil.doFinally(transaction);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAlreadyVoted(String votingId, PollDTO poll) {
        TopiaContext transaction = null;
        boolean result = false;
        try {
            transaction = this.rootContext.beginTransaction();
            List tmp = transaction.find("SELECT COUNT(*) FROM " + Vote.class.getName() + " WHERE poll.pollId = :pollUId" + " AND pollAccount.votingId = :votingId", new Object[]{"pollUId", poll.getPollId(), "votingId", votingId});
            int count = ((Long)tmp.get(0)).intValue();
            result = count > 0;
        }
        catch (Exception eee) {
            ContextUtil.doCatch(eee, transaction, "Unable test vote existing for account with votingId = " + votingId + " and poll with uid = " + poll.getPollId());
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VoteDTO> selectVotes(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<VoteDTO> results = null;
        List voteEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.voteDAO = PollenModelDAOHelper.getVoteDAO(transaction);
            if (properties == null) {
                voteEntities = this.voteDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les votes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                voteEntities = this.voteDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createVoteDTOs(voteEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<VoteDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<VoteDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }
}

