/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Account;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Entry;
import org.chorem.callao.entity.EntryDAO;
import org.chorem.callao.entity.Journal;
import org.chorem.callao.entity.TimeSpan;
import org.chorem.callao.entity.Transaction;
import org.chorem.callao.entity.TransactionDAO;
import org.chorem.callao.service.EntryServiceImpl;
import org.chorem.callao.service.JournalServiceImpl;
import org.chorem.callao.service.LogServiceImpl;
import org.chorem.callao.service.TimeSpanServiceImpl;
import org.chorem.callao.service.convertObject.ConvertTransaction;
import org.chorem.callao.service.dto.EntryDTO;
import org.chorem.callao.service.dto.LogDTO;
import org.chorem.callao.service.dto.TransactionDTO;
import org.chorem.callao.service.utils.ContextCallao;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class TransactionServiceImpl {
    private static final Log log = LogFactory.getLog(TransactionServiceImpl.class);
    private TopiaContext rootContext = ContextCallao.getInstance().getContext();
    private LogServiceImpl logServiceImpl = new LogServiceImpl();
    private ConvertTransaction convertTransaction = new ConvertTransaction();
    private EntryServiceImpl entryServiceImpl = new EntryServiceImpl();
    private TimeSpanServiceImpl timeSpanServiceImpl = new TimeSpanServiceImpl();

    public String createTransaction(Date entryDate, String voucherRef, String description, TimeSpan timeSpan, Journal journal) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
            String isCorrectTransaction = this.isCorrectTransaction(timeSpan, journal);
            if (isCorrectTransaction.equals("success")) {
                Transaction newtransaction = (Transaction)transactionDAO.create(new Object[0]);
                newtransaction.setTransDate(entryDate);
                newtransaction.setVoucherRef(voucherRef);
                newtransaction.setDescription(description);
                newtransaction.setTimeSpan(timeSpan);
                newtransaction.setJournal(journal);
                topiaContext.commitTransaction();
                if (log.isInfoEnabled()) {
                    log.info((Object)"Ajout avec succes de la transaction");
                }
                result = newtransaction.getTopiaId();
            } else {
                result = isCorrectTransaction;
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String createTransaction(TransactionDTO transactionDTO) {
        String result = "error";
        if (transactionDTO.getJournalDTO() == null || transactionDTO.getTimeSpanDTO() == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"L'objet transactionDTO ne poss\u00e8de pas de timeSpan ET/OU de journal.");
            }
            result = "transaction_not_journal";
        } else {
            JournalServiceImpl journalServiceImpl = new JournalServiceImpl();
            Journal journal = journalServiceImpl.searchJournalWithLabel(transactionDTO.getJournalDTO().getLabel());
            TimeSpan timeSpan = this.timeSpanServiceImpl.searchTimeSpanByDate(transactionDTO.getTimeSpanDTO().getBeginTimeSpan());
            if (journal == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cr\u00e9ation transaction : Le journal " + transactionDTO.getJournalDTO().getLabel() + " n'existe pas."));
                }
                result = "transaction_not_journal";
            } else if (timeSpan == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cr\u00e9ation transaction : Le timeSpan " + transactionDTO.getTimeSpanDTO().toString() + " n'existe pas."));
                }
                result = "transaction_not_timespan";
            } else {
                result = this.createTransaction(transactionDTO.getEntryDate(), transactionDTO.getVoucherRef(), transactionDTO.getDescription(), timeSpan, journal);
            }
        }
        return result;
    }

    public String modifyTransaction(String topiaId, Date entryDate, String voucherRef, String description, TimeSpan timeSpan, Journal journal) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
            Transaction transaction = (Transaction)transactionDAO.findByTopiaId(topiaId);
            if (transaction == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("La transaction " + voucherRef + " n'existe pas. (identifiant " + topiaId + ")"));
                }
                result = "transaction_not_exist";
            } else {
                String correct = this.isCorrectTransaction(timeSpan, journal);
                if (correct.equals("success")) {
                    transaction.setTransDate(entryDate);
                    transaction.setVoucherRef(voucherRef);
                    transaction.setDescription(description);
                    transaction.setTimeSpan(timeSpan);
                    transaction.setJournal(journal);
                    transaction.update();
                    topiaContext.commitTransaction();
                    result = "success";
                }
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String modifyTransaction(TransactionDTO transactionDTO) {
        JournalServiceImpl journalServiceImpl = new JournalServiceImpl();
        Journal journal = journalServiceImpl.searchJournalWithLabel(transactionDTO.getJournalDTO().getLabel());
        TimeSpan timeSpan = this.timeSpanServiceImpl.searchTimeSpanByDate(transactionDTO.getTimeSpanDTO().getBeginTimeSpan());
        String result = this.modifyTransaction(transactionDTO.getId(), transactionDTO.getEntryDate(), transactionDTO.getVoucherRef(), transactionDTO.getDescription(), timeSpan, journal);
        return result;
    }

    public Transaction searchTransactionWithTopiaId(String topiaId) {
        Transaction transaction = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
            transaction = (Transaction)transactionDAO.findByTopiaId(topiaId);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return transaction;
    }

    public Transaction searchTransactionWithTopiaId(TransactionDTO transactionDTO) {
        Transaction transaction = this.searchTransactionWithTopiaId(transactionDTO.getId());
        return transaction;
    }

    public TransactionDTO searchTransactionDTO(String topiaId) {
        TransactionDTO transactionDTO = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
            Transaction transaction = (Transaction)transactionDAO.findByTopiaId(topiaId);
            this.convertTransaction.setTransaction(this.rootContext);
            transactionDTO = this.convertTransaction.transactionEntityToDto(transaction);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return transactionDTO;
    }

    public List<Transaction> searchListTransactionWithTimeSpan(TimeSpan timeSpan) {
        List listTransaction = null;
        if (timeSpan != null) {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
                listTransaction = transactionDAO.findAllByTimeSpan(timeSpan);
                topiaContext.closeContext();
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return listTransaction;
    }

    public List<TransactionDTO> searchListTransactionDTOWithTimeSpan(TimeSpan timeSpan) {
        ArrayList<TransactionDTO> listTransactionDTO = new ArrayList<TransactionDTO>();
        if (timeSpan != null) {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
                List listTransaction = transactionDAO.findAllByTimeSpan(timeSpan);
                this.convertTransaction.setTransaction(this.rootContext);
                for (Transaction transaction : listTransaction) {
                    TransactionDTO transactionDTO = this.convertTransaction.transactionEntityToDto(transaction);
                    listTransactionDTO.add(transactionDTO);
                }
                topiaContext.closeContext();
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return listTransactionDTO;
    }

    public List<Transaction> searchListTransactionWithJournal(Journal journal) {
        List listTransaction = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
            listTransaction = transactionDAO.findAllByJournal(journal);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listTransaction;
    }

    public List<TransactionDTO> getAllTransactionDTO() {
        ArrayList<TransactionDTO> listTransactionDTO = new ArrayList<TransactionDTO>();
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
            List listTransaction = transactionDAO.findAll();
            this.convertTransaction.setTransaction(this.rootContext);
            for (Transaction transaction : listTransaction) {
                TransactionDTO transactionDTO = this.convertTransaction.transactionEntityToDto(transaction);
                listTransactionDTO.add(transactionDTO);
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listTransactionDTO;
    }

    public String isCorrectTransaction(TimeSpan timeSpan, Journal journal) {
        String result = "success";
        if (journal == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Cr\u00e9ation transaction : Le journal n'existe pas.");
            }
            result = "transaction_not_journal";
        }
        if (timeSpan == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Cr\u00e9ation transaction : Le timeSpan n'existe pas.");
            }
            result = "transaction_not_timespan";
        } else if (timeSpan.getLocked()) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Le timeSpan est bloqu\u00e9 ! Il est donc impossible d'ajouter une transaction sur cette p\u00e9riode. (P\u00e9riode du " + timeSpan + ")"));
            }
            result = "transaction_timespan_blocked";
        }
        return result;
    }

    public String removeTransaction(String topiaId) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
            Transaction transaction = (Transaction)transactionDAO.findByTopiaId(topiaId);
            if (transaction != null) {
                if (!this.isTransactionBlocked(transaction)) {
                    List<Entry> listEntry = this.entryServiceImpl.searchEntryWithTransaction(transaction);
                    for (Entry entry : listEntry) {
                        result = this.removeEntry(entry.getTopiaId());
                    }
                    transactionDAO.delete(transaction);
                    topiaContext.commitTransaction();
                    if (log.isInfoEnabled()) {
                        log.info((Object)"La transaction a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s.");
                    }
                    result = "success";
                } else {
                    result = "transaction_timespan_blocked";
                }
            } else {
                result = "transaction_not_exist";
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String removeTransaction(TransactionDTO transactionDTO) {
        String result = this.removeTransaction(transactionDTO.getId());
        return result;
    }

    public String addEntry(String description, String amount, boolean debit, String lettering, String detail, Transaction transaction, Account account) {
        String result = "error";
        result = !this.isTransactionBlocked(transaction) ? this.entryServiceImpl.createEntry(description, amount, debit, lettering, detail, transaction, account) : "transaction_timespan_blocked";
        return result;
    }

    public String addEntry(EntryDTO entryDTO) {
        String result = "error";
        TransactionDTO transactonDTO = entryDTO.getTransactionDTO();
        Transaction transaction = this.searchTransactionWithTopiaId(transactonDTO);
        result = !this.isTransactionBlocked(transaction) ? this.entryServiceImpl.createEntry(entryDTO) : "transaction_timespan_blocked";
        return result;
    }

    public String modifyEntry(String topiaId, String description, String amount, boolean debit, String lettering, String detail, Transaction transaction, Account account) {
        String result = "error";
        result = !this.isTransactionBlocked(transaction) ? this.entryServiceImpl.modifyEntry(topiaId, description, amount, debit, lettering, detail, account) : "transaction_timespan_blocked";
        return result;
    }

    public String modifyEntry(EntryDTO entryDTO) {
        String result = "error";
        TransactionDTO transactonDTO = entryDTO.getTransactionDTO();
        Transaction transaction = this.searchTransactionWithTopiaId(transactonDTO);
        result = !this.isTransactionBlocked(transaction) ? this.entryServiceImpl.modifyEntry(entryDTO) : "transaction_timespan_blocked";
        return result;
    }

    public String removeEntry(String topiaId) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            EntryDAO entryDAO = CallaoDAOHelper.getEntryDAO((TopiaContext)topiaContext);
            Entry entryDelete = (Entry)entryDAO.findByTopiaId(topiaId);
            if (entryDelete != null) {
                Transaction transaction = entryDelete.getTransaction();
                if (!this.isTransactionBlocked(transaction)) {
                    LogDTO logDTO = new LogDTO("", new Date(), "remove", transaction.getTransDate(), transaction.getVoucherRef(), transaction.getDescription(), entryDelete.getDescription(), entryDelete.getAmount(), entryDelete.getDebit(), entryDelete.getLettering());
                    result = this.entryServiceImpl.removeEntry(topiaId);
                    if (result.equals("success")) {
                        this.logServiceImpl.addLog(logDTO);
                    }
                } else {
                    result = "transaction_timespan_blocked";
                }
            } else {
                result = "entry_not_exist";
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String removeEntry(EntryDTO entryDTO) {
        String result = this.removeEntry(entryDTO.getId());
        return result;
    }

    public boolean isTransactionBlocked(Transaction transaction) {
        boolean isTransactionBlocked = true;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            TransactionDAO transactionDAO = CallaoDAOHelper.getTransactionDAO((TopiaContext)topiaContext);
            Transaction transactionSearch = (Transaction)transactionDAO.findByTopiaId(transaction.getTopiaId());
            isTransactionBlocked = this.timeSpanServiceImpl.isTimeSpanBlocked(transactionSearch.getTimeSpan());
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return isTransactionBlocked;
    }

    public boolean isTransactionBalanced(Transaction transaction) {
        List<EntryDTO> ListEntryDTO = this.entryServiceImpl.searchEntryDTOWithTransaction(transaction);
        float debit = 0.0f;
        float credit = 0.0f;
        for (EntryDTO entryDTO : ListEntryDTO) {
            if (entryDTO.isDebit()) {
                debit += Float.parseFloat(entryDTO.getAmount().replaceFirst(",", "."));
                continue;
            }
            credit += Float.parseFloat(entryDTO.getAmount().replaceFirst(",", "."));
        }
        boolean isTransactionBalanced = debit == credit;
        return isTransactionBalanced;
    }
}

