/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Period;
import org.chorem.callao.entity.PeriodDAO;
import org.chorem.callao.entity.TimeSpan;
import org.chorem.callao.entity.TimeSpanDAO;
import org.chorem.callao.service.TimeSpanServiceImpl;
import org.chorem.callao.service.convertObject.ConvertPeriod;
import org.chorem.callao.service.dto.PeriodDTO;
import org.chorem.callao.service.dto.TimeSpanDTO;
import org.chorem.callao.service.utils.ContextCallao;
import org.chorem.callao.service.utils.DateUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class PeriodServiceImpl {
    private static final Log log = LogFactory.getLog(PeriodServiceImpl.class);
    private TopiaContext rootContext = ContextCallao.getInstance().getContext();
    private TimeSpanServiceImpl timeSpanServiceImpl = new TimeSpanServiceImpl();
    private ConvertPeriod convertPeriod = new ConvertPeriod();
    private DateUtil dateUtil = new DateUtil();

    public String addTimeSpan(Date beginTimeSpan, Date endTimeSpan) {
        return null;
    }

    public String removeTimeSpan(String timespan) {
        return null;
    }

    public String createPeriod(Date beginTimeSpan, Date endTimeSpan, boolean lock) {
        lock = false;
        String result = "error";
        beginTimeSpan = this.dateUtil.InitDateFirstDayMonth(beginTimeSpan);
        endTimeSpan = this.dateUtil.InitDateEndDayMonth(endTimeSpan);
        try {
            boolean correctPeriod = false;
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            PeriodDAO periodDAO = CallaoDAOHelper.getPeriodDAO((TopiaContext)topiaContext);
            Period newPeriod = (Period)periodDAO.create(new Object[0]);
            newPeriod.setBeginPeriod(beginTimeSpan);
            newPeriod.setEndPeriod(endTimeSpan);
            newPeriod.setLocked(lock);
            correctPeriod = this.isCorrectPeriod(newPeriod);
            if (correctPeriod) {
                topiaContext.commitTransaction();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ajout exercice du " + beginTimeSpan.toString() + " au " + endTimeSpan.toString()));
                }
                TimeSpanServiceImpl timeSpanImpl = new TimeSpanServiceImpl();
                boolean stop = false;
                for (int i = 0; i < 12; ++i) {
                    result = timeSpanImpl.createTimeSpan(beginTimeSpan, beginTimeSpan, newPeriod, false);
                    beginTimeSpan.setMonth(beginTimeSpan.getMonth() + 1);
                    if (!result.equals("error")) continue;
                    stop = true;
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Erreur lors de la cr\u00e9ation des 12 timeSpans");
                    }
                    result = "period_create_timespan";
                }
                if (!stop) {
                    result = "success";
                }
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String createPeriod(PeriodDTO periodDTO) {
        String result = this.createPeriod(periodDTO.getBeginPeriod(), periodDTO.getEndPeriod(), false);
        return result;
    }

    private boolean isCorrectPeriod(Period period) {
        int number_months = this.dateUtil.numberOfMonths(period.getBeginPeriod(), period.getEndPeriod());
        boolean result = true;
        if (number_months != 11) {
            if (log.isErrorEnabled()) {
                log.error((Object)("P\u00e9riode du " + period.getBeginPeriod().toString() + " au " + period.getEndPeriod().toString() + "  : Il faut 12 mois entre les deux dates"));
            }
            result = false;
        } else {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                PeriodDAO periodDAO = CallaoDAOHelper.getPeriodDAO((TopiaContext)topiaContext);
                List listePeriod = periodDAO.findAllByLocked(false);
                Date date_search = period.getBeginPeriod();
                Period previousPeriod = periodDAO.findByEndPeriod(this.dateUtil.previousDay(date_search));
                int number_period = periodDAO.findAll().size();
                topiaContext.closeContext();
                if (!listePeriod.isEmpty()) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Il existe au moins une p\u00e9riode pr\u00e9c\u00e9dente non bloqu\u00e9e !");
                    }
                    result = false;
                }
                if (previousPeriod == null && number_period != 0) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Votre p\u00e9riode doit \u00eatre coll\u00e9e aux autres p\u00e9riodes !" + date_search.toString() + "  PPP   " + this.dateUtil.previousDay(date_search).toString()));
                    }
                    result = false;
                }
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String blockPeriod(Period period) {
        String result = "error";
        if (period != null) {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                TimeSpanDAO timeSpanDAO = CallaoDAOHelper.getTimeSpanDAO((TopiaContext)topiaContext);
                List listeTimeSpan = timeSpanDAO.findAllByPeriod(period);
                boolean existTimeSpanNotBlock = false;
                for (TimeSpan timeSpan : listeTimeSpan) {
                    if (timeSpan.getLocked()) continue;
                    existTimeSpanNotBlock = true;
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Le timeSpan du " + timeSpan.getBeginTimeSpan().toString() + " au " + timeSpan.getEndTimeSpan().toString() + " non bloqu\u00e9 !"));
                    }
                    result = "period_timespan_not_block";
                }
                if (!existTimeSpanNotBlock) {
                    period.setLocked(true);
                    PeriodDAO periodDAO = CallaoDAOHelper.getPeriodDAO((TopiaContext)topiaContext);
                    periodDAO.update((TopiaEntity)period);
                    topiaContext.commitTransaction();
                    result = "success";
                    if (log.isInfoEnabled()) {
                        log.info((Object)("P\u00e9riode " + period.getBeginPeriod().toString() + " au " + period.getEndPeriod().toString() + " bloqu\u00e9e avec succ\u00e8s."));
                    }
                }
                topiaContext.closeContext();
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String blockPeriod(PeriodDTO periodDTO) {
        Period period = this.searchPeriodWithDate(periodDTO.getBeginPeriod());
        String result = this.blockPeriod(period);
        return result;
    }

    public String blockAllTimeSpanOfPeriod(Period period) {
        String result = "error";
        if (period == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"La p\u00e9riode ne peut bloquer ses p\u00e9riodes mensuelles, il faut une p\u00e9riode en entr\u00e9e.");
            }
        } else {
            boolean ErrorBlockTimeSpan = false;
            List<TimeSpanDTO> listTimeSpanDTO = this.timeSpanServiceImpl.searchListTimeSpanDTO(period);
            Collections.sort(listTimeSpanDTO);
            for (TimeSpanDTO timeSpanDTO : listTimeSpanDTO) {
                result = this.timeSpanServiceImpl.blockTimeSpan(timeSpanDTO);
                if (!result.equals("error")) continue;
                ErrorBlockTimeSpan = true;
            }
            if (!ErrorBlockTimeSpan) {
                result = "success";
            } else {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Impossible de bloquer tous les timeSpans.");
                }
                result = "period_all_timespan";
            }
        }
        return result;
    }

    public Period searchPeriodWithDate(Date d) {
        Period period = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            PeriodDAO periodDAO = CallaoDAOHelper.getPeriodDAO((TopiaContext)topiaContext);
            List listePeriod = periodDAO.findAll();
            topiaContext.closeContext();
            for (Period periodSearch : listePeriod) {
                boolean periodBetweenDate = this.dateUtil.betweenDate(d, periodSearch.getBeginPeriod(), periodSearch.getEndPeriod());
                if (!periodBetweenDate) continue;
                period = periodSearch;
            }
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return period;
    }

    public PeriodDTO searchPeriodDTOWithDate(Date d) {
        Period period = this.searchPeriodWithDate(d);
        PeriodDTO periodDTO = this.convertPeriod.periodEntityToDto(period);
        return periodDTO;
    }

    public List<PeriodDTO> getAllPeriod() {
        ArrayList<PeriodDTO> listAllPeriodDTO = new ArrayList<PeriodDTO>();
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            PeriodDAO periodDAO = CallaoDAOHelper.getPeriodDAO((TopiaContext)topiaContext);
            List listePeriod = periodDAO.findAll();
            for (Period period : listePeriod) {
                PeriodDTO periodDTO = this.convertPeriod.periodEntityToDto(period);
                listAllPeriodDTO.add(periodDTO);
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listAllPeriodDTO;
    }

    public Period searchPeriodWithTopiaId(String topiaId) {
        Period periodSearch = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            PeriodDAO periodDAO = CallaoDAOHelper.getPeriodDAO((TopiaContext)topiaContext);
            periodSearch = (Period)periodDAO.findByTopiaId(topiaId);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return periodSearch;
    }

    public String removePeriod(String topiaId) {
        String result = "error";
        Period periodDelete = this.searchPeriodWithTopiaId(topiaId);
        if (periodDelete == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("La p\u00e9riode " + topiaId + " n'existe pas !"));
            }
            result = "period_not_exist";
        } else {
            try {
                TimeSpan timeSpan;
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                PeriodDAO periodDAO = CallaoDAOHelper.getPeriodDAO((TopiaContext)topiaContext);
                periodDelete.setLocked(false);
                periodDAO.update((TopiaEntity)periodDelete);
                topiaContext.commitTransaction();
                List<TimeSpanDTO> listTimeSpanDTO = this.timeSpanServiceImpl.searchListTimeSpanDTO(periodDelete);
                Collections.sort(listTimeSpanDTO, Collections.reverseOrder());
                for (TimeSpanDTO timeSpanDTO : listTimeSpanDTO) {
                    timeSpan = this.timeSpanServiceImpl.searchTimeSpanByDate(timeSpanDTO);
                    if (!timeSpanDTO.isLocked()) continue;
                    this.timeSpanServiceImpl.unblockTimeSpan(timeSpan);
                }
                for (TimeSpanDTO timeSpanDTO : listTimeSpanDTO) {
                    timeSpan = this.timeSpanServiceImpl.searchTimeSpanByDate(timeSpanDTO);
                    this.timeSpanServiceImpl.removeTimeSpan(timeSpan);
                }
                periodDAO.delete(periodDelete);
                topiaContext.commitTransaction();
                topiaContext.closeContext();
                result = "success";
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String removePeriod(PeriodDTO periodDTO) {
        String result = this.removePeriod(periodDTO.getId());
        return result;
    }

    public String[] getMethods() {
        return null;
    }

    public void destroy() {
    }

    public void init(TopiaContext arg0) {
    }
}

