/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Log;
import org.chorem.callao.entity.LogDAO;
import org.chorem.callao.service.convertObject.ConvertLog;
import org.chorem.callao.service.dto.LogDTO;
import org.chorem.callao.service.utils.ContextCallao;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class LogServiceImpl {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(LogServiceImpl.class);
    private TopiaContext rootContext = ContextCallao.getInstance().getContext();
    private ConvertLog convertLog = new ConvertLog();

    public String addLog(Date logDate, Date transDate, String type, String voucherRef, String transDesc, String entryDesc, String amount, boolean debit, String lettering) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            LogDAO logDAO = CallaoDAOHelper.getLogDAO((TopiaContext)topiaContext);
            Log newlog = (Log)logDAO.create(new Object[0]);
            newlog.setLogDate(logDate);
            newlog.setTransDate(transDate);
            newlog.setVoucherRef(voucherRef);
            newlog.setType(type);
            newlog.setTransDesc(transDesc);
            newlog.setEntryDesc(entryDesc);
            newlog.setAmount(amount);
            newlog.setDebit(debit);
            newlog.setLettering(lettering);
            topiaContext.commitTransaction();
            topiaContext.closeContext();
            String topiaId = newlog.getTopiaId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Log created: " + topiaId));
            }
            result = "success";
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String addLog(LogDTO logDTO) {
        String result = "error";
        if (logDTO != null) {
            result = this.addLog(logDTO.getLogDate(), logDTO.getTransDate(), logDTO.getType(), logDTO.getVoucherRef(), logDTO.getTransDesc(), logDTO.getEntryDesc(), logDTO.getAmount(), logDTO.isDebit(), logDTO.getLettering());
        }
        return result;
    }

    public List<Log> listeAllLog() {
        List listelog = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            LogDAO logDAO = CallaoDAOHelper.getLogDAO((TopiaContext)topiaContext);
            listelog = logDAO.findAll();
            topiaContext.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)"Search all logs");
            }
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listelog;
    }

    public List<LogDTO> listeAllLogDTO() {
        ArrayList<LogDTO> listLogDTO = new ArrayList<LogDTO>();
        List<Log> listLog = this.listeAllLog();
        for (Log log : listLog) {
            LogDTO logDTO = this.convertLog.logEntityToDto(log);
            listLogDTO.add(logDTO);
        }
        return listLogDTO;
    }

    public List<Log> searchLogWithDateCreate(Date dateCreate) {
        List listelog = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            LogDAO logDAO = CallaoDAOHelper.getLogDAO((TopiaContext)topiaContext);
            listelog = logDAO.findAllByLogDate(dateCreate);
            topiaContext.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Log(s) find : " + listelog.size() + "log(s)"));
            }
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listelog;
    }

    public List<LogDTO> searchLogDTOWithDateCreate(Date dateCreate) {
        ArrayList<LogDTO> listLogDTO = new ArrayList<LogDTO>();
        List<Log> listLog = this.searchLogWithDateCreate(dateCreate);
        for (Log log : listLog) {
            LogDTO logDTO = this.convertLog.logEntityToDto(log);
            listLogDTO.add(logDTO);
        }
        return listLogDTO;
    }

    public Log searchLogWithTopiaId(String topiaId) {
        Log logSearch = null;
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            LogDAO logDAO = CallaoDAOHelper.getLogDAO((TopiaContext)topiaContext);
            logSearch = (Log)logDAO.findByTopiaId(topiaId);
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return logSearch;
    }

    public String removeLog(String topiaId) {
        String result = "error";
        Log logDelete = this.searchLogWithTopiaId(topiaId);
        if (logDelete == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Le log " + topiaId + " n'existe pas !"));
            }
        } else {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                LogDAO logDAO = CallaoDAOHelper.getLogDAO((TopiaContext)topiaContext);
                logDAO.delete(logDelete);
                topiaContext.commitTransaction();
                topiaContext.closeContext();
                result = "success";
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String removeLog(LogDTO logDTO) {
        String result = this.removeLog(logDTO.getId());
        return result;
    }

    public String[] getMethods() {
        return null;
    }

    public void destroy() {
    }

    public void init(TopiaContext arg0) {
    }
}

