/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Account;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.entity.Entry;
import org.chorem.callao.entity.EntryDAO;
import org.chorem.callao.entity.Transaction;
import org.chorem.callao.service.AccountServiceImpl;
import org.chorem.callao.service.LogServiceImpl;
import org.chorem.callao.service.TransactionServiceImpl;
import org.chorem.callao.service.convertObject.ConvertEntry;
import org.chorem.callao.service.dto.AccountDTO;
import org.chorem.callao.service.dto.EntryDTO;
import org.chorem.callao.service.dto.TransactionDTO;
import org.chorem.callao.service.utils.ContextCallao;
import org.chorem.callao.service.utils.NumberUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class EntryServiceImpl {
    private static final Log log = LogFactory.getLog(EntryServiceImpl.class);
    private TopiaContext rootContext = ContextCallao.getInstance().getContext();
    private LogServiceImpl logServiceImpl = new LogServiceImpl();
    private static TransactionServiceImpl transactionServiceImpl = new TransactionServiceImpl();
    private AccountServiceImpl accountServiceImpl = new AccountServiceImpl();
    private ConvertEntry convertEntry = new ConvertEntry();
    private static NumberUtil numberUtil = new NumberUtil();

    public String createEntry(String description, String amount, boolean debit, String lettering, String detail, Transaction transaction, Account account) {
        String result = this.isCorrectEntry(transaction, account);
        if (result.equals("success")) {
            result = "error";
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                EntryDAO entryDAO = CallaoDAOHelper.getEntryDAO((TopiaContext)topiaContext);
                Entry newEntry = (Entry)entryDAO.create(new Object[0]);
                newEntry.setDescription(description);
                newEntry.setAmount(numberUtil.format(amount));
                newEntry.setDebit(debit);
                newEntry.setLettering(lettering);
                newEntry.setDetail(detail);
                newEntry.setTransaction(transaction);
                newEntry.setAccount(account);
                topiaContext.commitTransaction();
                topiaContext.closeContext();
                if (log.isInfoEnabled()) {
                    log.info((Object)"Ajout avec succes de l'entr\u00e9e comptable.");
                }
                Date logDate = new Date();
                this.logServiceImpl.addLog(logDate, transaction.getTransDate(), "add", transaction.getVoucherRef(), transaction.getDescription(), detail, amount, debit, lettering);
                result = newEntry.getTopiaId();
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    public String createEntry(EntryDTO entryDTO) {
        TransactionDTO transactonDTO = entryDTO.getTransactionDTO();
        Transaction transaction = transactionServiceImpl.searchTransactionWithTopiaId(transactonDTO);
        AccountDTO accountDTO = entryDTO.getAccountDTO();
        Account account = this.accountServiceImpl.searchAccount(accountDTO.getAccountNumber());
        String result = this.createEntry(entryDTO.getDescription(), entryDTO.getAmount(), entryDTO.isDebit(), entryDTO.getLettering(), entryDTO.getDetail(), transaction, account);
        return result;
    }

    public String isCorrectEntry(Transaction transaction, Account account) {
        String result = "success";
        if (account == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Cr\u00e9ation entry : Le account n'existe pas.");
            }
            result = "account_not_exist";
        }
        if (transaction == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Cr\u00e9ation entry : La transaction n'existe pas.");
            }
            result = "transaction_not_exist";
        }
        return result;
    }

    public List<Entry> searchEntryWithTransaction(Transaction transaction) {
        List listEntry = null;
        if (transaction != null) {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                EntryDAO entryDAO = CallaoDAOHelper.getEntryDAO((TopiaContext)topiaContext);
                listEntry = entryDAO.findAllByTransaction(transaction);
                topiaContext.closeContext();
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return listEntry;
    }

    public List<EntryDTO> searchEntryDTOWithTransaction(Transaction transaction) {
        ArrayList<EntryDTO> listEntryDTO = new ArrayList<EntryDTO>();
        if (transaction != null) {
            try {
                TopiaContext topiaContext = this.rootContext.beginTransaction();
                EntryDAO entryDAO = CallaoDAOHelper.getEntryDAO((TopiaContext)topiaContext);
                List listEntry = entryDAO.findAllByTransaction(transaction);
                this.convertEntry.setTransaction(topiaContext);
                for (Entry entry : listEntry) {
                    EntryDTO entryDTO = this.convertEntry.entryEntityToDto(entry);
                    listEntryDTO.add(entryDTO);
                }
                topiaContext.closeContext();
            }
            catch (TopiaException e) {
                log.error((Object)e);
            }
        }
        return listEntryDTO;
    }

    public List<EntryDTO> searchEntryDTOWithTransaction(String transactionTopiaId) {
        ArrayList<EntryDTO> listEntryDTO = new ArrayList<EntryDTO>();
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            EntryDAO entryDAO = CallaoDAOHelper.getEntryDAO((TopiaContext)topiaContext);
            Transaction transaction = transactionServiceImpl.searchTransactionWithTopiaId(transactionTopiaId);
            if (transaction != null) {
                List listEntry = entryDAO.findAllByTransaction(transaction);
                this.convertEntry.setTransaction(topiaContext);
                for (Entry entry : listEntry) {
                    EntryDTO entryDTO = this.convertEntry.entryEntityToDto(entry);
                    listEntryDTO.add(entryDTO);
                }
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return listEntryDTO;
    }

    public List<EntryDTO> searchEntryDTOWithTransaction(TransactionDTO transactionDTO) {
        List<EntryDTO> listEntryOfTransaction = this.searchEntryDTOWithTransaction(transactionDTO.getId());
        return listEntryOfTransaction;
    }

    public String removeEntry(String topiaId) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            EntryDAO entryDAO = CallaoDAOHelper.getEntryDAO((TopiaContext)topiaContext);
            Entry entryDelete = (Entry)entryDAO.findByTopiaId(topiaId);
            if (entryDelete != null) {
                entryDAO.delete(entryDelete);
                topiaContext.commitTransaction();
                result = "success";
            } else {
                result = "entry_not_exist";
            }
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String removeEntry(EntryDTO entryDTO) {
        String result = this.removeEntry(entryDTO.getId());
        return result;
    }

    public String modifyEntry(String topiaId, String description, String amount, boolean debit, String lettering, String detail, Account account) {
        String result = "error";
        try {
            TopiaContext topiaContext = this.rootContext.beginTransaction();
            EntryDAO entryDAO = CallaoDAOHelper.getEntryDAO((TopiaContext)topiaContext);
            Entry entry = (Entry)entryDAO.findByTopiaId(topiaId);
            entry.setDescription(description);
            entry.setAmount(numberUtil.format(amount));
            entry.setDebit(debit);
            entry.setLettering(lettering);
            entry.setDetail(detail);
            entry.setAccount(account);
            entry.update();
            topiaContext.commitTransaction();
            Transaction transaction = entry.getTransaction();
            if (log.isInfoEnabled()) {
                log.info((Object)"Edit avec succes de l'entr\u00e9e comptable.");
            }
            Date logDate = new Date();
            this.logServiceImpl.addLog(logDate, transaction.getTransDate(), "modify", transaction.getVoucherRef(), transaction.getDescription(), detail, amount, debit, lettering);
            result = "success";
            topiaContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)e);
        }
        return result;
    }

    public String modifyEntry(EntryDTO entryDTO) {
        AccountDTO accountDTO = entryDTO.getAccountDTO();
        Account account = this.accountServiceImpl.searchAccount(accountDTO.getAccountNumber());
        String result = this.modifyEntry(entryDTO.getId(), entryDTO.getDescription(), entryDTO.getAmount(), entryDTO.isDebit(), entryDTO.getLettering(), entryDTO.getDetail(), account);
        return result;
    }

    public String[] getMethods() {
        return null;
    }

    public void destroy() {
    }

    public void init(TopiaContext arg0) {
    }
}

