/**
 * *##% Callao ServiceHelper
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.utils;

/**
 * Définition des messages acceptés par Callao
 * @author Rémi Chapelet
 */
public interface ServiceHelper {

    /**
     * Réponses utilisées par la couche métier Callao
     */
    public static final String RESPOND_SUCCESS = "success";
    public static final String RESPOND_ERROR = "error";

    /**
     * Account Error
     */
     public static final String ACCOUNT_DOUBLE = "account_double";
     public static final String ACCOUNT_NOT_MASTER = "account_not_master";
     public static final String ACCOUNT_NOT_EXIST = "account_not_exist";
     public static final String ACCOUNT_WITH_ENTRIES = "account_with_entries";

     /**
      * Entries Error
      */
     public static final String ENTRY_NOT_EXIST = "entry_not_exist";

     /**
      * Journal
      */
    public static final String JOURNAL_DOUBLE = "journal_double";
    public static final String JOURNAL_NOT_EXIST = "journal_not_exist";
    public static final String JOURNAL_WITH_TRANSACTIONS = "journal_with_transactions";

    /**
     * Period
     */
    public static final String PERIOD_CREATE_TIMESPANS = "period_create_timespan";
    public static final String PERIOD_TIMESPAN_NOT_BLOCK = "period_timespan_not_block";
    public static final String PERIOD_TIMESPAN_BLOCK = "period_timespan_block";
    public static final String PERIOD_ALL_TIMESPAN = "period_all_timespan";
    public static final String PERIOD_NOT_EXIST = "period_not_exist";

    /**
     * TimeSpan
     */
    public static final String TIMESPAN_PREC_NOT_BLOCK = "timespan_prec_not_block";
    public static final String TIMESPAN_NEXT_NOT_BLOCK = "timespan_next_not_block";

    /**
     * Transaction
     */
    public static final String TRANSACTION_NOT_JOURNAL = "transaction_not_journal";
    public static final String TRANSACTION_NOT_TIMESPAN = "transaction_not_timespan";
    public static final String TRANSACTION_TIMESPAN_BLOCKED = "transaction_timespan_blocked";
    public static final String TRANSACTION_NOT_EXIST = "transaction_not_exist";
    public static final String TRANSACTION_NOT_BALANCED = "transaction_not_balanced";

    /**
     * Définition des types de logs possibles
     */
    public static final String LOG_ADD = "add";
    public static final String LOG_MODIFY = "modify";
    public static final String LOG_REMOVE = "remove";
   
}