/**
 * *##% Callao ConvertTimeSpan
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.convertObject;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.TimeSpan;
import org.chorem.callao.entity.TimeSpanDAO;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.service.dto.TimeSpanDTO;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * Transforme les objets TimeSpan : DTO, DAO et entity
 *
 * @author Rémi Chapelet
 */
public class ConvertTimeSpan  extends ConvertTopiaContext {

    private static final Log log = LogFactory.getLog(ConvertTimeSpan.class);


    /**
     * Transforme un timeSpan entity en timeSpan DTO
     * @param account
     * @param accountChild
     * @return
     */
    public TimeSpanDTO timeSpanEntityToDto(TimeSpan timeSpan)
    {
        TimeSpanDTO timeSpanDTO = null;
        if (timeSpan != null)
        {
            timeSpanDTO = new TimeSpanDTO();
            timeSpanDTO.setId(timeSpan.getTopiaId());
            timeSpanDTO.setBeginTimeSpan(timeSpan.getBeginTimeSpan());
            timeSpanDTO.setEndTimeSpan(timeSpan.getEndTimeSpan());
            timeSpanDTO.setLocked(timeSpan.getLocked());
        }
        return timeSpanDTO;
    }

}