/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.chorem.callao.entity.Account;
import org.chorem.callao.entity.Entry;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class AccountAbstract
extends TopiaEntityAbstract
implements Account {
    private String label;
    private String accountNumber;
    public String type;
    public Collection<Entry> entry;
    public Account masterAccount;
    public Collection<Account> subAccount;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Account.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Account.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "label", String.class, (Object)this.label);
        visitor.visit((TopiaEntity)this, "accountNumber", String.class, (Object)this.accountNumber);
        visitor.visit((TopiaEntity)this, "type", String.class, (Object)this.type);
        visitor.visit((TopiaEntity)this, "entry", Collection.class, Entry.class, this.entry);
        visitor.visit((TopiaEntity)this, "masterAccount", Account.class, (Object)this.masterAccount);
        visitor.visit((TopiaEntity)this, "subAccount", Collection.class, Account.class, this.subAccount);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList<Account> tmp = new ArrayList<Account>();
        tmp.addAll(this.getSubAccount());
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            result.add(topiaEntity);
            result.addAll(topiaEntity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public void setLabel(String value) {
        String _oldValue = this.label;
        this.fireOnPreWrite("label", _oldValue, value);
        this.label = value;
        this.fireOnPostWrite("label", _oldValue, value);
    }

    @Override
    public String getLabel() {
        this.fireOnPreRead("label", this.label);
        String result = this.label;
        this.fireOnPostRead("label", this.label);
        return result;
    }

    @Override
    public void setAccountNumber(String value) {
        String _oldValue = this.accountNumber;
        this.fireOnPreWrite("accountNumber", _oldValue, value);
        this.accountNumber = value;
        this.fireOnPostWrite("accountNumber", _oldValue, value);
    }

    @Override
    public String getAccountNumber() {
        this.fireOnPreRead("accountNumber", this.accountNumber);
        String result = this.accountNumber;
        this.fireOnPostRead("accountNumber", this.accountNumber);
        return result;
    }

    @Override
    public void setType(String value) {
        String _oldValue = this.type;
        this.fireOnPreWrite("type", _oldValue, value);
        this.type = value;
        this.fireOnPostWrite("type", _oldValue, value);
    }

    @Override
    public String getType() {
        this.fireOnPreRead("type", this.type);
        String result = this.type;
        this.fireOnPostRead("type", this.type);
        return result;
    }

    @Override
    public void addEntry(Entry entry) {
        this.fireOnPreWrite("entry", null, entry);
        if (this.entry == null) {
            this.entry = new ArrayList<Entry>();
        }
        entry.setAccount(this);
        this.entry.add(entry);
        this.fireOnPostWrite("entry", this.entry.size(), null, entry);
    }

    @Override
    public void addAllEntry(Collection<Entry> values) {
        if (values == null) {
            return;
        }
        for (Entry item : values) {
            this.addEntry(item);
        }
    }

    @Override
    public Entry getEntryByTopiaId(String topiaId) {
        return (Entry)TopiaEntityHelper.getEntityByTopiaId(this.entry, (String)topiaId);
    }

    @Override
    public void setEntry(Collection<Entry> values) {
        Collection<Entry> _oldValue = this.entry;
        this.fireOnPreWrite("entry", _oldValue, values);
        this.entry = values;
        this.fireOnPostWrite("entry", _oldValue, values);
    }

    @Override
    public void removeEntry(Entry value) {
        this.fireOnPreWrite("entry", value, null);
        if (this.entry == null || !this.entry.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setAccount(null);
        this.fireOnPostWrite("entry", this.entry.size() + 1, value, null);
    }

    @Override
    public void clearEntry() {
        if (this.entry == null) {
            return;
        }
        for (Entry item : this.entry) {
            item.setAccount(null);
        }
        ArrayList<Entry> _oldValue = new ArrayList<Entry>(this.entry);
        this.fireOnPreWrite("entry", _oldValue, this.entry);
        this.entry.clear();
        this.fireOnPostWrite("entry", _oldValue, this.entry);
    }

    @Override
    public Collection<Entry> getEntry() {
        return this.entry;
    }

    @Override
    public int sizeEntry() {
        if (this.entry == null) {
            return 0;
        }
        return this.entry.size();
    }

    @Override
    public boolean isEntryEmpty() {
        int size = this.sizeEntry();
        return size == 0;
    }

    @Override
    public void setMasterAccount(Account value) {
        Account _oldValue = this.masterAccount;
        this.fireOnPreWrite("masterAccount", _oldValue, value);
        this.masterAccount = value;
        this.fireOnPostWrite("masterAccount", _oldValue, value);
    }

    @Override
    public Account getMasterAccount() {
        this.fireOnPreRead("masterAccount", this.masterAccount);
        Account result = this.masterAccount;
        this.fireOnPostRead("masterAccount", this.masterAccount);
        return result;
    }

    @Override
    public void addSubAccount(Account subAccount) {
        this.fireOnPreWrite("subAccount", null, subAccount);
        if (this.subAccount == null) {
            this.subAccount = new ArrayList<Account>();
        }
        subAccount.setMasterAccount(this);
        this.subAccount.add(subAccount);
        this.fireOnPostWrite("subAccount", this.subAccount.size(), null, subAccount);
    }

    @Override
    public void addAllSubAccount(Collection<Account> values) {
        if (values == null) {
            return;
        }
        for (Account item : values) {
            this.addSubAccount(item);
        }
    }

    @Override
    public Account getSubAccountByTopiaId(String topiaId) {
        return (Account)TopiaEntityHelper.getEntityByTopiaId(this.subAccount, (String)topiaId);
    }

    @Override
    public void setSubAccount(Collection<Account> values) {
        Collection<Account> _oldValue = this.subAccount;
        this.fireOnPreWrite("subAccount", _oldValue, values);
        this.subAccount = values;
        this.fireOnPostWrite("subAccount", _oldValue, values);
    }

    @Override
    public void removeSubAccount(Account value) {
        this.fireOnPreWrite("subAccount", value, null);
        if (this.subAccount == null || !this.subAccount.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setMasterAccount(null);
        this.fireOnPostWrite("subAccount", this.subAccount.size() + 1, value, null);
    }

    @Override
    public void clearSubAccount() {
        if (this.subAccount == null) {
            return;
        }
        for (Account item : this.subAccount) {
            item.setMasterAccount(null);
        }
        ArrayList<Account> _oldValue = new ArrayList<Account>(this.subAccount);
        this.fireOnPreWrite("subAccount", _oldValue, this.subAccount);
        this.subAccount.clear();
        this.fireOnPostWrite("subAccount", _oldValue, this.subAccount);
    }

    @Override
    public Collection<Account> getSubAccount() {
        return this.subAccount;
    }

    @Override
    public int sizeSubAccount() {
        if (this.subAccount == null) {
            return 0;
        }
        return this.subAccount.size();
    }

    @Override
    public boolean isSubAccountEmpty() {
        int size = this.sizeSubAccount();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("label", (Object)this.label).append("accountNumber", (Object)this.accountNumber).append("type", (Object)this.type).toString();
        return result;
    }
}

