/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Entry}.
 */
public abstract class EntryAbstract extends TopiaEntityAbstract implements Entry {

    private String description;

    private String amount;

    private boolean debit;

    private String lettering;

    public String detail;

    public Transaction transaction;

    public Account account;

    public Collection<Log> log;

    /**
     * Constructeur de EntryAbstract par défaut.
     */
    public EntryAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Entry.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Entry.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "description", String.class, description);
        visitor.visit(this, "amount", String.class, amount);
        visitor.visit(this, "debit", boolean.class, debit);
        visitor.visit(this, "lettering", String.class, lettering);
        visitor.visit(this, "detail", String.class, detail);
        visitor.visit(this, "transaction", Transaction.class, transaction);
        visitor.visit(this, "account", Account.class, account);
        visitor.visit(this, "log", Collection.class, Log.class, log);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Entry#setDescription(String)
     */
    @Override
    public void setDescription(String value) {
        String _oldValue = this.description;
        fireOnPreWrite("description", _oldValue, value);
        this.description = value;
        fireOnPostWrite("description", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Entry#getDescription()
     */
    @Override
    public String getDescription() {
        fireOnPreRead("description", description);
        String result = this.description;
        fireOnPostRead("description", description);
        return result;
    }

    /* (non-Javadoc)
     * @see Entry#setAmount(String)
     */
    @Override
    public void setAmount(String value) {
        String _oldValue = this.amount;
        fireOnPreWrite("amount", _oldValue, value);
        this.amount = value;
        fireOnPostWrite("amount", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Entry#getAmount()
     */
    @Override
    public String getAmount() {
        fireOnPreRead("amount", amount);
        String result = this.amount;
        fireOnPostRead("amount", amount);
        return result;
    }

    /* (non-Javadoc)
     * @see Entry#setDebit(boolean)
     */
    @Override
    public void setDebit(boolean value) {
        boolean _oldValue = this.debit;
        fireOnPreWrite("debit", _oldValue, value);
        this.debit = value;
        fireOnPostWrite("debit", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Entry#getDebit()
     */
    @Override
    public boolean getDebit() {
        fireOnPreRead("debit", debit);
        boolean result = this.debit;
        fireOnPostRead("debit", debit);
        return result;
    }

    /* (non-Javadoc)
     * @see Entry#setLettering(String)
     */
    @Override
    public void setLettering(String value) {
        String _oldValue = this.lettering;
        fireOnPreWrite("lettering", _oldValue, value);
        this.lettering = value;
        fireOnPostWrite("lettering", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Entry#getLettering()
     */
    @Override
    public String getLettering() {
        fireOnPreRead("lettering", lettering);
        String result = this.lettering;
        fireOnPostRead("lettering", lettering);
        return result;
    }

    /* (non-Javadoc)
     * @see Entry#setDetail(String)
     */
    @Override
    public void setDetail(String value) {
        String _oldValue = this.detail;
        fireOnPreWrite("detail", _oldValue, value);
        this.detail = value;
        fireOnPostWrite("detail", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Entry#getDetail()
     */
    @Override
    public String getDetail() {
        fireOnPreRead("detail", detail);
        String result = this.detail;
        fireOnPostRead("detail", detail);
        return result;
    }

    /* (non-Javadoc)
     * @see Entry#setTransaction(Transaction)
     */
    @Override
    public void setTransaction(Transaction value) {
        Transaction _oldValue = this.transaction;
        fireOnPreWrite("transaction", _oldValue, value);
        this.transaction = value;
        fireOnPostWrite("transaction", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Entry#getTransaction()
     */
    @Override
    public Transaction getTransaction() {
        fireOnPreRead("transaction", transaction);
        Transaction result = this.transaction;
        fireOnPostRead("transaction", transaction);
        return result;
    }

    /* (non-Javadoc)
     * @see Entry#setAccount(Account)
     */
    @Override
    public void setAccount(Account value) {
        Account _oldValue = this.account;
        fireOnPreWrite("account", _oldValue, value);
        this.account = value;
        fireOnPostWrite("account", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Entry#getAccount()
     */
    @Override
    public Account getAccount() {
        fireOnPreRead("account", account);
        Account result = this.account;
        fireOnPostRead("account", account);
        return result;
    }

    /* (non-Javadoc)
     * @see Entry#addLog(Log)
     */
    @Override
    public void addLog(Log log) {
        fireOnPreWrite("log", null, log);
        if (this.log == null) {
            this.log = new ArrayList<Log>();
        }
        log.setEntry(this);
        this.log.add(log);
        fireOnPostWrite("log", this.log.size(), null, log);
    }

    /* (non-Javadoc)
     * @see Entry#addAllLog(Collection<Log>)
     */
    @Override
    public void addAllLog(Collection<Log> values) {
        if (values == null) {
            return;
        }
        for (Log item : values) {
            addLog(item);
        }
    }

    /* (non-Javadoc)
     * @see Entry#getLogByTopiaId(String)
     */
    @Override
    public Log getLogByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(log, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Entry#setLog(Collection<Log>)
     */
    @Override
    public void setLog(Collection<Log> values) {
        Collection<Log> _oldValue = log;
        fireOnPreWrite("log", _oldValue, values);
        log = values;
        fireOnPostWrite("log", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Entry#removeLog(Log)
     */
    @Override
    public void removeLog(Log value) {
        fireOnPreWrite("log", value, null);
        if ((this.log == null) || (!this.log.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setEntry(null);
        fireOnPostWrite("log", this.log.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Entry#clearLog()
     */
    @Override
    public void clearLog() {
        if (this.log == null) {
            return;
        }
        for (Log item : this.log) {
            item.setEntry(null);
        }
        Collection<Log> _oldValue = new ArrayList<Log>(this.log);
        fireOnPreWrite("log", _oldValue, this.log);
        this.log.clear();
        fireOnPostWrite("log", _oldValue, this.log);
    }

    /* (non-Javadoc)
     * @see Entry#getLog()
     */
    @Override
    public Collection<Log> getLog() {
        return log;
    }

    /* (non-Javadoc)
     * @see Entry#sizeLog()
     */
    @Override
    public int sizeLog() {
        if (log == null) {
            return 0;
        }
        return log.size();
    }

    /* (non-Javadoc)
     * @see Entry#isLogEmpty()
     */
    @Override
    public boolean isLogEmpty() {
        int size = sizeLog();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("description", this.description).
            append("amount", this.amount).
            append("debit", this.debit).
            append("lettering", this.lettering).
            append("detail", this.detail).
         toString();
        return result;
    }
        
} //EntryAbstract
