/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.chorem.callao.entity.Entry;
import org.chorem.callao.entity.Journal;
import org.chorem.callao.entity.TimeSpan;
import org.chorem.callao.entity.Transaction;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class TransactionAbstract
extends TopiaEntityAbstract
implements Transaction {
    private Date transDate;
    private String voucherRef;
    private String description;
    public TimeSpan timeSpan;
    public Journal journal;
    public Collection<Entry> entry;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Transaction.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Transaction.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "transDate", Date.class, (Object)this.transDate);
        visitor.visit((TopiaEntity)this, "voucherRef", String.class, (Object)this.voucherRef);
        visitor.visit((TopiaEntity)this, "description", String.class, (Object)this.description);
        visitor.visit((TopiaEntity)this, "timeSpan", TimeSpan.class, (Object)this.timeSpan);
        visitor.visit((TopiaEntity)this, "journal", Journal.class, (Object)this.journal);
        visitor.visit((TopiaEntity)this, "entry", Collection.class, Entry.class, this.entry);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<Entry> tmp = new ArrayList<Entry>();
        if (this.getEntry() != null) {
            tmp.addAll(this.getEntry());
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }

    @Override
    public void setTransDate(Date value) {
        Date _oldValue = this.transDate;
        this.fireOnPreWrite("transDate", _oldValue, value);
        this.transDate = value;
        this.fireOnPostWrite("transDate", _oldValue, value);
    }

    @Override
    public Date getTransDate() {
        this.fireOnPreRead("transDate", this.transDate);
        Date result = this.transDate;
        this.fireOnPostRead("transDate", this.transDate);
        return result;
    }

    @Override
    public void setVoucherRef(String value) {
        String _oldValue = this.voucherRef;
        this.fireOnPreWrite("voucherRef", _oldValue, value);
        this.voucherRef = value;
        this.fireOnPostWrite("voucherRef", _oldValue, value);
    }

    @Override
    public String getVoucherRef() {
        this.fireOnPreRead("voucherRef", this.voucherRef);
        String result = this.voucherRef;
        this.fireOnPostRead("voucherRef", this.voucherRef);
        return result;
    }

    @Override
    public void setDescription(String value) {
        String _oldValue = this.description;
        this.fireOnPreWrite("description", _oldValue, value);
        this.description = value;
        this.fireOnPostWrite("description", _oldValue, value);
    }

    @Override
    public String getDescription() {
        this.fireOnPreRead("description", this.description);
        String result = this.description;
        this.fireOnPostRead("description", this.description);
        return result;
    }

    @Override
    public void setTimeSpan(TimeSpan value) {
        TimeSpan _oldValue = this.timeSpan;
        this.fireOnPreWrite("timeSpan", _oldValue, value);
        this.timeSpan = value;
        this.fireOnPostWrite("timeSpan", _oldValue, value);
    }

    @Override
    public TimeSpan getTimeSpan() {
        this.fireOnPreRead("timeSpan", this.timeSpan);
        TimeSpan result = this.timeSpan;
        this.fireOnPostRead("timeSpan", this.timeSpan);
        return result;
    }

    @Override
    public void setJournal(Journal value) {
        Journal _oldValue = this.journal;
        this.fireOnPreWrite("journal", _oldValue, value);
        this.journal = value;
        this.fireOnPostWrite("journal", _oldValue, value);
    }

    @Override
    public Journal getJournal() {
        this.fireOnPreRead("journal", this.journal);
        Journal result = this.journal;
        this.fireOnPostRead("journal", this.journal);
        return result;
    }

    @Override
    public void addEntry(Entry entry) {
        this.fireOnPreWrite("entry", null, entry);
        if (this.entry == null) {
            this.entry = new ArrayList<Entry>();
        }
        entry.setTransaction(this);
        this.entry.add(entry);
        this.fireOnPostWrite("entry", this.entry.size(), null, entry);
    }

    @Override
    public void addAllEntry(Collection<Entry> values) {
        if (values == null) {
            return;
        }
        for (Entry item : values) {
            this.addEntry(item);
        }
    }

    @Override
    public Entry getEntryByTopiaId(String topiaId) {
        return (Entry)TopiaEntityHelper.getEntityByTopiaId(this.entry, (String)topiaId);
    }

    @Override
    public void setEntry(Collection<Entry> values) {
        Collection<Entry> _oldValue = this.entry;
        this.fireOnPreWrite("entry", _oldValue, values);
        this.entry = values;
        this.fireOnPostWrite("entry", _oldValue, values);
    }

    @Override
    public void removeEntry(Entry value) {
        this.fireOnPreWrite("entry", value, null);
        if (this.entry == null || !this.entry.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setTransaction(null);
        this.fireOnPostWrite("entry", this.entry.size() + 1, value, null);
    }

    @Override
    public void clearEntry() {
        if (this.entry == null) {
            return;
        }
        for (Entry item : this.entry) {
            item.setTransaction(null);
        }
        ArrayList<Entry> _oldValue = new ArrayList<Entry>(this.entry);
        this.fireOnPreWrite("entry", _oldValue, this.entry);
        this.entry.clear();
        this.fireOnPostWrite("entry", _oldValue, this.entry);
    }

    @Override
    public Collection<Entry> getEntry() {
        return this.entry;
    }

    @Override
    public int sizeEntry() {
        if (this.entry == null) {
            return 0;
        }
        return this.entry.size();
    }

    @Override
    public boolean isEntryEmpty() {
        int size = this.sizeEntry();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("transDate", (Object)this.transDate).append("voucherRef", (Object)this.voucherRef).append("description", (Object)this.description).toString();
        return result;
    }
}

