/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Journal}.
 */
public abstract class JournalAbstract extends TopiaEntityAbstract implements Journal {

    private String label;

    private String prefix;

    public String description;

    public Collection<Transaction> transaction;

    /**
     * Constructeur de JournalAbstract par défaut.
     */
    public JournalAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Journal.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Journal.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "label", String.class, label);
        visitor.visit(this, "prefix", String.class, prefix);
        visitor.visit(this, "description", String.class, description);
        visitor.visit(this, "transaction", Collection.class, Transaction.class, transaction);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getTransaction() != null) {
              tmp.addAll(getTransaction());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Journal#setLabel(String)
     */
    @Override
    public void setLabel(String value) {
        String _oldValue = this.label;
        fireOnPreWrite("label", _oldValue, value);
        this.label = value;
        fireOnPostWrite("label", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Journal#getLabel()
     */
    @Override
    public String getLabel() {
        fireOnPreRead("label", label);
        String result = this.label;
        fireOnPostRead("label", label);
        return result;
    }

    /* (non-Javadoc)
     * @see Journal#setPrefix(String)
     */
    @Override
    public void setPrefix(String value) {
        String _oldValue = this.prefix;
        fireOnPreWrite("prefix", _oldValue, value);
        this.prefix = value;
        fireOnPostWrite("prefix", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Journal#getPrefix()
     */
    @Override
    public String getPrefix() {
        fireOnPreRead("prefix", prefix);
        String result = this.prefix;
        fireOnPostRead("prefix", prefix);
        return result;
    }

    /* (non-Javadoc)
     * @see Journal#setDescription(String)
     */
    @Override
    public void setDescription(String value) {
        String _oldValue = this.description;
        fireOnPreWrite("description", _oldValue, value);
        this.description = value;
        fireOnPostWrite("description", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Journal#getDescription()
     */
    @Override
    public String getDescription() {
        fireOnPreRead("description", description);
        String result = this.description;
        fireOnPostRead("description", description);
        return result;
    }

    /* (non-Javadoc)
     * @see Journal#addTransaction(Transaction)
     */
    @Override
    public void addTransaction(Transaction transaction) {
        fireOnPreWrite("transaction", null, transaction);
        if (this.transaction == null) {
            this.transaction = new ArrayList<Transaction>();
        }
        transaction.setJournal(this);
        this.transaction.add(transaction);
        fireOnPostWrite("transaction", this.transaction.size(), null, transaction);
    }

    /* (non-Javadoc)
     * @see Journal#addAllTransaction(Collection<Transaction>)
     */
    @Override
    public void addAllTransaction(Collection<Transaction> values) {
        if (values == null) {
            return;
        }
        for (Transaction item : values) {
            addTransaction(item);
        }
    }

    /* (non-Javadoc)
     * @see Journal#getTransactionByTopiaId(String)
     */
    @Override
    public Transaction getTransactionByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(transaction, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Journal#setTransaction(Collection<Transaction>)
     */
    @Override
    public void setTransaction(Collection<Transaction> values) {
        Collection<Transaction> _oldValue = transaction;
        fireOnPreWrite("transaction", _oldValue, values);
        transaction = values;
        fireOnPostWrite("transaction", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Journal#removeTransaction(Transaction)
     */
    @Override
    public void removeTransaction(Transaction value) {
        fireOnPreWrite("transaction", value, null);
        if ((this.transaction == null) || (!this.transaction.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setJournal(null);
        fireOnPostWrite("transaction", this.transaction.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Journal#clearTransaction()
     */
    @Override
    public void clearTransaction() {
        if (this.transaction == null) {
            return;
        }
        for (Transaction item : this.transaction) {
            item.setJournal(null);
        }
        Collection<Transaction> _oldValue = new ArrayList<Transaction>(this.transaction);
        fireOnPreWrite("transaction", _oldValue, this.transaction);
        this.transaction.clear();
        fireOnPostWrite("transaction", _oldValue, this.transaction);
    }

    /* (non-Javadoc)
     * @see Journal#getTransaction()
     */
    @Override
    public Collection<Transaction> getTransaction() {
        return transaction;
    }

    /* (non-Javadoc)
     * @see Journal#sizeTransaction()
     */
    @Override
    public int sizeTransaction() {
        if (transaction == null) {
            return 0;
        }
        return transaction.size();
    }

    /* (non-Javadoc)
     * @see Journal#isTransactionEmpty()
     */
    @Override
    public boolean isTransactionEmpty() {
        int size = sizeTransaction();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("label", this.label).
            append("prefix", this.prefix).
            append("description", this.description).
         toString();
        return result;
    }
        
} //JournalAbstract
