/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Journal.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class JournalDAOAbstract<E extends Journal> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Journal.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.callao.entity.Transaction> list = getContext()
                            .getDAO(org.chorem.callao.entity.Transaction.class)
                            .findAllByProperties("journal", entity);
                    for (org.chorem.callao.entity.Transaction item : list) {
                        item.setJournal(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut label
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * label le paramètre
     * @param v la valeur que doit avoir label
     * @return un element ou null
     */
    public E findByLabel(java.lang.String v) throws TopiaException {
        E result = findByProperty("label", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * label le paramètre
     * @param v la valeur que doit avoir label
     * @return une liste
     */
    public List<E> findAllByLabel(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("label", v);
        return result;
    }
    /**
     * Recherche sur l'attribut prefix
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * prefix le paramètre
     * @param v la valeur que doit avoir prefix
     * @return un element ou null
     */
    public E findByPrefix(java.lang.String v) throws TopiaException {
        E result = findByProperty("prefix", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * prefix le paramètre
     * @param v la valeur que doit avoir prefix
     * @return une liste
     */
    public List<E> findAllByPrefix(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("prefix", v);
        return result;
    }
    /**
     * Recherche sur l'attribut description
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return un element ou null
     */
    public E findByDescription(java.lang.String v) throws TopiaException {
        E result = findByProperty("description", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return une liste
     */
    public List<E> findAllByDescription(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("description", v);
        return result;
    }
    /**
     * Recherche sur l'attribut transaction
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * transaction contient le paramètre
     * @param v la valeur que doit contenir transaction
     * @return un element ou null
     */
    public E findContainsTransaction(org.chorem.callao.entity.Transaction ... v) throws TopiaException {
        E result = findContainsProperties("transaction", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * transaction contient le paramètre
     * @param v la valeur que doit contenir transaction
     * @return une liste
     */
    public List<E> findAllContainsTransaction(org.chorem.callao.entity.Transaction ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("transaction", Arrays.asList(v));
        return results;
    }

} // JournalDAOAbstract
