/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Account}.
 */
public abstract class AccountAbstract extends TopiaEntityAbstract implements Account {

    private String label;

    private String accountNumber;

    public String type;

    public Collection<Entry> entry;

    public Account masterAccount;

    public Collection<Account> subAccount;

    /**
     * Constructeur de AccountAbstract par défaut.
     */
    public AccountAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Account.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Account.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "label", String.class, label);
        visitor.visit(this, "accountNumber", String.class, accountNumber);
        visitor.visit(this, "type", String.class, type);
        visitor.visit(this, "entry", Collection.class, Entry.class, entry);
        visitor.visit(this, "masterAccount", Account.class, masterAccount);
        visitor.visit(this, "subAccount", Collection.class, Account.class, subAccount);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.addAll(getSubAccount());

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Account#setLabel(String)
     */
    @Override
    public void setLabel(String value) {
        String _oldValue = this.label;
        fireOnPreWrite("label", _oldValue, value);
        this.label = value;
        fireOnPostWrite("label", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Account#getLabel()
     */
    @Override
    public String getLabel() {
        fireOnPreRead("label", label);
        String result = this.label;
        fireOnPostRead("label", label);
        return result;
    }

    /* (non-Javadoc)
     * @see Account#setAccountNumber(String)
     */
    @Override
    public void setAccountNumber(String value) {
        String _oldValue = this.accountNumber;
        fireOnPreWrite("accountNumber", _oldValue, value);
        this.accountNumber = value;
        fireOnPostWrite("accountNumber", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Account#getAccountNumber()
     */
    @Override
    public String getAccountNumber() {
        fireOnPreRead("accountNumber", accountNumber);
        String result = this.accountNumber;
        fireOnPostRead("accountNumber", accountNumber);
        return result;
    }

    /* (non-Javadoc)
     * @see Account#setType(String)
     */
    @Override
    public void setType(String value) {
        String _oldValue = this.type;
        fireOnPreWrite("type", _oldValue, value);
        this.type = value;
        fireOnPostWrite("type", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Account#getType()
     */
    @Override
    public String getType() {
        fireOnPreRead("type", type);
        String result = this.type;
        fireOnPostRead("type", type);
        return result;
    }

    /* (non-Javadoc)
     * @see Account#addEntry(Entry)
     */
    @Override
    public void addEntry(Entry entry) {
        fireOnPreWrite("entry", null, entry);
        if (this.entry == null) {
            this.entry = new ArrayList<Entry>();
        }
        entry.setAccount(this);
        this.entry.add(entry);
        fireOnPostWrite("entry", this.entry.size(), null, entry);
    }

    /* (non-Javadoc)
     * @see Account#addAllEntry(Collection<Entry>)
     */
    @Override
    public void addAllEntry(Collection<Entry> values) {
        if (values == null) {
            return;
        }
        for (Entry item : values) {
            addEntry(item);
        }
    }

    /* (non-Javadoc)
     * @see Account#getEntryByTopiaId(String)
     */
    @Override
    public Entry getEntryByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(entry, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Account#setEntry(Collection<Entry>)
     */
    @Override
    public void setEntry(Collection<Entry> values) {
        Collection<Entry> _oldValue = entry;
        fireOnPreWrite("entry", _oldValue, values);
        entry = values;
        fireOnPostWrite("entry", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Account#removeEntry(Entry)
     */
    @Override
    public void removeEntry(Entry value) {
        fireOnPreWrite("entry", value, null);
        if ((this.entry == null) || (!this.entry.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setAccount(null);
        fireOnPostWrite("entry", this.entry.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Account#clearEntry()
     */
    @Override
    public void clearEntry() {
        if (this.entry == null) {
            return;
        }
        for (Entry item : this.entry) {
            item.setAccount(null);
        }
        Collection<Entry> _oldValue = new ArrayList<Entry>(this.entry);
        fireOnPreWrite("entry", _oldValue, this.entry);
        this.entry.clear();
        fireOnPostWrite("entry", _oldValue, this.entry);
    }

    /* (non-Javadoc)
     * @see Account#getEntry()
     */
    @Override
    public Collection<Entry> getEntry() {
        return entry;
    }

    /* (non-Javadoc)
     * @see Account#sizeEntry()
     */
    @Override
    public int sizeEntry() {
        if (entry == null) {
            return 0;
        }
        return entry.size();
    }

    /* (non-Javadoc)
     * @see Account#isEntryEmpty()
     */
    @Override
    public boolean isEntryEmpty() {
        int size = sizeEntry();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Account#setMasterAccount(Account)
     */
    @Override
    public void setMasterAccount(Account value) {
        Account _oldValue = this.masterAccount;
        fireOnPreWrite("masterAccount", _oldValue, value);
        this.masterAccount = value;
        fireOnPostWrite("masterAccount", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Account#getMasterAccount()
     */
    @Override
    public Account getMasterAccount() {
        fireOnPreRead("masterAccount", masterAccount);
        Account result = this.masterAccount;
        fireOnPostRead("masterAccount", masterAccount);
        return result;
    }

    /* (non-Javadoc)
     * @see Account#addSubAccount(Account)
     */
    @Override
    public void addSubAccount(Account subAccount) {
        fireOnPreWrite("subAccount", null, subAccount);
        if (this.subAccount == null) {
            this.subAccount = new ArrayList<Account>();
        }
        subAccount.setMasterAccount(this);
        this.subAccount.add(subAccount);
        fireOnPostWrite("subAccount", this.subAccount.size(), null, subAccount);
    }

    /* (non-Javadoc)
     * @see Account#addAllSubAccount(Collection<Account>)
     */
    @Override
    public void addAllSubAccount(Collection<Account> values) {
        if (values == null) {
            return;
        }
        for (Account item : values) {
            addSubAccount(item);
        }
    }

    /* (non-Javadoc)
     * @see Account#getSubAccountByTopiaId(String)
     */
    @Override
    public Account getSubAccountByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(subAccount, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Account#setSubAccount(Collection<Account>)
     */
    @Override
    public void setSubAccount(Collection<Account> values) {
        Collection<Account> _oldValue = subAccount;
        fireOnPreWrite("subAccount", _oldValue, values);
        subAccount = values;
        fireOnPostWrite("subAccount", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Account#removeSubAccount(Account)
     */
    @Override
    public void removeSubAccount(Account value) {
        fireOnPreWrite("subAccount", value, null);
        if ((this.subAccount == null) || (!this.subAccount.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setMasterAccount(null);
        fireOnPostWrite("subAccount", this.subAccount.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Account#clearSubAccount()
     */
    @Override
    public void clearSubAccount() {
        if (this.subAccount == null) {
            return;
        }
        for (Account item : this.subAccount) {
            item.setMasterAccount(null);
        }
        Collection<Account> _oldValue = new ArrayList<Account>(this.subAccount);
        fireOnPreWrite("subAccount", _oldValue, this.subAccount);
        this.subAccount.clear();
        fireOnPostWrite("subAccount", _oldValue, this.subAccount);
    }

    /* (non-Javadoc)
     * @see Account#getSubAccount()
     */
    @Override
    public Collection<Account> getSubAccount() {
        return subAccount;
    }

    /* (non-Javadoc)
     * @see Account#sizeSubAccount()
     */
    @Override
    public int sizeSubAccount() {
        if (subAccount == null) {
            return 0;
        }
        return subAccount.size();
    }

    /* (non-Javadoc)
     * @see Account#isSubAccountEmpty()
     */
    @Override
    public boolean isSubAccountEmpty() {
        int size = sizeSubAccount();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("label", this.label).
            append("accountNumber", this.accountNumber).
            append("type", this.type).
         toString();
        return result;
    }
        
} //AccountAbstract
