/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.info;

import java.util.Date;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.DCEReadable;
import org.alfresco.jlan.util.StringList;

public class EventlogRecord
implements DCEReadable {
    public static final int TypeSuccess = 0;
    public static final int TypeError = 1;
    public static final int TypeWarning = 2;
    public static final int TypeInformation = 4;
    public static final int TypeAuditSuccess = 8;
    public static final int TypeAuditFailure = 16;
    public static final int IdSeverityMask = Integer.MIN_VALUE;
    public static final int IdCustomerCode = 0x20000000;
    public static final int IdFacilityMask = 0xFFF0000;
    public static final int IdEventCodeMask = 65535;
    public static final int SeveritySuccess = 0;
    public static final int SeverityInfo = 0x40000000;
    public static final int SeverityWarn = Integer.MIN_VALUE;
    public static final int SeverityError = -1073741824;
    private int m_recno;
    private Date m_timeGenerated;
    private Date m_timeWritten;
    private int m_eventId;
    private int m_eventType;
    private int m_eventCategory;
    private String m_source;
    private String m_computer;
    private StringList m_strings;

    public final int getRecordNumber() {
        return this.m_recno;
    }

    public final Date getTimeGenerated() {
        return this.m_timeGenerated;
    }

    public final Date getTimeWritten() {
        return this.m_timeWritten;
    }

    public final int getRawEventId() {
        return this.m_eventId;
    }

    public final int getEventId() {
        return this.m_eventId & 0xFFFF;
    }

    public final int getEventSeverity() {
        return this.m_eventId & Integer.MIN_VALUE;
    }

    public final int getEventFacility() {
        return (this.m_eventId & 0xFFF0000) >> 16;
    }

    public final boolean isCustomerEvent() {
        return (this.m_eventId & 0x20000000) != 0;
    }

    public final int getEventType() {
        return this.m_eventType;
    }

    public final String getEventTypeAsString() {
        String typ = "";
        switch (this.m_eventType) {
            case 0: {
                typ = "Success";
                break;
            }
            case 1: {
                typ = "Error";
                break;
            }
            case 2: {
                typ = "Warning";
                break;
            }
            case 4: {
                typ = "Information";
                break;
            }
            case 8: {
                typ = "AuditSuccess";
                break;
            }
            case 16: {
                typ = "AuditFailure";
            }
        }
        return typ;
    }

    public final String getEventSeverityAsString() {
        String sev = "";
        switch (this.getEventSeverity()) {
            case 0: {
                sev = "Success";
                break;
            }
            case 0x40000000: {
                sev = "Info";
                break;
            }
            case -2147483648: {
                sev = "Warn";
                break;
            }
            case -1073741824: {
                sev = "Error";
            }
        }
        return sev;
    }

    public final int getEventCategory() {
        return this.m_eventCategory;
    }

    public final String getEventSource() {
        return this.m_source;
    }

    public final String getEventHost() {
        return this.m_computer;
    }

    public final StringList getEventStringList() {
        return this.m_strings;
    }

    public final String getEventString() {
        if (this.m_strings == null || this.m_strings.numberOfStrings() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder(256);
        for (int i = 0; i < this.m_strings.numberOfStrings(); ++i) {
            str.append(this.m_strings.getStringAt(i));
            str.append(", ");
        }
        if (str.length() > 0) {
            str.setLength(str.length() - 1);
        }
        return str.toString();
    }

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        int rdpos = buf.getReadPosition();
        int reclen = buf.getInt();
        if (reclen == 0) {
            throw new DCEBufferException("No more event records");
        }
        buf.skipPointer();
        this.m_recno = buf.getInt();
        long timeVal = (long)buf.getInt() & 0xFFFFFFFFL;
        if (timeVal != 0L) {
            this.m_timeGenerated = new Date(timeVal * 1000L);
        }
        if ((timeVal = (long)buf.getInt() & 0xFFFFFFFFL) != 0L) {
            this.m_timeWritten = new Date(timeVal * 1000L);
        }
        this.m_eventId = buf.getInt();
        this.m_eventType = buf.getShort();
        int numStrs = buf.getShort();
        this.m_eventCategory = buf.getShort();
        buf.skipBytes(6);
        int strOff = buf.getInt();
        int sidLen = buf.getInt();
        int sidOff = buf.getInt();
        int datLen = buf.getInt();
        int datOff = buf.getInt();
        this.m_source = buf.getUnicodeString();
        this.m_computer = buf.getUnicodeString();
        buf.skipBytes(sidLen);
        if ((buf.getReadPosition() + 3 & 0xFFFFFFFC) != buf.getReadPosition()) {
            buf.getShort();
        }
        this.m_strings = new StringList();
        for (int i = 0; i < numStrs; ++i) {
            String s = buf.getUnicodeString();
            if (s != null && s.endsWith("\r\n")) {
                s = s.substring(0, s.length() - 2);
            }
            this.m_strings.addString(s);
        }
        buf.positionAt(rdpos + reclen);
    }

    @Override
    public void readStrings(DCEBuffer buf) throws DCEBufferException {
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getEventHost());
        str.append(":");
        str.append(this.getEventSource());
        str.append(",");
        str.append(this.getEventSeverityAsString());
        str.append(",0x");
        str.append(Integer.toHexString(this.getEventId()));
        str.append(",");
        str.append(Integer.toHexString(this.getEventType()));
        str.append(" - ");
        str.append(this.getEventString());
        str.append("]");
        return str.toString();
    }
}

