/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.ntlm;

import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;

public class Type1NTLMMessage
extends NTLMMessage {
    public static final int MinimalMessageLength = 16;
    public static final int OffsetFlags = 12;
    public static final int OffsetData = 16;

    public Type1NTLMMessage() {
    }

    public Type1NTLMMessage(byte[] buf) {
        super(buf, 0, buf.length);
    }

    public Type1NTLMMessage(byte[] buf, int offset, int len) {
        super(buf, offset, len);
    }

    @Override
    public int getFlags() {
        return this.getIntValue(12);
    }

    public final boolean hasDomain() {
        return this.getLength() != 16 && this.hasFlag(4096);
    }

    public final String getDomain() {
        if (!this.hasFlag(4096)) {
            return null;
        }
        return this.getStringValue(16, false);
    }

    public final boolean hasWorkstation() {
        return this.getLength() != 16 && this.hasFlag(8192);
    }

    public final String getWorkstation() {
        if (!this.hasFlag(8192)) {
            return null;
        }
        int bufPos = 16;
        if (this.hasFlag(4096)) {
            bufPos += 8;
        }
        return this.getStringValue(bufPos, false);
    }

    public final void buildType1(int flags, String domain, String workstation) {
        int bufPos = 16;
        int strOff = 16;
        if (domain != null) {
            strOff += 8;
        }
        if (workstation != null) {
            strOff += 8;
        }
        if (domain != null) {
            strOff = this.setStringValue(bufPos, domain, strOff, false);
            flags |= 0x1000;
            bufPos += 8;
        }
        if (workstation != null) {
            strOff = this.setStringValue(bufPos, workstation, strOff, false);
            flags |= 0x2000;
        }
        this.initializeHeader(1, flags);
        this.setLength(strOff);
    }

    @Override
    protected void setFlags(int flags) {
        this.setIntValue(12, flags);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Type1:0x");
        str.append(Integer.toHexString(this.getFlags()));
        str.append(",Domain:");
        if (this.hasDomain()) {
            str.append(this.getDomain());
        } else {
            str.append("<NotSet>");
        }
        str.append(",Wks:");
        if (this.hasWorkstation()) {
            str.append(this.getWorkstation());
        } else {
            str.append("<NotSet>");
        }
        str.append("]");
        return str.toString();
    }
}

